"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/utils.ts
var utils_exports = {};
__export(utils_exports, {
  convertDeviceListStateToFilters: () => convertDeviceListStateToFilters,
  ensureVersionString: () => ensureVersionString,
  extractErrorMessage: () => extractErrorMessage,
  filtersFilter: () => filtersFilter,
  generateDeploymentGroupDetails: () => generateDeploymentGroupDetails,
  getComparisonCompatibleVersion: () => getComparisonCompatibleVersion,
  getDeploymentState: () => getDeploymentState,
  groupDeploymentDevicesStats: () => groupDeploymentDevicesStats,
  groupDeploymentStats: () => groupDeploymentStats,
  isDarkMode: () => isDarkMode,
  listItemMapper: () => listItemMapper,
  mapDeviceAttributes: () => mapDeviceAttributes,
  mapFiltersToTerms: () => mapFiltersToTerms,
  mapTermsToFilters: () => mapTermsToFilters,
  mapUserRolesToUiPermissions: () => mapUserRolesToUiPermissions,
  mergePermissions: () => mergePermissions,
  parseSubscriptionPreview: () => parseSubscriptionPreview,
  progress: () => progress,
  statCollector: () => statCollector,
  stringToBoolean: () => stringToBoolean
});
module.exports = __toCommonJS(utils_exports);
var import_helpers = require("@northern.tech/utils/helpers");

// src/constants.ts
var import_constants4 = require("@northern.tech/utils/constants");

// src/appSlice/constants.ts
var import_icons_material = require("@mui/icons-material");
var startingDeviceCount = {
  os: "for first 50 devices",
  professional: "for first 250 devices"
};
var chartTypes = {
  bar: { key: "bar", Icon: import_icons_material.BarChart },
  pie: { key: "pie", Icon: import_icons_material.PieChartOutline }
};
var emptyChartSelection = { software: "", group: "", chartType: chartTypes.bar.key, attribute: "artifact_name" };
var defaultReportType = "distribution";
var defaultReports = [{ ...emptyChartSelection, group: null, attribute: "artifact_name", type: defaultReportType }];
var PLANS = {
  os: {
    id: "os",
    name: "Basic",
    minimalDeviceCount: 50,
    offer: true,
    price: "$34 / month",
    deviceCount: startingDeviceCount.os,
    description: "The core features of Mender. To continue using Enterprise Trial features\u2014like Delta updates, scheduled deployments, phased rollouts, device filtering, dynamic groups, RBAC, audit logs, and more\u2014please upgrade to a higher plan.",
    features: ["Access to core features of Mender", "Basic support"]
  },
  professional: {
    id: "professional",
    name: "Professional",
    minimalDeviceCount: 250,
    offer: true,
    price: "$291 / month",
    deviceCount: startingDeviceCount.professional,
    description: "Everything in Basic, plus enhanced update management and automation features.",
    features: ["Advanced OTA features", "Higher priority support"]
  },
  enterprise: {
    id: "enterprise",
    name: "Enterprise",
    minimalDeviceCount: 1e3,
    price: "Custom pricing",
    deviceCount: "Unlimited devices",
    description: "Every advanced feature of Mender, tailored for complex and large-scale deployments. Not available as a monthly subscription \u2014 ask us for a quote.",
    features: ["All Mender features", "Advanced security features", "SLA-backed support"]
  }
};
var ADDONS = {
  configure: {
    id: "configure",
    title: "Configure",
    description: "Expand your plan with device configuration features",
    needs: ["hasDeviceConfig"],
    os: {
      price: "$11/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$65/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  },
  monitor: {
    id: "monitor",
    title: "Monitor",
    description: "Expand your plan with device monitoring features",
    needs: ["hasMonitor"],
    os: {
      price: "-",
      deviceCount: "-"
    },
    professional: {
      price: "$86/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["professional", "enterprise"]
  },
  troubleshoot: {
    id: "troubleshoot",
    title: "Troubleshoot",
    description: "Expand your plan with device troubleshooting features",
    needs: ["hasDeviceConnect"],
    os: {
      price: "$27/month",
      deviceCount: startingDeviceCount.os
    },
    professional: {
      price: "$72/month",
      deviceCount: startingDeviceCount.professional
    },
    eligible: ["os", "professional", "enterprise"]
  }
};
var BENEFITS = {
  auditlog: { id: "auditlog", benefit: "trace change across your devices and access troubleshooting session replay", requiredPlan: PLANS.professional.id },
  dashboard: { id: "dashboard", benefit: "actionable insights into the devices you are updating with Mender", requiredPlan: PLANS.enterprise.id },
  deltaGeneration: {
    id: "deltaGeneration",
    benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery",
    requiredPlan: PLANS.enterprise.id
  },
  deviceConfiguration: { id: "deviceConfiguration", benefit: "device configuration features", requiredAddon: ADDONS.configure.id },
  deviceMonitor: { id: "deviceMonitor", benefit: "device monitoring features", requiredAddon: ADDONS.monitor.id, requiredPlan: PLANS.professional.id },
  deviceTroubleshoot: { id: "deviceTroubleshoot", benefit: "device troubleshooting features", requiredAddon: ADDONS.troubleshoot.id },
  dynamicGroups: { id: "dynamicGroups", benefit: "create dynamic groups to ease device management", requiredPlan: PLANS.enterprise.id },
  fullFiltering: { id: "fullFiltering", benefit: "filtering by multiple attributes to improve the device overview", requiredPlan: PLANS.professional.id },
  gateway: { id: "gateway", benefit: "see devices connected to your gateway device for easy access", requiredPlans: PLANS.professional.id },
  pausedDeployments: {
    id: "pausedDeployments",
    benefit: "granular control about update rollout to allow synchronization across your fleet",
    requiredPlan: PLANS.enterprise.id
  },
  phasedDeployments: { id: "phasedDeployments", benefit: "choose to roll out deployments in multiple phases", requiredPlan: PLANS.enterprise.id },
  rbac: { id: "rbac", benefit: "granular role based access control", requiredPlan: PLANS.enterprise.id },
  retryDeployments: { id: "retryDeployments", benefit: "optional retries for failed rollout attempts", requiredPlan: PLANS.professional.id },
  scheduledDeployments: {
    id: "scheduledDeployments",
    benefit: "scheduled deployments to steer the distribution of your updates.",
    requiredPlan: PLANS.professional.id
  },
  webhookEvents: {
    id: "webhookEvents",
    benefit: "receive inventory events and select which type(s) of events the webhook will receive",
    requiredPlan: PLANS.professional.id
  },
  default: { id: "default", benefit: "gain access to this feature", requiredPlan: PLANS.enterprise.id }
};
var DARK_MODE = "dark";

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var DEVICE_LIST_MAXIMUM_LENGTH = 50;
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants4.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants4.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants4.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants4.SORTING_OPTIONS.desc }
};
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentDisplayStates = {
  finished: "Finished",
  scheduled: "Scheduled",
  skipped: "Skipped",
  paused: "Paused",
  pending: "Pending",
  inprogress: "In Progress",
  success: "Success",
  successes: "Success",
  failure: "Fail",
  failures: "Fail"
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/devicesSlice/constants.ts
var emptyFilter = { key: null, value: "", operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "inventory" };
var geoAttributes = ["geo-lat", "geo-lon"].map((attribute) => ({ attribute, scope: "inventory" }));

// src/releasesSlice/constants.ts
var softwareIndicator = ".version";
var rootfsImageVersion = "rootfs-image.version";
var softwareTitleMap = { [rootfsImageVersion]: { title: "Root filesystem", priority: 0, key: rootfsImageVersion } };

// src/utils.ts
var filterProcessors = {
  [import_constants4.DEVICE_FILTERING_OPTIONS.$gt.key]: (val) => Number(val) || val,
  [import_constants4.DEVICE_FILTERING_OPTIONS.$gte.key]: (val) => Number(val) || val,
  [import_constants4.DEVICE_FILTERING_OPTIONS.$lt.key]: (val) => Number(val) || val,
  [import_constants4.DEVICE_FILTERING_OPTIONS.$lte.key]: (val) => Number(val) || val,
  [import_constants4.DEVICE_FILTERING_OPTIONS.$ltne.key]: (val) => Number(val) || val,
  [import_constants4.DEVICE_FILTERING_OPTIONS.$in.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants4.DEVICE_FILTERING_OPTIONS.$nin.key]: (val) => ("" + val).split(",").map((i) => i.trim()),
  [import_constants4.DEVICE_FILTERING_OPTIONS.$exists.key]: import_helpers.yes,
  [import_constants4.DEVICE_FILTERING_OPTIONS.$nexists.key]: () => false
};
var filterAliases = {
  $nexists: { alias: import_constants4.DEVICE_FILTERING_OPTIONS.$exists.key, value: false }
};
var mapFiltersToTerms = (filters) => filters.map((filter) => ({
  scope: filter.scope,
  attribute: filter.key,
  type: filterAliases[filter.operator]?.alias || filter.operator,
  value: filterProcessors.hasOwnProperty(filter.operator) ? filterProcessors[filter.operator](filter.value) : filter.value
}));
var mapTermsToFilters = (terms) => terms.map((term) => {
  const aliasedFilter = Object.entries(filterAliases).find(
    (aliasDefinition) => aliasDefinition[1].alias === term.type && aliasDefinition[1].value === term.value
  );
  const operator = aliasedFilter ? aliasedFilter[0] : term.type;
  return { scope: term.scope, key: term.attribute, operator, value: term.value };
});
var convertIssueOptionsToFilters = (issuesSelection, filtersState = {}) => issuesSelection.map((item) => {
  if (typeof import_constants4.DEVICE_ISSUE_OPTIONS[item].filterRule.value === "function") {
    return { ...import_constants4.DEVICE_ISSUE_OPTIONS[item].filterRule, value: import_constants4.DEVICE_ISSUE_OPTIONS[item].filterRule.value(filtersState) };
  }
  return import_constants4.DEVICE_ISSUE_OPTIONS[item].filterRule;
});
var convertDeviceListStateToFilters = ({
  filters = [],
  group,
  groups = { byId: {} },
  offlineThreshold,
  selectedIssues = [],
  status
}) => {
  let applicableFilters = [...filters];
  if (typeof group === "string" && !(groups.byId[group]?.filters || applicableFilters).length) {
    applicableFilters.push({ key: "group", value: group, operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "system" });
  }
  const nonMonitorFilters = applicableFilters.filter(
    (filter) => !Object.values(import_constants4.DEVICE_ISSUE_OPTIONS).some(
      ({ filterRule }) => filter.scope !== "inventory" && filterRule.scope === filter.scope && filterRule.key === filter.key
    )
  );
  const deviceIssueFilters = convertIssueOptionsToFilters(selectedIssues, { offlineThreshold });
  applicableFilters = [...nonMonitorFilters, ...deviceIssueFilters];
  const effectiveFilters = status ? [...applicableFilters, { key: "status", value: status, operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "identity" }] : applicableFilters;
  return { applicableFilters: nonMonitorFilters, filterTerms: mapFiltersToTerms(effectiveFilters) };
};
var filterCompare = (filter, item) => Object.keys(emptyFilter).every((key) => item[key]?.toString() === filter[key]?.toString());
var filtersFilter = (item, index, array) => {
  const firstIndex = array.findIndex((filter) => filterCompare(filter, item));
  return firstIndex === index;
};
var listItemMapper = (byId, ids, { cutOffSize = DEVICE_LIST_MAXIMUM_LENGTH, defaultObject = {} }) => ids.slice(0, cutOffSize).reduce((accu, id) => {
  if (id && byId[id]) {
    accu.push({ ...defaultObject, ...byId[id] });
  }
  return accu;
}, []);
var mergePermissions = (existingPermissions = { ...import_constants4.emptyUiPermissions }, addedPermissions) => Object.entries(existingPermissions).reduce(
  (accu, [key, value]) => {
    let values;
    if (!accu[key]) {
      accu[key] = value;
      return accu;
    }
    if (Array.isArray(value)) {
      values = [...value, ...accu[key]].filter(import_helpers.duplicateFilter);
    } else {
      values = mergePermissions(accu[key], { ...value });
    }
    accu[key] = values;
    return accu;
  },
  { ...addedPermissions }
);
var mapUserRolesToUiPermissions = (userRoles, roles) => userRoles.reduce(
  (accu, roleId) => {
    if (!(roleId && roles[roleId])) {
      return accu;
    }
    return mergePermissions(accu, roles[roleId].uiPermissions);
  },
  { ...import_constants4.emptyUiPermissions }
);
var progress = ({ loaded, total }) => {
  let uploadProgress = loaded / total * 100;
  return uploadProgress = uploadProgress < 50 ? Math.ceil(uploadProgress) : Math.round(uploadProgress);
};
var extractErrorMessage = (err, fallback = "") => err.response?.data?.error?.message || err.response?.data?.error || err.error || err.message || fallback;
var ensureVersionString = (software, fallback) => software.length && software !== "artifact_name" ? software.endsWith(softwareIndicator) ? software : `${software}${softwareIndicator}` : fallback;
var getComparisonCompatibleVersion = (version) => isNaN(version.charAt(0)) && version !== "next" ? "master" : version;
var stringToBoolean = (content) => {
  if (!content) {
    return false;
  }
  const string = content + "";
  switch (string.trim().toLowerCase()) {
    case "true":
    case "yes":
    case "1":
      return true;
    case "false":
    case "no":
    case "0":
    case null:
      return false;
    default:
      return Boolean(string);
  }
};
var groupDeploymentDevicesStats = (deployment) => {
  const deviceStatCollector = (deploymentStates, devices) => Object.values(devices).reduce((accu, device) => deploymentStates.includes(device.status) ? accu + 1 : accu, 0);
  const inprogress = deviceStatCollector(deploymentStatesToSubstates.inprogress, deployment.devices);
  const pending = deviceStatCollector(deploymentStatesToSubstates.pending, deployment.devices);
  const successes = deviceStatCollector(deploymentStatesToSubstates.successes, deployment.devices);
  const failures = deviceStatCollector(deploymentStatesToSubstates.failures, deployment.devices);
  const paused = deviceStatCollector(deploymentStatesToSubstates.paused, deployment.devices);
  return { inprogress, paused, pending, successes, failures };
};
var statCollector = (items, statistics) => items.reduce((accu, property) => accu + Number(statistics[property] || 0), 0);
var groupDeploymentStats = (deployment, withSkipped) => {
  const { statistics = {} } = deployment;
  const { status = {} } = statistics;
  const stats = { ...defaultStats, ...status };
  let groupStates = deploymentStatesToSubstates;
  let result = {};
  if (withSkipped) {
    groupStates = deploymentStatesToSubstatesWithSkipped;
    result.skipped = statCollector(groupStates.skipped, stats);
  }
  result = {
    ...result,
    // don't include 'pending' as inprogress, as all remaining devices will be pending - we don't discriminate based on phase membership
    inprogress: statCollector(groupStates.inprogress, stats),
    pending: statCollector(groupStates.pending, stats),
    successes: statCollector(groupStates.successes, stats),
    failures: statCollector(groupStates.failures, stats),
    paused: statCollector(groupStates.paused, stats)
  };
  return result;
};
var getDeploymentState = (deployment) => {
  const { status: deploymentStatus = DEPLOYMENT_STATES.pending } = deployment;
  const { inprogress: currentProgressCount, paused } = groupDeploymentStats(deployment);
  let status = deploymentDisplayStates[deploymentStatus];
  if (deploymentStatus === DEPLOYMENT_STATES.pending && currentProgressCount === 0) {
    status = "queued";
  } else if (paused > 0) {
    status = deploymentDisplayStates.paused;
  }
  return status;
};
var generateDeploymentGroupDetails = (filter, groupName) => filter && filter.terms?.length ? `${groupName} (${filter.terms.map((filter2) => `${filter2.attribute || filter2.key} ${import_constants4.DEVICE_FILTERING_OPTIONS[filter2.type || filter2.operator].shortform} ${filter2.value}`).join(", ")})` : groupName;
var mapDeviceAttributes = (attributes = []) => attributes.reduce(
  (accu, attribute) => {
    if (!(attribute.value && attribute.name) && attribute.scope === import_constants4.ATTRIBUTE_SCOPES.inventory) {
      return accu;
    }
    accu[attribute.scope || import_constants4.ATTRIBUTE_SCOPES.inventory] = {
      ...accu[attribute.scope || import_constants4.ATTRIBUTE_SCOPES.inventory],
      [attribute.name]: attribute.value
    };
    if (attribute.name === "device_type" && attribute.scope === import_constants4.ATTRIBUTE_SCOPES.inventory) {
      accu.inventory.device_type = [].concat(attribute.value);
    }
    return accu;
  },
  { inventory: { device_type: [], artifact_name: "" }, identity: {}, monitor: {}, system: {}, tags: {} }
);
var isDarkMode = (mode) => mode === DARK_MODE;
var parseSubscriptionPreview = (lines) => lines.reduce(
  (acc, { addon, amount }) => {
    const key = addon || "plan";
    if (key === "plan") {
      acc.plan += amount;
    } else {
      acc.addons[key] = (acc.addons[key] ?? 0) + amount;
    }
    return acc;
  },
  { plan: 0, addons: {} }
);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  convertDeviceListStateToFilters,
  ensureVersionString,
  extractErrorMessage,
  filtersFilter,
  generateDeploymentGroupDetails,
  getComparisonCompatibleVersion,
  getDeploymentState,
  groupDeploymentDevicesStats,
  groupDeploymentStats,
  isDarkMode,
  listItemMapper,
  mapDeviceAttributes,
  mapFiltersToTerms,
  mapTermsToFilters,
  mapUserRolesToUiPermissions,
  mergePermissions,
  parseSubscriptionPreview,
  progress,
  statCollector,
  stringToBoolean
});
//# sourceMappingURL=utils.cjs.map