!/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/boost-canvas
 * @requires highcharts
 *
 * Boost module
 *
 * (c) 2010-2025 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e(t._Highcharts,t._Highcharts.Color):"function"==typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts/highcharts"],function(t){return e(t,t.Color)}):"object"==typeof exports?exports["highcharts/modules/boost-canvas"]=e(t._Highcharts,t._Highcharts.Color):t.Highcharts=e(t.Highcharts,t.Highcharts.Color)}("undefined"==typeof window?this:window,(t,e)=>(()=>{"use strict";let i,s;var o,r,n={620:t=>{t.exports=e},944:e=>{e.exports=t}},a={};function l(t){var e=a[t];if(void 0!==e)return e.exports;var i=a[t]={exports:{}};return n[t](i,i.exports,l),i.exports}l.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return l.d(e,{a:e}),e},l.d=(t,e)=>{for(var i in e)l.o(e,i)&&!l.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},l.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);var h={};l.d(h,{default:()=>tH});var d=l(944),u=l.n(d);let c=["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"],g={};c.forEach(t=>{g[t]=!0});let{composed:m}=u(),{addEvent:f,pick:p,pushUnique:b}=u();function x(t){let e=t.series,i=t.boost=t.boost||{},s=t.options.boost||{},o=p(s.seriesThreshold,50);if(e.length>=o)return!0;if(1===e.length)return!1;let r=s.allowForce;if(void 0===r){for(let e of(r=!0,t.xAxis))if(p(e.min,-1/0)>p(e.dataMin,-1/0)||p(e.max,1/0)<p(e.dataMax,1/0)){r=!1;break}}if(void 0!==i.forceChartBoost){if(r)return i.forceChartBoost;i.forceChartBoost=void 0}let n=0,a=0,l;for(let t of e)0!==(l=t.options).boostThreshold&&!1!==t.visible&&"heatmap"!==t.type&&(g[t.type]&&++n,function(...t){let e=-Number.MAX_VALUE;return t.forEach(t=>{if(null!=t&&void 0!==t.length&&t.length>0)return e=t.length,!0}),e}(t.getColumn("x",!0),l.data,t.points)>=(l.boostThreshold||Number.MAX_VALUE)&&++a);return i.forceChartBoost=r&&(n===e.length&&a===n||a>5),i.forceChartBoost}function A(t){function e(){t.boost&&t.boost.wgl&&x(t)&&t.boost.wgl.render(t)}f(t,"predraw",function(){t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.axes.some(t=>t.isPanning)||t.boost.clear?.(),t.boost.canvas&&t.boost.wgl&&x(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),f(t,"load",e,{order:-1}),f(t,"redraw",e);let i=-1,s=-1;f(t.pointer,"afterGetHoverData",e=>{let o=e.hoverPoint?.series;if(t.boost=t.boost||{},t.boost.markerGroup&&o){let e=t.inverted?o.yAxis:o.xAxis,r=t.inverted?o.xAxis:o.yAxis;(e&&e.pos!==i||r&&r.pos!==s)&&(t.series.forEach(t=>{t.halo?.hide()}),t.boost.markerGroup.translate(e.pos,r.pos),i=e.pos,s=r.pos)}})}let y={compose:function(t,e){return e&&b(m,"Boost.Chart")&&t.prototype.callbacks.push(A),t},getBoostClipRect:function(t,e){let i=t.navigator,s={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.plotHeight};if(i&&t.inverted?(s.width+=i.top+i.height,i.opposite||(s.x=i.left)):i&&!t.inverted&&(s.height=i.top+i.height-t.plotTop),e.is){let{xAxis:i,yAxis:o}=e;if(s=t.getClipBox(e),t.inverted){let t=s.width;s.width=s.height,s.height=t,s.x=o.pos,s.y=i.pos}else s.x=i.pos,s.y=o.pos}if(e===t){let e=t.inverted?t.xAxis:t.yAxis;e.length<=1&&(s.y=Math.min(e[0].pos,s.y),s.height=e[0].pos-t.plotTop+e[0].len)}return s},isChartSeriesBoosting:x};var v=l(620),P=l.n(v);let T={area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"},{clamp:C,error:M,pick:S}=u(),E=class{constructor(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}bind(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)}createShader(){let t=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMax;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMax;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isCircle;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (!skipTranslation && isCircle && (\naVertexPosition.x < xAxisMin ||\naVertexPosition.x > xAxisMax ||\naVertexPosition.y < yAxisMin ||\naVertexPosition.y > yAxisMax\n)) {\ngl_Position = uPMatrix * vec4(2.0, 2.0, 2.0, 1.0);\n} else if (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),e=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),i=t=>this.gl.getUniformLocation(this.shaderProgram,t);return t&&e?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,t),this.gl.attachShader(this.shaderProgram,e),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=i("uPMatrix"),this.psUniform=i("pSize"),this.fcUniform=i("fillColor"),this.isBubbleUniform=i("isBubble"),this.bubbleSizeAbsUniform=i("bubbleSizeAbs"),this.bubbleSizeAreaUniform=i("bubbleSizeByArea"),this.uSamplerUniform=i("uSampler"),this.skipTranslationUniform=i("skipTranslation"),this.isCircleUniform=i("isCircle"),this.isInverted=i("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)}handleErrors(){this.errors.length&&M("[highcharts boost] shader error - "+this.errors.join("\n"))}stringToProgram(t,e){let i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)}destroy(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)}fillColorUniform(){return this.fcUniform}getProgram(){return this.shaderProgram}pointSizeUniform(){return this.psUniform}perspectiveUniform(){return this.pUniform}reset(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))}setBubbleUniforms(t,e,i,s=1){let o=t.options,r=Number.MAX_VALUE,n=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){let a=t.getPxExtremes();r=S(o.zMin,C(e,!1===o.displayNegative?o.zThreshold:-Number.MAX_VALUE,r)),n=S(o.zMax,Math.max(n,i)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",a.minPxSize*s),this.setUniform("bubbleMaxSize",a.maxPxSize*s),this.setUniform("bubbleZMin",r),this.setUniform("bubbleZMax",n),this.setUniform("bubbleZThreshold",t.options.zThreshold)}}setColor(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])}setDrawAsCircle(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,+!!t)}setInverted(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)}setPMatrix(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)}setPointSize(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)}setSkipTranslation(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,+(!0===t))}setTexture(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)}setUniform(t,e){if(this.gl&&this.shaderProgram){let i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}}},k=class{constructor(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}allocate(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)}bind(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)}build(t,e,i){let s;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(s=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||s,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),s=!1,!0):(this.destroy(),!1)}destroy(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]}push(t,e,i,s){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=s)}render(t,e,i){let s=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!s&&((!t||t>s||t<0)&&(t=0),(!e||e>s)&&(e=s),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))}},{getBoostClipRect:w}=y,{parse:R}=P(),{doc:U,win:L}=u(),{isNumber:_,isObject:N,merge:D,objectEach:z,pick:I}=u(),G={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},B={scatter:!0,bubble:!0},O=["webgl","experimental-webgl","moz-webgl","webkit-3d"];class V{static orthoMatrix(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]}static seriesPointCount(t){let e,i,s;return t.boosted?(e=!!t.options.stacking,i=(t.getColumn("x").length?t.getColumn("x"):void 0)||t.options.xData||t.getColumn("x",!0),s=(e?t.data:i||t.options.data).length,"treemap"===t.type?s*=12:"heatmap"===t.type?s*=6:G[t.type]&&(s*=2),s):0}constructor(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}getPixelRatio(){return this.settings.pixelRatio||L.devicePixelRatio||1}setOptions(t){"pixelRatio"in t||(t.pixelRatio=1),D(!0,this.settings,t)}allocateBuffer(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.series.forEach(t=>{t.boosted&&(i+=V.seriesPointCount(t))}),e&&e.allocate(i))}allocateBufferForSingleSeries(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.boosted&&(i=V.seriesPointCount(t)),e&&e.allocate(i))}clear(){let t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}pushSeriesData(t,e){let i=this.data,s=this.settings,o=this.vbuffer,r=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),{chart:n,options:a,sorted:l,xAxis:h,yAxis:d}=t,u=!!a.stacking,c=a.data,g=t.xAxis.getExtremes(),m=g.min-(t.xAxis.minPointOffset||0),f=g.max+(t.xAxis.minPointOffset||0),p=t.yAxis.getExtremes(),b=p.min-(t.yAxis.minPointOffset||0),x=p.max+(t.yAxis.minPointOffset||0),A=(t.getColumn("x").length?t.getColumn("x"):void 0)||a.xData||t.getColumn("x",!0),y=(t.getColumn("y").length?t.getColumn("y"):void 0)||a.yData||t.getColumn("y",!0),v=(t.getColumn("z").length?t.getColumn("z"):void 0)||a.zData||t.getColumn("z",!0),P=!A||0===A.length,T=t.options.colorByPoint,C=a.connectNulls,M=t.points||!1,S=u?t.data:A||c,E={x:Number.MAX_VALUE,y:0},k={x:-Number.MAX_VALUE,y:0},w=void 0===n.index,U=G[t.type],L=a.zoneAxis||"y",_=a.zones||!1,D=a.threshold,z=this.getPixelRatio(),I=t.chart.plotWidth,B=!1,O=!1,V,X,F=0,H=!1,Y,W,j,K,Z=-1,q=!1,Q=!1,J,$=!1,tt=!1,te,ti=!1,ts=!0,to=!0,tr,tn=!1,ta=!1,tl=0,th=0;if(a.boostData&&a.boostData.length>0)return;a.gapSize&&(ta="value"!==a.gapUnit?a.gapSize*t.closestPointRange:a.gapSize),_&&(tr=[],_.forEach((t,e)=>{if(t.color){let i=R(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,tr[e]=i,tn||void 0!==t.value||(tn=i)}}),tn||(tn=R(t.pointAttribs&&t.pointAttribs().fill||t.color).rgba,tn[0]/=255,tn[1]/=255,tn[2]/=255)),n.inverted&&(I=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;let td=t=>{t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},tu=(t,r,n,a=1,l)=>{td(l),1!==z&&(!s.useGPUTranslations||e.skipTranslation)&&(t*=z,r*=z,a*=z),s.usePreallocated&&o?(o.push(t,r,+!!n,a),tl+=4):(i.push(t),i.push(r),i.push(n?z:0),i.push(a))},tc=()=>{e.segments.length&&(e.segments[e.segments.length-1].to=i.length||tl)},tg=()=>{e.segments.length&&e.segments[e.segments.length-1].from===(i.length||tl)||(tc(),e.segments.push({from:i.length||tl}))},tm=(t,e,i,s,o)=>{td(o),tu(t+i,e),td(o),tu(t,e),td(o),tu(t,e+s),td(o),tu(t,e+s),td(o),tu(t+i,e+s),td(o),tu(t+i,e)};if(tg(),M&&M.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",M[0].node&&M[0].node.levelDynamic&&M.sort((t,e)=>{if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),M.forEach(e=>{let i,s,o=e.plotY;if(void 0!==o&&!isNaN(o)&&null!==e.y&&e.shapeArgs){let{x:o=0,y:r=0,width:a=0,height:l=0}=e.shapeArgs;i=(s=n.styledMode?e.series.colorAttribs(e):s=e.series.pointAttribs(e))["stroke-width"]||0,te=R(s.fill).rgba,te[0]/=255,te[1]/=255,te[2]/=255,t.is("treemap")&&(i=i||1,X=R(s.stroke).rgba,X[0]/=255,X[1]/=255,X[2]/=255,tm(o,r,a,l,X),i/=2),t.is("heatmap")&&n.inverted&&(o=h.len-o,r=d.len-r,a=-a,l=-l),tm(o+i,r+i,a-2*i,l-2*i,te)}}),tc();return}for(;Z<S.length-1;){if(void 0===(j=S[++Z]))continue;if(w)break;let i=c&&c[Z];if(!P){N(i,!0)&&i.color&&(te=R(i.color).rgba);let e=t.options.keys?.indexOf("color");Array.isArray(i)&&e&&"string"==typeof i[e]?te=R(i[e]).rgba:T&&n.options.colors&&(th%=n.options.colors.length,te=R(n.options.colors[th]).rgba),te&&(te[0]/=255,te[1]/=255,te[2]/=255),th++}if(P?(Y=j[0],W=j[1],S[Z+1]&&(Q=S[Z+1][0]),S[Z-1]&&(q=S[Z-1][0]),j.length>=3&&(K=j[2],j[2]>e.zMax&&(e.zMax=j[2]),j[2]<e.zMin&&(e.zMin=j[2]))):(Y=j,W=y?.[Z],S[Z+1]&&(Q=S[Z+1]),S[Z-1]&&(q=S[Z-1]),v&&v.length&&(K=v[Z],v[Z]>e.zMax&&(e.zMax=v[Z]),v[Z]<e.zMin&&(e.zMin=v[Z]))),!C&&(null===Y||null===W)){tg();continue}if(Q&&Q>=m&&Q<=f&&($=!0),q&&q>=m&&q<=f&&(tt=!0),r?(P&&(W=j.slice(1,3)),J=t.getColumn("low",!0)?.[Z],W=t.getColumn("high",!0)?.[Z]||0):u&&(Y=j.x,J=(W=j.stackY)-j.y),null!=b&&null!=x&&(ts=W>=b&&W<=x),!l&&!ts||(Y>f&&k.x<f&&(k.x=Y,k.y=W),Y<m&&E.x>m&&(E.x=Y,E.y=W),null===W&&C))continue;if(null===W||!ts&&S.length>1&&!$&&!tt){tg();continue}if((l&&(Q>=m||Y>=m)&&(q<=f||Y<=f)||!l&&Y>=m&&Y<=f)&&(ti=!0),ti||$||tt){if(ta&&Y-q>ta&&tg(),_){let t;_.some((e,i)=>{let s=_[i-1];return"x"===L?void 0!==e.value&&Y<=e.value&&(tr[i]&&(!s||Y>=s.value)&&(t=tr[i]),!0):void 0!==e.value&&W<=e.value&&(tr[i]&&(!s||W>=s.value)&&(t=tr[i]),!0)}),te=t||tn||te}if(s.useGPUTranslations||(e.skipTranslation=!0,Y=h.toPixels(Y,!0),W=d.toPixels(W,!0),!(Y>I)||"POINTS"!==e.drawMode)){if(e.hasMarkers&&ti&&!1!==B&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(Y-B))),!s.useGPUTranslations&&!s.usePreallocated&&B&&1>Math.abs(Y-B)&&O&&1>Math.abs(W-O)){s.debug.showSkipSummary&&++F;continue}U&&(V=J||0,(!1===J||void 0===J)&&(V=W<0?W:0),(r||u)&&!d.logarithmic||(V=Math.max(null===D?b:D,b)),s.useGPUTranslations||(V=d.toPixels(V,!0)),tu(Y,V,!1,0,te)),a.step&&!to&&tu(Y,O,!1,2,te),tu(Y,W,!1,"bubble"===t.type?K||1:2,te),B=Y,O=W,H=!0,to=!1}}}s.debug.showSkipSummary&&console.log("skipped points:",F);let tf=(t,i)=>{if(s.useGPUTranslations||(e.skipTranslation=!0,t.x=h.toPixels(t.x,!0),t.y=d.toPixels(t.y,!0)),i){this.data=[t.x,t.y,0,2].concat(this.data);return}tu(t.x,t.y,0,2)};!H&&!1!==C&&"line_strip"===t.drawMode&&(E.x<Number.MAX_VALUE&&tf(E,!0),k.x>-Number.MAX_VALUE&&tf(k)),tc()}pushSeries(t){let e=this.markerData,i=this.series,s=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),s.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");let o={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:T[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(o):i[t.index]=o,this.pushSeriesData(t,o),s.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")}flush(){let t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()}setXAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMax",t.max),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}setYAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMax",t.max),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}setThreshold(t,e){let i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))}renderChart(t){let e=this.gl,i=this.settings,s=this.shader,o=this.vbuffer,r=this.getPixelRatio();if(!t)return!1;this.width=t.chartWidth*r,this.height=t.chartHeight*r;let n=this.height,a=this.width;if(!e||!s||!a||!n)return!1;i.debug.timeRendering&&console.time("gl rendering"),e.canvas.width=a,e.canvas.height=n,s.bind(),e.viewport(0,0,a,n),s.setPMatrix(V.orthoMatrix(a,n)),i.lineWidth>1&&!u().isMS&&e.lineWidth(i.lineWidth),o&&(o.build(this.data,"aVertexPosition",4),o.bind()),s.setInverted(t.inverted),this.series.forEach((a,l)=>{let h=a.series.options,d=h.marker,u=void 0!==h.lineWidth?h.lineWidth:1,c=h.threshold,g=_(c),m=a.series.yAxis.getThreshold(c),f=I(h.marker?h.marker.enabled:null,!!a.series.xAxis.isRadial||null,a.series.closestPointRangePx>2*((h.marker?h.marker.radius:10)||10)),p=this.textureHandles[d&&d.symbol||a.series.symbol]||this.textureHandles.circle,b,x,A,y=[];if(0!==a.segments.length&&a.segments[0].from!==a.segments[0].to&&(p.isReady&&(e.bindTexture(e.TEXTURE_2D,p.handle),s.setTexture(p.handle)),t.styledMode?a.series.markerGroup===a.series.chart.boost?.markerGroup?(delete a.series.markerGroup,a.series.markerGroup=a.series.plotGroup("markerGroup","markers","visible",1,t.seriesGroup).addClass("highcharts-tracker"),A=a.series.markerGroup.getStyle("fill"),a.series.markerGroup.destroy(),a.series.markerGroup=a.series.chart.boost?.markerGroup):A=a.series.markerGroup?.getStyle("fill"):(A="POINTS"===a.drawMode&&a.series.pointAttribs&&a.series.pointAttribs().fill||a.series.color,h.colorByPoint&&(A=a.series.chart.options.colors[l])),a.series.fillOpacity&&h.fillOpacity&&(A=new(P())(A).setOpacity(I(h.fillOpacity,1)).get()),y=R(A).rgba,i.useAlpha||(y[3]=1),"add"===h.boostBlending?(e.blendFunc(e.SRC_ALPHA,e.ONE),e.blendEquation(e.FUNC_ADD)):"mult"===h.boostBlending||"multiply"===h.boostBlending?e.blendFunc(e.DST_COLOR,e.ZERO):"darken"===h.boostBlending?(e.blendFunc(e.ONE,e.ONE),e.blendEquation(e.FUNC_MIN)):e.blendFuncSeparate(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA),s.reset(),a.colorData.length>0?(s.setUniform("hasColor",1),(x=new k(e,s)).build(Array(a.segments[0].from).concat(a.colorData),"aColor",4),x.bind()):(s.setUniform("hasColor",0),e.disableVertexAttribArray(e.getAttribLocation(s.getProgram(),"aColor"))),s.setColor(y),this.setXAxis(a.series.xAxis),this.setYAxis(a.series.yAxis),this.setThreshold(g,m),"POINTS"===a.drawMode&&s.setPointSize(2*I(h.marker&&h.marker.radius,.5)*r),s.setSkipTranslation(a.skipTranslation),"bubble"===a.series.type&&s.setBubbleUniforms(a.series,a.zMin,a.zMax,r),s.setDrawAsCircle(B[a.series.type]||!1),o)){if(u>0||"LINE_STRIP"!==a.drawMode){let{x:i,y:s,width:r,height:l}=w(t,a.series);for(e.enable(e.SCISSOR_TEST),e.scissor(i,n-s-l,r,l),b=0;b<a.segments.length;b++)o.render(a.segments[b].from,a.segments[b].to,a.drawMode);e.disable(e.SCISSOR_TEST)}if(a.hasMarkers&&f)for(s.setPointSize(2*I(h.marker&&h.marker.radius,5)*r),s.setDrawAsCircle(!0),b=0;b<a.segments.length;b++)o.render(a.segments[b].from,a.segments[b].to,"POINTS")}}),i.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()}render(t){if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(()=>{this.render(t)},1)}setSize(t,e){let i=this.shader;i&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,i.bind(),i.setPMatrix(V.orthoMatrix(t,e)))}init(t,e){let i=this.settings;if(this.isInited=!1,!t)return!1;i.debug.timeSetup&&console.time("gl setup");for(let e=0;e<O.length&&(this.gl=t.getContext(O[e],{}),!this.gl);++e);let s=this.gl;if(!s)return!1;e||this.flush(),s.enable(s.BLEND),s.blendFunc(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA),s.disable(s.DEPTH_TEST),s.depthFunc(s.LESS);let o=this.shader=new E(s);if(!o)return!1;this.vbuffer=new k(s,o);let r=(t,e)=>{let i={isReady:!1,texture:U.createElement("canvas"),handle:s.createTexture()},o=i.texture.getContext("2d");this.textureHandles[t]=i,i.texture.width=512,i.texture.height=512,o.mozImageSmoothingEnabled=!1,o.webkitImageSmoothingEnabled=!1,o.msImageSmoothingEnabled=!1,o.imageSmoothingEnabled=!1,o.strokeStyle="rgba(255, 255, 255, 0)",o.fillStyle="#FFF",e(o);try{s.activeTexture(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,i.handle),s.texImage2D(s.TEXTURE_2D,0,s.RGBA,s.RGBA,s.UNSIGNED_BYTE,i.texture),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.bindTexture(s.TEXTURE_2D,null),i.isReady=!0}catch{}};return r("circle",t=>{t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),r("square",t=>{t.fillRect(0,0,512,512)}),r("diamond",t=>{t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),r("triangle",t=>{t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),r("triangle-down",t=>{t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,i.debug.timeSetup&&console.timeEnd("gl setup"),!0}destroy(){let t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(z(this.textureHandles,e=>{e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)}}!function(t){t.setLength=function(t,e,i){return Array.isArray(t)?(t.length=e,t):t[i?"subarray":"slice"](0,e)},t.splice=function(t,e,i,s,o=[]){if(Array.isArray(t))return Array.isArray(o)||(o=Array.from(o)),{removed:t.splice(e,i,...o),array:t};let r=Object.getPrototypeOf(t).constructor,n=t[s?"subarray":"slice"](e,e+i),a=new r(t.length-i+o.length);return a.set(t.subarray(0,e),0),a.set(o,e),a.set(t.subarray(e+i),e+o.length),{removed:n,array:a}}}(o||(o={}));let{setLength:X,splice:F}=o,{fireEvent:H,objectEach:Y,uniqueKey:W}=u(),j=class{constructor(t={}){this.autoId=!t.id,this.columns={},this.id=t.id||W(),this.modified=this,this.rowCount=0,this.versionTag=W();let e=0;Y(t.columns||{},(t,i)=>{this.columns[i]=t.slice(),e=Math.max(e,t.length)}),this.applyRowCount(e)}applyRowCount(t){this.rowCount=t,Y(this.columns,(e,i)=>{e.length!==t&&(this.columns[i]=X(e,t))})}deleteRows(t,e=1){if(e>0&&t<this.rowCount){let i=0;Y(this.columns,(s,o)=>{this.columns[o]=F(s,t,e).array,i=s.length}),this.rowCount=i}H(this,"afterDeleteRows",{rowIndex:t,rowCount:e}),this.versionTag=W()}getColumn(t,e){return this.columns[t]}getColumns(t,e){return(t||Object.keys(this.columns)).reduce((t,e)=>(t[e]=this.columns[e],t),{})}getRow(t,e){return(e||Object.keys(this.columns)).map(e=>this.columns[e]?.[t])}setColumn(t,e=[],i=0,s){this.setColumns({[t]:e},i,s)}setColumns(t,e,i){let s=this.rowCount;Y(t,(t,e)=>{this.columns[e]=t.slice(),s=t.length}),this.applyRowCount(s),i?.silent||(H(this,"afterSetColumns"),this.versionTag=W())}setRow(t,e=this.rowCount,i,s){let{columns:o}=this,r=i?this.rowCount+1:e+1;Y(t,(t,n)=>{let a=o[n]||s?.addColumns!==!1&&Array(r);a&&(i?a=F(a,e,0,!0,[t]).array:a[e]=t,o[n]=a)}),r>this.rowCount&&this.applyRowCount(r),s?.silent||(H(this,"afterSetRows"),this.versionTag=W())}},{getBoostClipRect:K,isChartSeriesBoosting:Z}=y,{getOptions:q}=u(),{composed:Q,doc:J,noop:$,win:tt}=u(),{addEvent:te,destroyObjectProperties:ti,error:ts,extend:to,fireEvent:tr,isArray:tn,isNumber:ta,pick:tl,pushUnique:th,wrap:td,defined:tu}=u();function tc(t,e){let i=e.boost;t&&i&&i.target&&i.canvas&&!Z(e.chart)&&t.allocateBufferForSingleSeries(e)}function tg(t){return tl(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function tm(t,e){let i=t.constructor,o=t.seriesGroup||e.group,r=t.chartWidth,n=t.chartHeight,a=t,l="undefined"!=typeof SVGForeignObjectElement,h=!1;Z(t)?a=t:(a=e,h=!!(e.options.events?.click||e.options.point?.events?.click));let d=a.boost=a.boost||{};if(l=!1,s||(s=J.createElement("canvas")),!d.target&&(d.canvas=s,t.renderer.forExport||!l?(a.renderTarget=d.target=t.renderer.image("",0,0,r,n).addClass("highcharts-boost-canvas").add(o),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize(),d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=t.renderer.createElement("foreignObject").add(o),a.renderTarget=d.target=J.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width,d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width,d.target.height=d.canvas.height,d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){r=t.chartWidth,n=t.chartHeight,(d.targetFo||d.target).attr({x:0,y:0,width:r,height:n}).css({pointerEvents:h?void 0:"none",mixedBlendMode:"normal",opacity:1}).addClass(h?"highcharts-tracker":""),a instanceof i&&a.boost?.markerGroup?.translate(t.plotLeft,t.plotTop)},d.clipRect=t.renderer.clipRect(),(d.targetFo||d.target).attr({zIndex:e.options.zIndex}),a instanceof i&&(a.boost.markerGroup=a.renderer.g().add(o).translate(e.xAxis.pos,e.yAxis.pos))),d.canvas.width=r,d.canvas.height=n,d.clipRect){let e=K(t,a);d.clipRect.attr(e),e.width===t.clipBox.width&&e.height===t.clipBox.height?o?.clip(t.renderer.clipRect(e.x-4,e.y,e.width+4,e.height+4)):(d.targetFo||d.target).clip(d.clipRect)}return d.resize(),d.clear(),!d.wgl&&(d.wgl=new V(t=>{t.settings.debug.timeBufferCopy&&console.time("buffer copy"),d.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||ts("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(t.options.boost||{}),a instanceof i&&d.wgl.allocateBuffer(t)),d.wgl.setSize(r,n),d.wgl}function tf(t){let e=t.points;if(e){let t,i;for(i=0;i<e.length;i+=1)(t=e[i])&&t.destroyElements&&t.destroyElements()}for(let e of(["graph","area","tracker"].forEach(e=>{let i=t[e];i&&(t[e]=i.destroy())}),t.zones))ti(e,void 0,!0)}function tp(t,e,i,s,o,r){let n=(o=o||0)+(s=s||3e3),a=!0;for(;a&&o<n&&o<t.length;)a=e(t[o],o),++o;a&&(o<t.length?r?tp(t,e,i,s,o,r):tt.requestAnimationFrame?tt.requestAnimationFrame(function(){tp(t,e,i,s,o)}):setTimeout(tp,0,t,e,i,s,o):i&&i())}function tb(t,e){let i=t.options,s=t.dataTable.modified.rowCount,o=t.xAxis&&t.xAxis.options,r=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return s>tl(i.boostThreshold,Number.MAX_VALUE)&&ta(r.min)&&ta(r.max)&&(!e||ta(o.min)&&ta(o.max))&&(!n||ta(n.min)&&ta(n.max))}let tx=(t,e)=>!t.forceCrop&&(Z(t.chart)||(e?e.length:0)>=tl(t.options.boostThreshold,Number.MAX_VALUE));function tA(){let t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=void 0),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=void 0)}function ty(){let t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function tv(t){let e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!Z(t.chart)&&e.wgl.render(t.chart)}function tP(t,e){let i=t.options,s=t.xAxis,o=t.pointClass;if(e instanceof o)return e;let r=i.data,n=t.is("scatter"),a=(n&&t.getColumn("x",!0).length?t.getColumn("x",!0):void 0)||(t.getColumn("x").length?t.getColumn("x"):void 0)||i.xData||t.getColumn("x",!0)||!1,l=t.getColumn("y",!0)||i.yData||!1,h=e.i,d=r?.[h]?.color,u=new o(t,n&&a&&l?[a[h],l[h]]:(tn(r)?r:[])[h],a?a[h]:void 0);if(n&&i?.keys?.length){let t=i.keys;for(let e=t.length-1;e>-1;e--)u[t[e]]=r[h][e]}return u.category=tl(s.categories?s.categories[u.x]:u.x,u.x),u.key=u.name??u.category,u.dist=e.dist,u.distX=e.distX,u.plotX=e.plotX,u.plotY=e.plotY,u.index=h,u.percentage=e.percentage,u.isInside=t.isPointInside(u),d&&(u.color=d),u}function tT(t){let{options:e,xAxis:i,yAxis:s}=this;if(!this.isDirty&&!i.isDirty&&!s.isDirty&&!t)return!1;this.yAxis.setTickInterval();let o=e.boostThreshold||0,r=e.cropThreshold,n=this.getColumn("x"),a=i.getExtremes(),l=a.max??Number.MAX_VALUE,h=a.min??-Number.MAX_VALUE,d=this.getColumn("y"),u=s.getExtremes(),c=u.max??Number.MAX_VALUE,g=u.min??-Number.MAX_VALUE;if(!this.boosted&&i.old&&s.old&&h>=(i.old.min??-Number.MAX_VALUE)&&l<=(i.old.max??Number.MAX_VALUE)&&g>=(s.old.min??-Number.MAX_VALUE)&&c<=(s.old.max??Number.MAX_VALUE))return this.dataTable.modified.setColumns({x:n,y:d}),!0;let m=this.dataTable.rowCount;if(!o||m<o||r&&!this.forceCrop&&!this.getExtremesFromAll&&!e.getExtremesFromAll&&m<r)return this.dataTable.modified.setColumns({x:n,y:d}),!0;let f=[],p=[],b=[],x=!(ta(a.max)||ta(a.min)),A=!(ta(u.max)||ta(u.min)),y=!1,v,P=n[0],T=n[0],C,M=d?.[0],S=d?.[0];for(let t=0,e=n.length;t<e;++t)v=n[t],C=d?.[t],v>=h&&v<=l&&C>=g&&C<=c?(f.push({x:v,y:C}),p.push(v),b.push(C),x&&(P=Math.max(P,v),T=Math.min(T,v)),A&&(M=Math.max(M,C),S=Math.min(S,C))):y=!0;return x&&(i.dataMax=Math.max(P,i.dataMax||0),i.dataMin=Math.min(T,i.dataMin||0)),A&&(s.dataMax=Math.max(M,s.dataMax||0),s.dataMin=Math.min(S,s.dataMin||0)),this.cropped=y,this.cropStart=0,y&&this.dataTable.modified===this.dataTable&&(this.dataTable.modified=new j),this.dataTable.modified.setColumns({x:p,y:b}),tx(this,p)||(this.processedData=f),!0}function tC(){let t=this.options||{},e=this.chart,s=e.boost,o=this.boost,r=this.xAxis,n=this.yAxis,a=t.xData||this.getColumn("x",!0),l=t.yData||this.getColumn("y",!0),h=this.getColumn("low",!0),d=this.getColumn("high",!0),u=this.processedData||t.data,c=r.getExtremes(),g=c.min-(r.minPointOffset||0),m=c.max+(r.minPointOffset||0),f=n.getExtremes(),p=f.min-(n.minPointOffset||0),b=f.max+(n.minPointOffset||0),x={},A=!!this.sampling,y=t.enableMouseTracking,v=t.threshold,P=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),T=!!t.stacking,C=this.cropStart||0,M=this.requireSorting,S=!a,E="x"===t.findNearestPointBy,k=(this.getColumn("x").length?this.getColumn("x"):void 0)||this.options.xData||this.getColumn("x",!0),w=tl(t.lineWidth,1),R=t.nullInteraction&&p,U=e.tooltip,L=!1,_,N=n.getThreshold(v),D,z,I,G;if(!this.boosted||(this.points?.forEach(t=>{t?.destroyElements?.()}),this.points=[],U&&!U.isHidden?(e.hoverPoint?.series===this||e.hoverPoints?.some(t=>t.series===this))&&(e.hoverPoint=e.hoverPoints=void 0,U.hide(0)):e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(t=>t.series!==this)),r.isPanning||n.isPanning)||(L=tm(e,this),e.boosted=!0,!this.visible))return;(this.points||this.graph)&&tf(this),Z(e)?(this.markerGroup&&this.markerGroup!==s?.markerGroup&&this.markerGroup.destroy(),this.markerGroup=s?.markerGroup,o&&o.target&&(this.renderTarget=o.target=o.target.destroy())):(this.markerGroup===s?.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers","visible",1,e.seriesGroup).addClass("highcharts-tracker"));let B=this.points=[],O=(t,s,o,a)=>{let l=!!k&&k[C+o],h=t=>{e.inverted&&(t=r.len-t,s=n.len-s),B.push({destroy:$,x:l,clientX:t,plotX:t,plotY:s,i:C+o,percentage:a})};t=Math.ceil(t),i=E?t:t+","+s,y&&(x[i]?l===k[k.length-1]&&(B.length--,h(t)):(x[i]=!0,h(t)))};this.buildKDTree=$,tr(this,"renderCanvas"),s&&o?.target&&w>1&&this.is("line")&&(s.lineWidthFilter?.remove(),s.lineWidthFilter=e.renderer.definition({tagName:"filter",children:[{tagName:"feMorphology",attributes:{operator:"dilate",radius:.25*w}}],attributes:{id:"linewidth"}}),o.target.attr({filter:"url(#linewidth)"})),L&&(tc(L,this),L.pushSeries(this),tv(this));let V=L.settings;e.renderer.forExport||(V.debug.timeKDTree&&console.time("kd tree building"),tp(T?this.data.slice(C):a||u,function(t,i){let s=void 0===e.index,o,a,u,c,f,x=!1,y=!0;return!tu(t)||(!s&&(S?(o=t[0],a=t[1]):(o=t,a=l[i]??R??null),P?(S&&(a=t.slice(1,3)),x=h[i],a=d[i]):T&&(o=t.x,x=(a=t.stackY)-t.y,f=t.percentage),M||(y=(a||0)>=p&&a<=b),null!==a&&o>=g&&o<=m&&y&&(u=r.toPixels(o,!0),A?((void 0===I||u===_)&&(P||(x=a),(void 0===G||a>z)&&(z=a,G=i),(void 0===I||x<D)&&(D=x,I=i)),E&&u===_||(void 0!==I&&(c=n.toPixels(z,!0),N=n.toPixels(D,!0),O(u,c,G,f),N!==c&&O(u,N,I,f)),I=G=void 0,_=u)):O(u,c=Math.ceil(n.toPixels(a,!0)),i,f))),!s)},()=>{tr(this,"renderedCanvas"),delete this.buildKDTree,this.options&&this.buildKDTree(),V.debug.timeKDTree&&console.timeEnd("kd tree building")}))}function tM(t){let e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;let i=tm(this.chart,this);i&&(tc(i,this),i.pushSeries(this)),tv(this)}function tS(t){if(this.boosted){if(tb(this))return{};if(this.xAxis.isPanning||this.yAxis.isPanning)return this}return t.apply(this,[].slice.call(arguments,1))}function tE(t){let e=this.options.data;if(tg(this.chart)&&g[this.type]){let s=this.is("scatter")&&!this.is("bubble")&&!this.is("treemap")&&!this.is("heatmap");if(!tx(this,e)||s||this.is("treemap")||this.options.stacking||!tb(this,!0)){if(this.boosted&&(this.xAxis?.isPanning||this.yAxis?.isPanning))return;s&&"treegrid"!==this.yAxis.type?tT.call(this,arguments[1]):t.apply(this,[].slice.call(arguments,1)),e=this.getColumn("x",!0)}if(this.boosted=tx(this,e),this.boosted){let t;this.options.data?.length&&(ta(t=this.getFirstValidPoint(this.options.data))||tn(t)||this.is("treemap")||ts(12,!1,this.chart));var i=this;i.boost=i.boost||{getPoint:t=>tP(i,t)};let e=i.boost.altered=[];if(["allowDG","directTouch","stickyTracking"].forEach(t=>{e.push({prop:t,val:i[t],own:Object.hasOwnProperty.call(i,t)})}),i.allowDG=!1,i.directTouch=!1,i.stickyTracking=!0,i.finishedAnimating=!0,i.labelBySeries&&(i.labelBySeries=i.labelBySeries.destroy()),i.is("scatter")&&!i.is("treemap")&&i.data.length){for(let t of i.data)t?.destroy?.();i.data.length=0,i.points.length=0,delete i.processedData}}else!function(t){let e=t.boost,i=t.chart,s=i.boost;if(s?.markerGroup)for(let t of(s.markerGroup.destroy(),s.markerGroup=void 0,i.series))t.markerGroup=void 0,t.markerGroup=t.plotGroup("markerGroup","markers","visible",1,i.seriesGroup).addClass("highcharts-tracker");e&&((e.altered||[]).forEach(e=>{e.own?t[e.prop]=e.val:delete t[e.prop]}),e.clear&&e.clear()),(i.seriesGroup||t.group)?.clip()}(this)}else t.apply(this,[].slice.call(arguments,1))}function tk(t){let e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}let tw={compose:function(t,e,i,s){if(th(Q,"Boost.Series")){let o=q().plotOptions,r=t.prototype;if(te(t,"destroy",tA),te(t,"hide",ty),s&&(r.renderCanvas=tC),td(r,"getExtremes",tS),td(r,"processData",tE),td(r,"searchPoint",tk),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(t=>(function(t,e,i){function s(t){let e=this.options.stacking&&("translate"===i||"generatePoints"===i);this.boosted&&!e&&tg(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&g[this.type]&&0!==this.options.boostThreshold?"render"===i&&this.renderCanvas&&this.renderCanvas():t.call(this)}if(td(t,i,s),"translate"===i)for(let t of["column","arearange","columnrange","heatmap","treemap"])e[t]&&td(e[t].prototype,i,s)})(r,e,t)),td(i.prototype,"firePointEvent",function(t,e,i){if("click"===e&&this.series.boosted){let t=i.point;if((t.dist||t.distX)>=(t.series.options.marker?.radius??10))return}return t.apply(this,[].slice.call(arguments,1))}),c.forEach(t=>{let i=o[t];i&&(i.boostThreshold=5e3,i.boostData=[],e[t].prototype.fillOpacity=!0)}),s){let{area:t,areaspline:i,bubble:s,column:o,heatmap:r,scatter:n,treemap:a}=e;if(t&&to(t.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),i&&to(i.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),s){let t=s.prototype;delete t.buildKDTree,td(t,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}o&&to(o.prototype,{fill:!0,sampling:!0}),n&&(n.prototype.fill=!0),[r,a].forEach(t=>{t&&td(t.prototype,"drawPoints",tM)})}}return t},destroyGraphics:tf,eachAsync:tp,getPoint:tP},{getBoostClipRect:tR,isChartSeriesBoosting:tU}=y,{destroyGraphics:tL}=tw,{parse:t_}=P(),{doc:tN,noop:tD}=u(),{addEvent:tz,fireEvent:tI,isNumber:tG,merge:tB,pick:tO,wrap:tV}=u();!function(t){let e,i="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";function s(t,e,i,s,o){o&&e!==o.clientX&&(t.moveTo(o.clientX,o.yBottom),t.lineTo(o.clientX,o.plotY),t.lineTo(e,i),t.lineTo(e,s))}function o(t,e,i,s,o){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[o],0,2*Math.PI,!1)}function r(t,e,i,s){t.rect(e-1,i,1,s-i)}function n(){this.boost&&this.boost.copy&&this.boost.copy()}function a(){let t=this.boost||{};t.target&&t.target.attr({href:i}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function l(){tU(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function h(t,e,i){t.lineTo(e,i)}function d(){let t,e=this.chart,s=tU(e)?e:this,o=s===e?e.seriesGroup:e.seriesGroup||this.group,r=e.chartWidth,n=e.chartHeight,a=function(t,e,i,s,o,r,n){t.call(this,i,e,s,o,r,n)},l=s.boost=s.boost||{};return t=l.targetCtx,l.canvas||(l.canvas=tN.createElement("canvas"),l.target=e.renderer.image("",0,0,r,n).addClass("highcharts-boost-canvas").add(o),t=l.targetCtx=l.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(e=>{tV(t,e,a)}),l.copy=function(){l.target.attr({href:l.canvas.toDataURL("image/png")})},l.clear=function(){t.clearRect(0,0,l.canvas.width,l.canvas.height),s===l.target&&l.target.attr({href:i})},l.clipRect=e.renderer.clipRect(),l.target.clip(l.clipRect)),l.canvas.width!==r&&(l.canvas.width=r),l.canvas.height!==n&&(l.canvas.height=n),l.target.attr({x:0,y:0,width:r,height:n,style:"pointer-events: none",href:i}),l.clipRect&&l.clipRect.attr(tR(e,s)),t}function c(){let t=this,s=t.options,o=t.chart,r=t.xAxis,n=t.yAxis,a=o.options.boost||{},l={timeRendering:a.timeRendering||!1,timeSeriesProcessing:a.timeSeriesProcessing||!1,timeSetup:a.timeSetup||!1},h=t.getColumn("x",!0),d=t.getColumn("y",!0),c=s.data,g=r.getExtremes(),m=g.min,f=g.max,p=n.getExtremes(),b=p.min,x=p.max,A={},y=!!t.sampling,v=s.marker&&s.marker.radius,T=t.cvsStrokeBatch||1e3,C=s.enableMouseTracking,M=s.threshold,S=tG(M),E=n.getThreshold(M),k=t.fill,w=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),R=!!s.stacking,U=t.cropStart||0,L=o.options.loading,_=t.requireSorting,N=s.connectNulls,D=!h,z=R?t.data:h||c,I=t.fillOpacity?P().parse(t.color).setOpacity(tO(s.fillOpacity,.75)).get():t.color,G="x"===s.findNearestPointBy,B=this.boost||{},O=t.cvsDrawPoint,V=s.lineWidth?t.cvsLineTo:void 0,X=v&&v<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;B.target&&B.target.attr({href:i}),(t.points||t.graph)&&tL(t),t.plotGroup("group","series",t.visible?"visible":"hidden",s.zIndex,o.seriesGroup),t.markerGroup=t.group,tz(t,"destroy",function(){t.markerGroup=null});let F=this.points=[],H=this.getContext();if(t.buildKDTree=tD,B.clear&&B.clear(),!t.visible)return;c.length>99999&&(o.options.loading=tB(L,{labelStyle:{backgroundColor:t_("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),u().clearTimeout(e),o.showLoading("Drawing..."),o.options.loading=L),l.timeRendering&&console.time("canvas rendering");let Y=0,W,j,K=E,Z,q,Q,J,$,tt,te=function(){k?(H.fillStyle=I,H.fill()):(H.strokeStyle=t.color,H.lineWidth=s.lineWidth,H.stroke())},ti=function(e,i,s,r){0===Y&&(H.beginPath(),V&&(H.lineJoin="round")),o.scroller&&"highcharts-navigator-series"===t.options.className?(i+=o.scroller.top,s&&(s+=o.scroller.top)):i+=o.plotTop,e+=o.plotLeft,Z?H.moveTo(e,i):O?O(H,e,i,s,j):V?V(H,e,i):X&&X.call(t,H,e,i,v,r),(Y+=1)===T&&(te(),Y=0),j={clientX:e,plotY:i,yBottom:s}},ts=(this.getColumn("x").length?this.getColumn("x"):void 0)||this.options.xData||!!this.getColumn("x",!0).length&&this.getColumn("x",!0),to=function(t,e,i){tt=G?t:t+","+e,C&&!A[tt]&&(A[tt]=!0,o.inverted&&(t=r.len-t,e=n.len-e),F.push({x:!!ts&&ts[U+i],clientX:t,plotX:t,plotY:e,i:U+i}))};tw.eachAsync(z,(e,i)=>{let s=void 0===o.index,a,l,h,u,c,g,p=!1,A=!1,v=NaN,P=NaN,T=!0;return!s&&(D?(a=e[0],l=e[1],z[i+1]&&(v=z[i+1][0]),z[i-1]&&(P=z[i-1][0])):(a=e,l=d[i],z[i+1]&&(v=z[i+1]),z[i-1]&&(P=z[i-1])),v&&v>=m&&v<=f&&(p=!0),P&&P>=m&&P<=f&&(A=!0),w?(D&&(l=e.slice(1,3)),g=l[0],l=l[1]):R&&(a=e.x,g=(l=e.stackY)-e.y),c=null===l,_||(T=l>=b&&l<=x),!c&&(a>=m&&a<=f&&T||p||A)&&(h=Math.round(r.toPixels(a,!0)),y?((void 0===J||h===W)&&(w||(g=l),(void 0===$||l>Q)&&(Q=l,$=i),(void 0===J||g<q)&&(q=g,J=i)),h!==W&&(void 0!==J&&(u=n.toPixels(Q,!0),K=n.toPixels(q,!0),ti(h,S?Math.min(u,E):u,S?Math.max(K,E):K,i),to(h,u,$),K!==u&&to(h,K,J)),J=$=void 0,W=h)):(ti(h,u=Math.round(n.toPixels(l,!0)),K,i),to(h,u,i))),Z=c&&!N,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!s},function(){let i=o.loadingDiv,s=o.loadingShown;te(),t.canvasToSVG(),l.timeRendering&&console.timeEnd("canvas rendering"),tI(t,"renderedCanvas"),s&&(i.style.transition="opacity 250ms",i.opacity=0,o.loadingShown=!1,e=setTimeout(function(){i.parentNode&&i.parentNode.removeChild(i),o.loadingDiv=o.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},o.renderer.forExport?Number.MAX_VALUE:void 0)}function g(t,e,i,s){t.moveTo(e,i),t.arc(e,i,s,0,2*Math.PI,!1)}function m(t,e,i,s){t.rect(e-s,i-s,2*s,2*s)}function f(){let t=this.chart,e=this.getContext(),i=this.chart.inverted,s=this.xAxis,o=this.yAxis;e?(this.points.forEach(r=>{let n,a=r.plotY;if(void 0!==a&&!isNaN(a)&&null!==r.y&&e){let{x:n=0,y:a=0,width:l=0,height:h=0}=r.shapeArgs||{};e.fillStyle=(t.styledMode?r.series.colorAttribs(r):r.series.pointAttribs(r)).fill,i?e.fillRect(o.len-a+s.left,s.len-n+o.top,-h,-l):e.fillRect(n+s.left,a+o.top,l,h)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,i){let u=e.prototype;if(!u.renderCanvas){let{area:e,bubble:p,column:b,heatmap:x,scatter:A}=i;if(t.prototype.callbacks.push(t=>{tz(t,"predraw",a),tz(t,"render",n)}),u.canvasToSVG=l,u.cvsLineTo=h,u.getContext=d,u.renderCanvas=c,e){let t=e.prototype;t.cvsDrawPoint=s,t.fill=!0,t.fillOpacity=!0,t.sampling=!0}if(p){let t=p.prototype;t.cvsMarkerCircle=o,t.cvsStrokeBatch=1}if(b){let t=b.prototype;t.cvsDrawPoint=r,t.fill=!0,t.sampling=!0}if(x&&tV(x.prototype,"drawPoints",f),A){let t=A.prototype;t.cvsMarkerCircle=g,t.cvsMarkerSquare=m,t.fill=!0}}}}(r||(r={}));let tX=r,tF=u();tF.initCanvasBoost=function(){tX.compose(tF.Chart,tF.Series,tF.seriesTypes)};let tH=u();return h.default})());