"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/EnterpriseNotification.tsx
var EnterpriseNotification_exports = {};
__export(EnterpriseNotification_exports, {
  DefaultUpgradeNotification: () => DefaultUpgradeNotification,
  EnterpriseNotification: () => EnterpriseNotification,
  default: () => EnterpriseNotification_default
});
module.exports = __toCommonJS(EnterpriseNotification_exports);
var import_react2 = require("react");
var import_react_redux = require("react-redux");
var import_react_router_dom = require("react-router-dom");
var import_material2 = require("@mui/material");
var import_mui2 = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_selectors = require("@northern.tech/store/selectors");
var import_helpers2 = require("@northern.tech/utils/helpers");

// src/helptips/MenderTooltip.tsx
var import_react = require("react");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var MenderTooltip = (0, import_mui.withStyles)(import_material.Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltipClickable = ({
  children,
  onboarding,
  startOpen = false,
  visibility = startOpen,
  onOpenChange,
  tooltipComponent = MenderTooltip,
  ...remainingProps
}) => {
  const [open, setOpen] = (0, import_react.useState)(startOpen || false);
  (0, import_react.useEffect)(() => {
    setOpen(visibility);
  }, [visibility]);
  (0, import_react.useEffect)(() => {
    if (!onOpenChange) {
      return;
    }
    onOpenChange(open);
  }, [open, onOpenChange]);
  const toggleVisibility = () => setOpen(import_helpers.toggle);
  const hide = () => setOpen(false);
  const Component = tooltipComponent;
  const extraProps = onboarding ? {
    PopperProps: {
      disablePortal: true,
      popperOptions: {
        strategy: "fixed",
        modifiers: [
          { name: "flip", enabled: false },
          { name: "preventOverflow", enabled: true, options: { boundary: window, altBoundary: false } }
        ]
      }
    }
  } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.ClickAwayListener, { onClickAway: hide, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    Component,
    {
      arrow: !onboarding,
      open,
      disableFocusListener: true,
      disableHoverListener: true,
      disableTouchListener: true,
      onOpen: () => setOpen(true),
      ...extraProps,
      ...remainingProps,
      children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { onClick: toggleVisibility, children })
    }
  ) });
};
var MenderTooltip_default = MenderTooltip;

// src/EnterpriseNotification.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var PlansTooltip = (0, import_mui2.withStyles)(MenderTooltip_default, ({ palette }) => ({
  arrow: {
    color: palette.tooltip?.tierTipBackground ?? palette.grey[100]
  },
  tooltip: {
    backgroundColor: palette.tooltip?.tierTipBackground ?? palette.grey[100],
    maxWidth: 300
  }
}));
var PlanChip = (0, import_mui2.withStyles)(import_material2.Chip, ({ palette }) => ({
  root: {
    backgroundColor: palette.tooltip?.tierTipBackground ?? palette.grey[100],
    color: palette.text.disabled,
    textTransform: "uppercase",
    "&:hover": {
      fontWeight: "bold"
    }
  }
}));
var DefaultUpgradeNotification = (props) => /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { ...props, children: [
  "This feature is not available on your plan. ",
  /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react_router_dom.Link, { to: "/subscription", children: "Upgrade" }),
  " to enable it"
] });
var EnterpriseNotification = ({ className = "", id = import_constants.BENEFITS.default.id }) => {
  const [isOpen, setIsOpen] = (0, import_react2.useState)(false);
  const tenantCapabilities = (0, import_react_redux.useSelector)(import_selectors.getTenantCapabilities);
  const { isEnterprise, plan: currentPlan } = tenantCapabilities;
  const { benefit, requiredAddon = "", requiredPlan = import_constants.PLANS.os.id } = import_constants.BENEFITS[id];
  const hasAddon = requiredAddon ? import_constants.ADDONS[requiredAddon].needs.every((need) => tenantCapabilities[need]) : false;
  const currentPlanIndex = Object.keys(import_constants.PLANS).indexOf(currentPlan);
  const requiredPlanIndex = Object.keys(import_constants.PLANS).indexOf(requiredPlan);
  const shouldShow = requiredPlanIndex > currentPlanIndex;
  if (isEnterprise || import_constants.BENEFITS[id].requiredPlan && !shouldShow || requiredAddon && hasAddon) {
    return null;
  }
  const content = requiredAddon ? /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
    "Add the ",
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("b", { children: import_constants.ADDONS[requiredAddon].title }),
    " add-on to ",
    benefit,
    "."
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
    "Upgrade to the ",
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("b", { children: import_constants.PLANS[requiredPlan].name }),
    " plan ",
    requiredPlanIndex === Object.keys(import_constants.PLANS).length - 1 ? "" : "or higher ",
    "to gain access to ",
    benefit,
    "."
  ] });
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    MenderTooltipClickable,
    {
      onOpenChange: setIsOpen,
      title: /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { children: [
        content,
        /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "flexbox space-between margin-top-small", children: [
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react_router_dom.Link, { to: "/subscription", children: "Upgrade now" }),
          /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("span", { className: "link", onClick: () => setIsOpen(false), children: "Close" })
        ] })
      ] }),
      tooltipComponent: PlansTooltip,
      visibility: isOpen,
      children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(PlanChip, { className, onClick: import_helpers2.yes, label: import_constants.PLANS[requiredPlan].name })
    }
  );
};
var EnterpriseNotification_default = EnterpriseNotification;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DefaultUpgradeNotification,
  EnterpriseNotification
});
//# sourceMappingURL=EnterpriseNotification.cjs.map