import * as _mui_material_OverridableComponent from '@mui/material/OverridableComponent';
import * as _mui_material from '@mui/material';

declare const chartTypes: {
    readonly bar: {
        readonly key: "bar";
        readonly Icon: _mui_material_OverridableComponent.OverridableComponent<_mui_material.SvgIconTypeMap<{}, "svg">> & {
            muiName: string;
        };
    };
    readonly pie: {
        readonly key: "pie";
        readonly Icon: _mui_material_OverridableComponent.OverridableComponent<_mui_material.SvgIconTypeMap<{}, "svg">> & {
            muiName: string;
        };
    };
};
declare const emptyChartSelection: {
    software: string;
    group: string;
    chartType: "bar";
    attribute: string;
};
declare const defaultReportType = "distribution";
declare const defaultReports: {
    group: null;
    attribute: string;
    type: string;
    software: string;
    chartType: "bar";
}[];
declare const BEGINNING_OF_TIME = "2016-01-01T00:00:00.000Z";
declare const locations: {
    readonly eu: {
        readonly key: "eu";
        readonly title: "EU";
        readonly location: "eu.hosted.mender.io";
    };
    readonly us: {
        readonly key: "us";
        readonly title: "US";
        readonly location: "hosted.mender.io";
    };
};
type AvailablePlans = 'os' | 'professional' | 'enterprise';
type Plan = {
    description: string;
    deviceCount: string;
    features: string[];
    id: AvailablePlans;
    minimalDeviceCount: number;
    name: string;
    offer?: boolean;
    offerprice?: string;
    price: string;
    price2?: string;
};
type AvailableAddon = 'configure' | 'troubleshoot' | 'monitor';
declare const PLANS: {
    [key in AvailablePlans]: Plan;
};
type Addon = {
    description: string;
    eligible: AvailablePlans[];
    id: string;
    needs: string[];
    title: string;
} & {
    [key in Exclude<AvailablePlans, 'enterprise'>]: {
        deviceCount: string;
        price: string;
    };
};
type AddonId = keyof typeof ADDONS;
declare const ADDONS: {
    [key in AvailableAddon]: Addon;
};
declare const BENEFITS: {
    readonly auditlog: {
        readonly id: "auditlog";
        readonly benefit: "trace change across your devices and access troubleshooting session replay";
        readonly requiredPlan: AvailablePlans;
    };
    readonly dashboard: {
        readonly id: "dashboard";
        readonly benefit: "actionable insights into the devices you are updating with Mender";
        readonly requiredPlan: AvailablePlans;
    };
    readonly deltaGeneration: {
        readonly id: "deltaGeneration";
        readonly benefit: "automatic delta artifacts generation to minimize data transfer and improve the update delivery";
        readonly requiredPlan: AvailablePlans;
    };
    readonly deviceConfiguration: {
        readonly id: "deviceConfiguration";
        readonly benefit: "device configuration features";
        readonly requiredAddon: string;
    };
    readonly deviceMonitor: {
        readonly id: "deviceMonitor";
        readonly benefit: "device monitoring features";
        readonly requiredAddon: string;
        readonly requiredPlan: AvailablePlans;
    };
    readonly deviceTroubleshoot: {
        readonly id: "deviceTroubleshoot";
        readonly benefit: "device troubleshooting features";
        readonly requiredAddon: string;
    };
    readonly dynamicGroups: {
        readonly id: "dynamicGroups";
        readonly benefit: "create dynamic groups to ease device management";
        readonly requiredPlan: AvailablePlans;
    };
    readonly fullFiltering: {
        readonly id: "fullFiltering";
        readonly benefit: "filtering by multiple attributes to improve the device overview";
        readonly requiredPlan: AvailablePlans;
    };
    readonly gateway: {
        readonly id: "gateway";
        readonly benefit: "see devices connected to your gateway device for easy access";
        readonly requiredPlans: AvailablePlans;
    };
    readonly pausedDeployments: {
        readonly id: "pausedDeployments";
        readonly benefit: "granular control about update rollout to allow synchronization across your fleet";
        readonly requiredPlan: AvailablePlans;
    };
    readonly phasedDeployments: {
        readonly id: "phasedDeployments";
        readonly benefit: "choose to roll out deployments in multiple phases";
        readonly requiredPlan: AvailablePlans;
    };
    readonly rbac: {
        readonly id: "rbac";
        readonly benefit: "granular role based access control";
        readonly requiredPlan: AvailablePlans;
    };
    readonly retryDeployments: {
        readonly id: "retryDeployments";
        readonly benefit: "optional retries for failed rollout attempts";
        readonly requiredPlan: AvailablePlans;
    };
    readonly scheduledDeployments: {
        readonly id: "scheduledDeployments";
        readonly benefit: "scheduled deployments to steer the distribution of your updates.";
        readonly requiredPlan: AvailablePlans;
    };
    readonly webhookEvents: {
        readonly id: "webhookEvents";
        readonly benefit: "receive inventory events and select which type(s) of events the webhook will receive";
        readonly requiredPlan: AvailablePlans;
    };
    readonly default: {
        readonly id: "default";
        readonly benefit: "gain access to this feature";
        readonly requiredPlan: AvailablePlans;
    };
};
declare const yes: () => boolean;
declare const canAccess: () => boolean;
declare const DARK_MODE = "dark";
declare const LIGHT_MODE = "light";

export { ADDONS, type Addon, type AddonId, type AvailableAddon, type AvailablePlans, BEGINNING_OF_TIME, BENEFITS, DARK_MODE, LIGHT_MODE, PLANS, type Plan, canAccess, chartTypes, defaultReportType, defaultReports, emptyChartSelection, locations, yes };
