import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { SnackbarProps } from '@mui/material';
import { SortOptions } from '@northern.tech/utils/constants';

declare const sliceName = "app";
type Repository = {
    name: string;
    version: string;
};
type VersionRelease = Partial<{
    [versionInfo: string]: VersionRelease;
}> & {
    release?: string;
    release_date?: string;
    repos?: Repository[];
    supported_until?: string;
};
type SaasVersion = {
    date: string;
    tag: string;
};
type ReleaseData = {
    lts: string[];
    releases: {
        [version: string]: VersionRelease;
    };
    saas: SaasVersion[];
};
type TagData = {
    name: string;
}[];
interface SnackbarContent extends Pick<SnackbarProps, 'action' | 'autoHideDuration' | 'message' | 'open'> {
    preventClickToCopy?: boolean;
}
interface SearchState {
    deviceIds: string[];
    isSearching: boolean;
    page?: number;
    perPage?: number;
    searchTerm: string;
    searchTotal: number;
    sort: SortOptions;
}
interface Upload {
    cancelSource: any;
    inprogress?: boolean;
    name?: string;
    progress: number;
    size?: number;
}
type UILatestRelease = {
    releaseDate: string;
    repos: Record<string, string>;
};
type VersionInformation = {
    [key: string]: string | UILatestRelease | undefined;
    backend?: string;
    GUI?: string;
    latestRelease?: UILatestRelease;
};
type SentryConfig = {
    isReduxEnabled?: string;
    location: string;
    replaysSessionSampleRate?: number;
    tracesSampleRate?: number;
};
type AppSliceType = {
    cancelSource: any;
    commit: string;
    demoArtifactLink: string;
    docsVersion: string;
    features: Record<string, boolean>;
    feedbackProbability: number;
    firstLoginAfterSignup: boolean;
    hostAddress: string | null;
    hostedAnnouncement: string;
    newThreshold: string;
    offlineThreshold: string;
    recaptchaSiteKey: string;
    searchState: SearchState;
    sentry: SentryConfig;
    snackbar: SnackbarContent;
    stripeAPIKey: string;
    trackerCode: string;
    uploadsById: Record<string, Upload>;
    versionInformation: VersionInformation;
    yesterday?: string;
};
declare const initialState: AppSliceType;
declare const appSlice: _reduxjs_toolkit.Slice<AppSliceType, {
    setFeatures: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<Record<string, boolean>>) => void;
    setSnackbar: (state: immer.WritableDraft<AppSliceType>, { payload }: PayloadAction<SnackbarContent | string>) => void;
    setFirstLoginAfterSignup: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<boolean>) => void;
    setAnnouncement: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<string>) => void;
    setSearchState: (state: immer.WritableDraft<AppSliceType>, action: {
        payload: any;
        type: string;
    }) => void;
    setOfflineThreshold: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<string>) => void;
    initUpload: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<{
        id: string;
        upload: Upload;
    }>) => void;
    uploadProgress: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<{
        id: string;
        progress: number;
    }>) => void;
    cleanUpUpload: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<string>) => void;
    setVersionInformation: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<VersionInformation>) => void;
    setEnvironmentData: (state: immer.WritableDraft<AppSliceType>, action: {
        payload: any;
        type: string;
    }) => any;
}, "app", "app", _reduxjs_toolkit.SliceSelectors<AppSliceType>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    setFeatures: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<Record<string, boolean>>) => void;
    setSnackbar: (state: immer.WritableDraft<AppSliceType>, { payload }: PayloadAction<SnackbarContent | string>) => void;
    setFirstLoginAfterSignup: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<boolean>) => void;
    setAnnouncement: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<string>) => void;
    setSearchState: (state: immer.WritableDraft<AppSliceType>, action: {
        payload: any;
        type: string;
    }) => void;
    setOfflineThreshold: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<string>) => void;
    initUpload: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<{
        id: string;
        upload: Upload;
    }>) => void;
    uploadProgress: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<{
        id: string;
        progress: number;
    }>) => void;
    cleanUpUpload: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<string>) => void;
    setVersionInformation: (state: immer.WritableDraft<AppSliceType>, action: PayloadAction<VersionInformation>) => void;
    setEnvironmentData: (state: immer.WritableDraft<AppSliceType>, action: {
        payload: any;
        type: string;
    }) => any;
}, "app">;
declare const _default: redux.Reducer<AppSliceType>;

export { type ReleaseData, type Repository, type SaasVersion, type SearchState, type SentryConfig, type SnackbarContent, type TagData, type Upload, type VersionRelease, actions, appSlice, _default as default, initialState, sliceName };
