import {
  ALL_DEVICES,
  ATTRIBUTE_SCOPES,
  AUDIT_LOGS_TYPES,
  DEPLOYMENT_ROUTES,
  DEPLOYMENT_STATES,
  DEPLOYMENT_TYPES,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  UNGROUPED_GROUP,
  emptyFilter
} from "./chunk-7C4SQBEE.js";

// src/locationutils.ts
import { deepCompare, getISOStringBoundaries } from "@northern.tech/utils/helpers";
var SEPARATOR = ":";
var defaultSelector = (result) => result[0];
var commonFields = {
  ...Object.keys(DEVICE_LIST_DEFAULTS).reduce((accu, key) => ({ ...accu, [key]: { parse: Number, select: defaultSelector, target: key } }), {}),
  id: { parse: String, select: (i) => i, target: "id" },
  issues: { parse: void 0, select: defaultSelector, target: "selectedIssues" },
  open: { parse: Boolean, select: defaultSelector, target: "open" }
};
var scopes = {
  identity: { delimiter: "identity", filters: [] },
  inventory: { delimiter: "inventory", filters: [] },
  monitor: { delimiter: "monitor", filters: [] },
  system: { delimiter: "system", filters: [] },
  tags: { delimiter: "tags", filters: [] }
};
var commonProcessor = (searchParams) => {
  const params = new URLSearchParams(searchParams);
  const pageState = Object.entries(commonFields).reduce((accu, [key, { parse, select, target }]) => {
    const values = params.getAll(key);
    if (!values.length) {
      return accu;
    }
    if (!parse) {
      accu[target] = values;
    } else {
      try {
        accu[target] = select(values.map(parse));
      } catch (error) {
        console.log("encountered faulty url param, continue...", error);
      }
    }
    return accu;
  }, {});
  Object.keys(commonFields).map((key) => params.delete(key));
  const sort = params.has("sort") ? params.getAll("sort").reduce((sortAccu, scopedQuery) => {
    const items = scopedQuery.split(SEPARATOR).reverse();
    return ["direction", "key", "scope"].reduce((accu, key, index) => {
      if (items[index]) {
        accu[key] = items[index];
      }
      return accu;
    }, sortAccu);
  }, {}) : void 0;
  params.delete("sort");
  return { pageState, params, sort };
};
var legacyDeviceQueryParse = (searchParams, filteringAttributes) => {
  const params = new URLSearchParams(searchParams);
  const result = Object.keys(scopes).reduce((accu, scope) => ({ ...accu, [scope]: [] }), {});
  if (params.get("group")) {
    result.inventory.push({ ...emptyFilter, key: "group", scope: "inventory", operator: DEVICE_FILTERING_OPTIONS.$eq.key, value: params.get("group") });
    params.delete("group");
  }
  const filters = [...params.keys()].reduce(
    (accu, key) => params.getAll(key).reduce((innerAccu, value) => {
      const scope = Object.entries(filteringAttributes).reduce((foundScope, [currentScope, attributes]) => {
        if (foundScope) {
          return foundScope;
        }
        return attributes.includes(key) ? currentScope.substring(0, currentScope.indexOf("Attributes")) : foundScope;
      }, void 0) ?? ATTRIBUTE_SCOPES.inventory;
      innerAccu[scope].push({ ...emptyFilter, scope, key, operator: DEVICE_FILTERING_OPTIONS.$eq.key, value });
      return innerAccu;
    }, accu),
    result
  );
  [...params.keys()].map((key) => params.delete(key));
  return { filters, params };
};
var scopedFilterParse = (searchParams) => {
  const params = new URLSearchParams(searchParams);
  const filters = Object.keys(scopes).reduce(
    (accu, scope) => {
      accu[scope] = [];
      if (!params.has(scope)) {
        return accu;
      }
      accu[scope] = params.getAll(scope).map((scopedQuery) => {
        const items = scopedQuery.split(SEPARATOR);
        return { ...emptyFilter, scope, key: items[0], operator: `$${items[1]}`, value: items.slice(2).join(SEPARATOR) };
      });
      return accu;
    },
    { ...scopes }
  );
  Object.keys(scopes).map((scope) => params.delete(scope));
  return { filters, params };
};
var parseDeviceQuery = (searchParams, extraProps = {}) => {
  let queryParams = new URLSearchParams(searchParams);
  const { filteringAttributes = {}, pageState = {} } = extraProps;
  const pageStateExtension = pageState.id?.length === 1 ? { open: true } : {};
  let scopedFilters;
  const refersOldStyleAttributes = Object.values(filteringAttributes).some((scopeValues) => scopeValues.some((scopedValue) => queryParams.get(scopedValue)));
  if (refersOldStyleAttributes && !Object.keys(scopes).some((scope) => queryParams.get(scope)) || queryParams.get("group")) {
    const { filters, params } = legacyDeviceQueryParse(queryParams, filteringAttributes);
    scopedFilters = filters;
    queryParams = params;
  } else {
    const { filters, params } = scopedFilterParse(queryParams);
    scopedFilters = filters;
    queryParams = params;
  }
  let groupName = "";
  const groupFilterIndex = scopedFilters.inventory.findIndex((filter) => filter.key === "group" && filter.operator === DEVICE_FILTERING_OPTIONS.$eq.key);
  if (groupFilterIndex > -1) {
    groupName = scopedFilters.inventory[groupFilterIndex].value;
    scopedFilters.inventory.splice(groupFilterIndex, 1);
  }
  const detailsTab = queryParams.has("tab") ? queryParams.get("tab") : "";
  return { detailsTab, filters: Object.values(scopedFilters).flat(), groupName, ...pageStateExtension };
};
var formatSorting = (sort, { sort: sortDefault }) => {
  if (!sort || deepCompare(sort, sortDefault)) {
    return "";
  }
  const sortQuery = ["scope", "key", "direction"].reduce((accu, key) => {
    if (!sort[key]) {
      return accu;
    }
    accu.push(sort[key]);
    return accu;
  }, []).join(SEPARATOR);
  return `sort=${sortQuery}`;
};
var formatPageState = ({ selectedId, selectedIssues, page, perPage, sort }, { defaults }) => Object.entries({ page, perPage, id: selectedId, issues: selectedIssues, open: selectedId ? true : void 0 }).reduce(
  (accu, [key, value]) => {
    if (Array.isArray(value)) {
      accu.push(...value.map((item) => `${key}=${encodeURIComponent(item)}`));
    } else if ((DEVICE_LIST_DEFAULTS[key] != value || !DEVICE_LIST_DEFAULTS.hasOwnProperty(key)) && value) {
      accu.push(`${key}=${encodeURIComponent(value)}`);
    }
    return accu;
  },
  [formatSorting(sort, defaults)]
).filter((i) => i).join("&");
var stripFilterOperator = (operator) => operator.replaceAll("$", "");
var formatFilters = (filters) => {
  const result = filters.reduce(
    (accu, filter) => {
      const { scope = ATTRIBUTE_SCOPES.inventory, operator = "$eq" } = filter;
      accu[scope].add(`${scopes[scope].delimiter}=${filter.key}${SEPARATOR}${stripFilterOperator(operator)}${SEPARATOR}${encodeURIComponent(filter.value)}`);
      return accu;
    },
    Object.keys(scopes).reduce((accu, item) => ({ ...accu, [item]: /* @__PURE__ */ new Set() }), {})
  );
  return Object.values(result).map((filterSet) => [...filterSet]).flat();
};
var formatDeviceSearch = ({ pageState, filters, selectedGroup }) => {
  let activeFilters = [...filters];
  if (selectedGroup && selectedGroup !== ALL_DEVICES) {
    const isUngroupedGroup = selectedGroup === UNGROUPED_GROUP.id;
    activeFilters = isUngroupedGroup ? activeFilters.filter(
      (filter) => !(filter.key === "group" && filter.scope === ATTRIBUTE_SCOPES.system && filter.operator === DEVICE_FILTERING_OPTIONS.$nin.key)
    ) : activeFilters;
    const groupName = isUngroupedGroup ? UNGROUPED_GROUP.name : selectedGroup;
    activeFilters.push({ scope: ATTRIBUTE_SCOPES.inventory, key: "group", operator: DEVICE_FILTERING_OPTIONS.$eq.key, value: groupName });
  }
  const formattedFilters = formatFilters(activeFilters).filter((i) => i);
  if (pageState.detailsTab && pageState.selectedId) {
    formattedFilters.push(`tab=${pageState.detailsTab}`);
  }
  return formattedFilters.join("&");
};
var generateDevicePath = ({ pageState }) => {
  const { state: selectedState } = pageState;
  const path = ["/devices"];
  if (selectedState !== "") {
    path.push(selectedState);
  }
  return path.join("/");
};
var formatDates = ({ endDate, params, startDate, today, tonight }) => {
  if (endDate && endDate !== tonight) {
    params.set("endDate", endDate.split("T")[0]);
  }
  if (startDate && startDate !== today) {
    params.set("startDate", startDate.split("T")[0]);
  }
  return params;
};
var paramReducer = (accu, [key, value]) => {
  if (value) {
    accu.set(key, value);
  }
  return accu;
};
var formatAuditlogs = ({ pageState }, { today, tonight }) => {
  const { detail, endDate, startDate, type, user } = pageState;
  let params = new URLSearchParams();
  let userId = user;
  if (user?.id) {
    userId = user.id;
  }
  params = Object.entries({ objectId: detail, userId }).reduce(paramReducer, params);
  if (type) {
    params.set("objectType", type.value ?? type);
  }
  params = formatDates({ endDate, params, startDate, today, tonight });
  return params.toString();
};
var parseDateParams = (params, today, tonight) => {
  let endDate = tonight;
  if (params.get("endDate")) {
    endDate = getISOStringBoundaries(new Date(params.get("endDate"))).end;
  }
  let startDate = today;
  if (params.get("startDate")) {
    startDate = getISOStringBoundaries(new Date(params.get("startDate"))).start;
  }
  return { endDate, startDate };
};
var parseAuditlogsQuery = (params, { today, tonight }) => {
  const type = AUDIT_LOGS_TYPES.find((typeObject) => typeObject.value === params.get("objectType"));
  const { endDate, startDate } = parseDateParams(params, today, tonight);
  return {
    detail: params.get("objectId"),
    endDate,
    startDate,
    type,
    user: params.get("userId")
  };
};
var formatActiveDeployments = (pageState, { defaults }) => [DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.pending].reduce((accu, state) => {
  const { page, perPage } = pageState[state] ?? {};
  const stateDefaults = defaults[state] ?? {};
  const items = Object.entries({ page, perPage }).reverse().reduce((keyAccu, [key, value]) => {
    if (value && value !== stateDefaults[key] || keyAccu.length) {
      keyAccu.unshift(value || stateDefaults[key]);
    }
    return keyAccu;
  }, []);
  if (items.length) {
    accu.push(`${state}=${items.join(SEPARATOR)}`);
  }
  return accu;
}, []).filter((i) => i).join("&");
var formatDeployments = ({ deploymentObject, pageState }, { defaults, today, tonight }) => {
  const { state: selectedState, showCreationDialog } = pageState.general;
  let params = new URLSearchParams();
  if (showCreationDialog) {
    params.set("open", true);
    if (deploymentObject.release) {
      params.set("release", deploymentObject.release.name);
    }
    if (deploymentObject.devices?.length) {
      deploymentObject.devices.map(({ id }) => params.append("deviceId", id));
    }
  }
  let pageStateQuery;
  if (selectedState === DEPLOYMENT_ROUTES.finished.key) {
    const { endDate, search, startDate, type } = pageState[selectedState];
    params = formatDates({ endDate, params, startDate, today, tonight });
    params = Object.entries({ search, type }).reduce(paramReducer, params);
    pageStateQuery = formatPageState(pageState[selectedState], { defaults });
  } else if (selectedState === DEPLOYMENT_ROUTES.scheduled.key) {
    pageStateQuery = formatPageState(pageState[selectedState], { defaults });
  } else {
    pageStateQuery = formatActiveDeployments(pageState, { defaults });
  }
  return [pageStateQuery, params.toString()].filter((i) => i).join("&");
};
var deploymentsPath = "deployments/";
var parseDeploymentsPath = (path) => {
  const parts = path.split(deploymentsPath);
  if (parts.length > 1 && Object.keys(DEPLOYMENT_ROUTES).includes(parts[1])) {
    return parts[1];
  }
  return "";
};
var parseActiveDeployments = (params) => [DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.pending].reduce((accu, state) => {
  if (!params.has(state)) {
    return accu;
  }
  const items = params.get(state).split(SEPARATOR);
  accu[state] = ["page", "perPage"].reduce((stateAccu, key, index) => items[index] ? { ...stateAccu, [key]: Number(items[index]) } : stateAccu, {});
  return accu;
}, {});
var deploymentFields = {
  deviceId: { attribute: "devices", parse: (id) => ({ id }), select: (i) => i },
  release: { attribute: "release", parse: String, select: defaultSelector }
};
var parseDeploymentsQuery = (params, { pageState, location, tonight }) => {
  const { endDate, startDate } = parseDateParams(params, "", tonight);
  const deploymentObject = Object.entries(deploymentFields).reduce(
    (accu, [key, { attribute, parse, select }]) => params.has(key) ? { ...accu, [attribute]: select(params.getAll(key).map(parse)) } : accu,
    {}
  );
  const { state: selectedState, id, open, ...remainingPageState } = pageState;
  const tab = parseDeploymentsPath(location.pathname);
  const deploymentsTab = tab || selectedState || DEPLOYMENT_ROUTES.active.key;
  let state = {
    deploymentObject,
    general: {
      showCreationDialog: Boolean(open && !id),
      showReportDialog: Boolean(open && id),
      state: deploymentsTab
    }
  };
  if (deploymentsTab === DEPLOYMENT_ROUTES.finished.key) {
    const type = DEPLOYMENT_TYPES[params.get("type")] || "";
    const search = params.get("search") || "";
    state[deploymentsTab] = { ...remainingPageState, endDate, search, startDate, type };
  } else if (deploymentsTab === DEPLOYMENT_ROUTES.scheduled.key) {
    state[deploymentsTab] = { ...remainingPageState };
  } else {
    state = {
      ...state,
      ...parseActiveDeployments(params)
    };
  }
  return state;
};
var generateDeploymentsPath = ({ pageState }) => {
  const { state: selectedState = DEPLOYMENT_ROUTES.active.key } = pageState.general;
  return `/deployments/${selectedState}`;
};
var releasesRoot = "/releases";
var formatReleases = ({ pageState: { searchTerm, selectedTags = [], tab, type } }) => Object.entries({ name: searchTerm, tab, type }).reduce(
  (accu, [key, value]) => value ? [...accu, `${key}=${value}`] : accu,
  selectedTags.map((tag) => `tag=${tag}`)
).join("&");
var generateReleasesPath = ({ pageState: { selectedRelease } }) => `${releasesRoot}${selectedRelease ? `/${encodeURIComponent(selectedRelease)}` : ""}`;
var parseReleasesQuery = (queryParams, extraProps) => {
  const name = queryParams.has("name") ? queryParams.get("name") : "";
  const tab = queryParams.has("tab") ? queryParams.get("tab") : void 0;
  const tags = queryParams.has("tag") ? queryParams.getAll("tag") : [];
  const type = queryParams.has("type") ? queryParams.get("type") : "";
  let selectedRelease = decodeURIComponent(extraProps.location.pathname.substring(releasesRoot.length + 1));
  if (!selectedRelease && extraProps.pageState.id?.length) {
    selectedRelease = extraProps.pageState.id[0];
  }
  return { searchTerm: name, selectedRelease, tab, tags, type };
};
var tenantsRoot = "/tenants";
var generateTenantPath = ({ pageState: { selectedTenant } }) => {
  if (selectedTenant) {
    return `${tenantsRoot}/${encodeURIComponent(selectedTenant)}`;
  } else {
    return tenantsRoot;
  }
};
var generateTenantPathById = (id) => id ? `${tenantsRoot}/${encodeURIComponent(id)}` : tenantsRoot;
var parseTenantsQuery = (queryParams, extraProps) => {
  const name = queryParams.has("name") ? queryParams.get("name") : "";
  let selectedTenant = extraProps.location.pathname.substring(tenantsRoot.length + 1);
  if (!selectedTenant && extraProps.pageState.id?.length) {
    selectedTenant = extraProps.pageState.id[0];
  }
  return { name, selectedTenant };
};
var formatTenants = () => "";

export {
  commonProcessor,
  parseDeviceQuery,
  formatPageState,
  formatDeviceSearch,
  generateDevicePath,
  formatAuditlogs,
  parseDateParams,
  parseAuditlogsQuery,
  formatDeployments,
  parseDeploymentsQuery,
  generateDeploymentsPath,
  formatReleases,
  generateReleasesPath,
  parseReleasesQuery,
  generateTenantPath,
  generateTenantPathById,
  parseTenantsQuery,
  formatTenants
};
//# sourceMappingURL=chunk-KC7SKI3U.js.map