"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/resizehook.ts
var resizehook_exports = {};
__export(resizehook_exports, {
  default: () => resizehook_default,
  useWindowSize: () => useWindowSize
});
module.exports = __toCommonJS(resizehook_exports);
var import_react = require("react");
var halfASecond = 500;
var useWindowSize = () => {
  const [size, setSize] = (0, import_react.useState)({ height: window.innerHeight, width: window.innerWidth });
  const timer = (0, import_react.useRef)(void 0);
  (0, import_react.useLayoutEffect)(() => {
    const handleResize = () => {
      timer.current = setTimeout(() => setSize({ height: window.innerHeight, width: window.innerWidth }), halfASecond);
    };
    window.addEventListener("resize", handleResize);
    handleResize();
    return () => {
      clearTimeout(timer.current);
      window.removeEventListener("resize", handleResize);
    };
  }, []);
  return size;
};
var resizehook_default = useWindowSize;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  useWindowSize
});
//# sourceMappingURL=resizehook.cjs.map