import {
  Loader_default
} from "./chunk-3AOVUJ7W.js";

// src/AsyncAutocomplete.tsx
import { useEffect, useState } from "react";
import { Autocomplete, TextField, useTheme } from "@mui/material";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { useDebounce } from "@northern.tech/utils/debouncehook";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var AsyncAutocomplete = ({
  id,
  initialValue,
  isLoading,
  label,
  placeholder,
  styles,
  selectionAttribute,
  labelAttribute,
  onChange,
  onChangeSelection,
  options
}) => {
  const theme = useTheme();
  const [open, setOpen] = useState(false);
  const [inputValue, setInputValue] = useState(initialValue);
  const loading = open && isLoading;
  const debouncedValue = useDebounce(inputValue, TIMEOUTS.debounceShort);
  useEffect(() => {
    if (debouncedValue === void 0) {
      return;
    }
    const selection = options.find((option) => option[selectionAttribute] === debouncedValue);
    if (selection) {
      onChangeSelection(selection);
    } else {
      onChange(debouncedValue);
    }
  }, [debouncedValue, JSON.stringify(options), onChange, onChangeSelection, selectionAttribute]);
  const onInputChange = (e, value, reason) => {
    if (reason === "clear") {
      setInputValue("");
      return onChangeSelection();
    } else if (reason === "reset" && !e || reason === "blur") {
      return;
    }
    setInputValue(value);
  };
  return /* @__PURE__ */ jsx(
    Autocomplete,
    {
      autoHighlight: true,
      freeSolo: true,
      getOptionLabel: (option) => option[labelAttribute],
      isOptionEqualToValue: (option, value) => option[selectionAttribute] === value[selectionAttribute],
      id,
      inputValue: inputValue || "",
      loading,
      onClose: () => setOpen(false),
      onInputChange,
      onOpen: () => setOpen(true),
      open,
      openOnFocus: true,
      options,
      renderInput: (params) => /* @__PURE__ */ jsx(
        TextField,
        {
          ...params,
          label,
          placeholder,
          style: styles.textField,
          slotProps: {
            input: {
              ...params.InputProps,
              endAdornment: /* @__PURE__ */ jsxs(Fragment, { children: [
                loading && /* @__PURE__ */ jsx(Loader_default, { show: true, small: true, table: true, style: { marginTop: theme.spacing(-4) } }),
                params.InputProps.endAdornment
              ] })
            }
          }
        }
      )
    }
  );
};
var AsyncAutocomplete_default = AsyncAutocomplete;

export {
  AsyncAutocomplete,
  AsyncAutocomplete_default
};
//# sourceMappingURL=chunk-6FVSRYRA.js.map