import * as react_jsx_runtime from 'react/jsx-runtime';
import { Credentials, Integration } from '@northern.tech/types/MenderTypes';
import { DEVICE_FILTERING_OPTIONS } from '@northern.tech/utils/constants';

declare const timeUnits: {
    days: string;
    minutes: string;
    hours: string;
};
declare const UNGROUPED_GROUP: {
    id: string;
    name: string;
};
declare const DEVICE_LIST_MAXIMUM_LENGTH = 50;
type FilterOperator = keyof typeof DEVICE_FILTERING_OPTIONS;
declare const TIMEOUTS: {
    debounceDefault: number;
    debounceShort: number;
    halfASecond: number;
    oneSecond: number;
    twoSeconds: number;
    threeSeconds: number;
    fiveSeconds: number;
    refreshDefault: number;
    refreshLong: number;
};
declare const DEVICE_ONLINE_CUTOFF: {
    interval: number;
    intervalName: string;
};
declare const defaultIdAttribute: Readonly<{
    attribute: "id";
    scope: "identity";
}>;
declare const credentialTypes: {
    aws: Credentials.type;
    http: Credentials.type;
    sas: Credentials.type;
    x509: string;
};
declare const EXTERNAL_PROVIDER: {
    readonly 'iot-core': {
        readonly credentialsType: Credentials.type.AWS;
        readonly icon: string;
        readonly title: "AWS IoT Core";
        readonly twinTitle: "Device Shadow";
        readonly provider: "iot-core";
        readonly enabled: true;
        readonly deviceTwin: true;
        readonly configHint: react_jsx_runtime.JSX.Element;
    };
    readonly 'iot-hub': {
        readonly credentialsType: Credentials.type.SAS;
        readonly icon: string;
        readonly title: "Azure IoT Hub";
        readonly twinTitle: "Device Twin";
        readonly provider: "iot-hub";
        readonly enabled: true;
        readonly deviceTwin: true;
        readonly configHint: react_jsx_runtime.JSX.Element;
    };
    readonly webhook: {
        readonly credentialsType: Credentials.type.HTTP;
        readonly deviceTwin: false;
        readonly twinTitle: "";
        readonly enabled: false;
        readonly provider: "webhook";
    };
};
interface Webhook extends Integration {
    provider: Integration.provider.WEBHOOK;
}
declare const emptyWebhook: Webhook;
interface CountryType {
    code: string;
    label: string;
}
declare const MAX_PAGE_SIZE = 500;
declare const countries: readonly CountryType[];

export { DEVICE_LIST_MAXIMUM_LENGTH, DEVICE_ONLINE_CUTOFF, EXTERNAL_PROVIDER, type FilterOperator, MAX_PAGE_SIZE, TIMEOUTS, UNGROUPED_GROUP, type Webhook, countries, credentialTypes, defaultIdAttribute, emptyWebhook, timeUnits };
