import * as react_jsx_runtime from 'react/jsx-runtime';
import { ComponentType, CSSProperties, ReactElement } from 'react';
import { IdAttribute, SortOptions } from '@northern.tech/store/constants';

interface Attribute {
    name: string;
    scope: string;
}
interface RendererProp<T> {
    [key: string]: any;
    column: ColumnHeader<T>;
    item?: T;
}
interface ClassesOverrides {
    classes: Record<string, string>;
}
interface ColumnHeader<T> {
    attribute: Attribute;
    classes?: ClassesOverrides;
    component: ComponentType<RendererProp<T> & ClassesOverrides>;
    customize?: () => void;
    sortable: boolean;
    style?: CSSProperties;
    textRender?: (props: RendererProp<T>) => string | ReactElement;
    title: string;
}
interface ListState {
    page?: number;
    perPage?: number;
    selection?: number[];
    sort?: SortOptions;
    total: number;
}
type wID = {
    id: string;
};
interface CommonListProps<T extends wID> {
    columnHeaders: ColumnHeader<T>[];
    customColumnSizes?: Attribute[];
    idAttribute?: IdAttribute;
    ListItemComponent: ComponentType<ListItemComponentProps<T>>;
    listItems: T[];
    listState: ListState;
    onChangeRowsPerPage: (perPage: number) => void;
    onExpandClick: (item: T) => void;
    onPageChange: (event: MouseEvent | null, page: number) => void;
    onResizeColumns: ((columns: {
        attribute: Attribute;
        size: number;
    }) => void) | false;
    onSelect: ((rows: number[]) => void) | false;
    onSort?: (attr: Attribute | object) => void;
    pageLoading: boolean;
    PaginationProps?: object;
    sortingNotes?: {
        [key: string]: string;
    };
}
interface ListItemComponentProps<T> {
    columnHeaders: ColumnHeader<T>[];
    idAttribute?: IdAttribute;
    index: number;
    key: string;
    listItem: T;
    listState: ListState;
    onClick: (item: T) => void;
    onRowSelect: (selectedRow: T) => void;
    selectable: boolean;
    selected: boolean;
}
declare const minCellWidth = 150;
declare const calculateResizeChange: ({ columnElements, columnHeaders, e, index, prev, selectable }: {
    columnElements: any;
    columnHeaders: any;
    e: any;
    index: any;
    prev: any;
    selectable: any;
}) => any;
declare const CommonList: <T extends wID>(props: CommonListProps<T>) => react_jsx_runtime.JSX.Element;

export { type ClassesOverrides, type ColumnHeader, CommonList, type ListItemComponentProps, type RendererProp, calculateResizeChange, minCellWidth };
