/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/exporting
 * @requires highcharts
 *
 * Exporting module
 *
 * (c) 2010-2025 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */import*as e from"../highcharts.js";var t,n,i={};i.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return i.d(t,{a:t}),t},i.d=(e,t)=>{for(var n in t)i.o(t,n)&&!i.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},i.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t);let o=e.default;var r=i.n(o);let a=e.default.AST;var l=i.n(a);let s=e.default.Chart;var c=i.n(s),h=t||(t={});h.compose=function(e){return e.navigation||(e.navigation=new p(e)),e};class p{constructor(e){this.updates=[],this.chart=e}addUpdate(e){this.chart.navigation.updates.push(e)}update(e,t){this.updates.forEach(n=>{n.call(this.chart,e,t)})}}h.Additions=p;let d=t,{isSafari:u,win:g,win:{document:f}}=r(),{error:m}=r(),y=g.URL||g.webkitURL||g;function x(e){let t=e.replace(/filename=.*;/,"").match(/data:([^;]*)(;base64)?,([A-Z+\d\/]+)/i);if(t&&t.length>3&&g.atob&&g.ArrayBuffer&&g.Uint8Array&&g.Blob&&y.createObjectURL){let e=g.atob(t[3]),n=new g.ArrayBuffer(e.length),i=new g.Uint8Array(n);for(let t=0;t<i.length;++t)i[t]=e.charCodeAt(t);return y.createObjectURL(new g.Blob([i],{type:t[1]}))}}let{isTouchDevice:w}=r(),b={exporting:{allowTableSorting:!0,libURL:"https://code.highcharts.com/12.4.0/lib/",local:!0,type:"image/png",url:`https://export-svg.highcharts.com?v=${r().version}`,pdfFont:{normal:void 0,bold:void 0,bolditalic:void 0,italic:void 0},printMaxWidth:780,scale:2,buttons:{contextButton:{className:"highcharts-contextbutton",menuClassName:"highcharts-contextmenu",symbol:"menu",titleKey:"contextButtonTitle",menuItems:["viewFullscreen","printChart","separator","downloadPNG","downloadJPEG","downloadSVG"]}},menuItemDefinitions:{viewFullscreen:{textKey:"viewFullscreen",onclick:function(){this.fullscreen?.toggle()}},printChart:{textKey:"printChart",onclick:function(){this.exporting?.print()}},separator:{separator:!0},downloadPNG:{textKey:"downloadPNG",onclick:async function(){await this.exporting?.exportChart()}},downloadJPEG:{textKey:"downloadJPEG",onclick:async function(){await this.exporting?.exportChart({type:"image/jpeg"})}},downloadPDF:{textKey:"downloadPDF",onclick:async function(){await this.exporting?.exportChart({type:"application/pdf"})}},downloadSVG:{textKey:"downloadSVG",onclick:async function(){await this.exporting?.exportChart({type:"image/svg+xml"})}}}},lang:{viewFullscreen:"View in full screen",exitFullscreen:"Exit from full screen",printChart:"Print chart",downloadPNG:"Download PNG image",downloadJPEG:"Download JPEG image",downloadPDF:"Download PDF document",downloadSVG:"Download SVG vector image",contextButtonTitle:"Chart context menu"},navigation:{buttonOptions:{symbolSize:14,symbolX:14.5,symbolY:13.5,align:"right",buttonSpacing:5,height:28,y:-5,verticalAlign:"top",width:28,symbolFill:"#666666",symbolStroke:"#666666",symbolStrokeWidth:3,theme:{fill:"#ffffff",padding:5,stroke:"none","stroke-linecap":"round"}},menuStyle:{border:"none",borderRadius:"3px",background:"#ffffff",padding:"0.5em"},menuItemStyle:{background:"none",borderRadius:"3px",color:"#333333",padding:"0.5em",fontSize:w?"0.9em":"0.8em",transition:"background 250ms, color 250ms"},menuItemHoverStyle:{background:"#f2f2f2"}}};!function(e){let t=[];function n(e,t,n,i){return[["M",e,t+2.5],["L",e+n,t+2.5],["M",e,t+i/2+.5],["L",e+n,t+i/2+.5],["M",e,t+i-1.5],["L",e+n,t+i-1.5]]}function i(e,t,n,i){let o=i/3-2,r=[];return r.concat(this.circle(n-o,t,o,o),this.circle(n-o,t+o+4,o,o),this.circle(n-o,t+2*(o+4),o,o))}e.compose=function(e){if(-1===t.indexOf(e)){t.push(e);let o=e.prototype.symbols;o.menu=n,o.menuball=i.bind(o)}}}(n||(n={}));let v=n,{composed:S}=r(),{addEvent:C,fireEvent:E,pushUnique:O}=r();function T(){this.fullscreen=new k(this)}class k{static compose(e){O(S,"Fullscreen")&&C(e,"beforeRender",T)}constructor(e){this.chart=e,this.isOpen=!1;let t=e.renderTo;!this.browserProps&&("function"==typeof t.requestFullscreen?this.browserProps={fullscreenChange:"fullscreenchange",requestFullscreen:"requestFullscreen",exitFullscreen:"exitFullscreen"}:t.mozRequestFullScreen?this.browserProps={fullscreenChange:"mozfullscreenchange",requestFullscreen:"mozRequestFullScreen",exitFullscreen:"mozCancelFullScreen"}:t.webkitRequestFullScreen?this.browserProps={fullscreenChange:"webkitfullscreenchange",requestFullscreen:"webkitRequestFullScreen",exitFullscreen:"webkitExitFullscreen"}:t.msRequestFullscreen&&(this.browserProps={fullscreenChange:"MSFullscreenChange",requestFullscreen:"msRequestFullscreen",exitFullscreen:"msExitFullscreen"}))}close(){let e=this,t=e.chart,n=t.options.chart;E(t,"fullscreenClose",null,function(){e.isOpen&&e.browserProps&&t.container.ownerDocument instanceof Document&&t.container.ownerDocument[e.browserProps.exitFullscreen](),e.unbindFullscreenEvent&&(e.unbindFullscreenEvent=e.unbindFullscreenEvent()),t.setSize(e.origWidth,e.origHeight,!1),e.origWidth=void 0,e.origHeight=void 0,n.width=e.origWidthOption,n.height=e.origHeightOption,e.origWidthOption=void 0,e.origHeightOption=void 0,e.isOpen=!1,e.setButtonText()})}open(){let e=this,t=e.chart,n=t.options.chart;E(t,"fullscreenOpen",null,function(){if(n&&(e.origWidthOption=n.width,e.origHeightOption=n.height),e.origWidth=t.chartWidth,e.origHeight=t.chartHeight,e.browserProps){let n=C(t.container.ownerDocument,e.browserProps.fullscreenChange,function(){e.isOpen?(e.isOpen=!1,e.close()):(t.setSize(null,null,!1),e.isOpen=!0,e.setButtonText())}),i=C(t,"destroy",n);e.unbindFullscreenEvent=()=>{n(),i()};let o=t.renderTo[e.browserProps.requestFullscreen]();o&&o.catch(function(){alert("Full screen is not supported inside a frame.")})}})}setButtonText(){let e=this.chart,t=e.exporting?.divElements,n=e.options.exporting,i=n&&n.buttons&&n.buttons.contextButton.menuItems,o=e.options.lang;if(n&&n.menuItemDefinitions&&o&&o.exitFullscreen&&o.viewFullscreen&&i&&t){let e=t[i.indexOf("viewFullscreen")];e&&l().setElementHTML(e,this.isOpen?o.exitFullscreen:n.menuItemDefinitions.viewFullscreen.text||o.viewFullscreen)}}toggle(){this.isOpen?this.close():this.open()}}let{win:F}=r(),{discardElement:R,objectEach:N}=r(),P={ajax:function(e){let t={json:"application/json",xml:"application/xml",text:"text/plain",octet:"application/octet-stream"},n=new XMLHttpRequest;function i(t,n){e.error&&e.error(t,n)}if(!e.url)return!1;n.open((e.type||"get").toUpperCase(),e.url,!0),e.headers?.["Content-Type"]||n.setRequestHeader("Content-Type",t[e.dataType||"json"]||t.text),N(e.headers,function(e,t){n.setRequestHeader(t,e)}),e.responseType&&(n.responseType=e.responseType),n.onreadystatechange=function(){let t;if(4===n.readyState){if(200===n.status){if("blob"!==e.responseType&&(t=n.responseText,"json"===e.dataType))try{t=JSON.parse(t)}catch(e){if(e instanceof Error)return i(n,e)}return e.success?.(t,n)}i(n,n.responseText)}},e.data&&"string"!=typeof e.data&&(e.data=JSON.stringify(e.data)),n.send(e.data)},getJSON:function(e,t){P.ajax({url:e,success:t,dataType:"json",headers:{"Content-Type":"text/plain"}})},post:async function(e,t,n){let i=new F.FormData;N(t,function(e,t){i.append(t,e)}),i.append("b64","true");let o=await F.fetch(e,{method:"POST",body:i,...n});if(o.ok){let e=await o.text(),n=document.createElement("a");n.href=`data:${t.type};base64,${e}`,n.download=t.filename,n.click(),R(n)}}},{defaultOptions:L,setOptions:M}=r(),{downloadURL:D,getScript:A}={dataURLtoBlob:x,downloadURL:function(e,t){let n=g.navigator,i=f.createElement("a");if("string"!=typeof e&&!(e instanceof String)&&n.msSaveOrOpenBlob)return void n.msSaveOrOpenBlob(e,t);if(e=""+e,n.userAgent.length>1e3)throw Error("Input too long");let o=/Edge\/\d+/.test(n.userAgent);if((u&&"string"==typeof e&&0===e.indexOf("data:application/pdf")||o||e.length>2e6)&&!(e=x(e)||""))throw Error("Failed to convert to blob");if(void 0!==i.download)i.href=e,i.download=t,f.body.appendChild(i),i.click(),f.body.removeChild(i);else try{if(!g.open(e,"chart"))throw Error("Failed to open window")}catch{g.location.href=e}},getScript:function(e){return new Promise((t,n)=>{let i=f.getElementsByTagName("head")[0],o=f.createElement("script");o.type="text/javascript",o.src=e,o.onload=()=>{t()},o.onerror=()=>{let t=`Error loading script ${e}`;m(t),n(Error(t))},i.appendChild(o)})}},{composed:U,doc:H,isFirefox:I,isMS:j,isSafari:B,SVG_NS:G,win:$}=r(),{addEvent:V,clearTimeout:W,createElement:q,css:z,discardElement:K,error:J,extend:_,find:X,fireEvent:Y,isObject:Z,merge:Q,objectEach:ee,pick:et,pushUnique:en,removeEvent:ei,splat:eo,uniqueKey:er}=r();l().allowedAttributes.push("data-z-index","fill-opacity","filter","preserveAspectRatio","rx","ry","stroke-dasharray","stroke-linejoin","stroke-opacity","text-anchor","transform","transform-origin","version","viewBox","visibility","xmlns","xmlns:xlink"),l().allowedTags.push("desc","clippath","fedropshadow","femorphology","g","image");let ea=$.URL||$.webkitURL||$;class el{constructor(e,t){this.options={},this.chart=e,this.options=t,this.btnCount=0,this.buttonOffset=0,this.divElements=[],this.svgElements=[]}static hyphenate(e){return e.replace(/[A-Z]/g,function(e){return"-"+e.toLowerCase()})}static async imageToDataURL(e,t,n){let i=await el.loadImage(e),o=H.createElement("canvas"),r=o?.getContext("2d");if(r)return o.height=i.height*t,o.width=i.width*t,r.drawImage(i,0,0,o.width,o.height),o.toDataURL(n);throw Error("No canvas found!")}static async fetchCSS(e){let t=await fetch(e).then(e=>e.text()),n=new CSSStyleSheet;return n.replaceSync(t),n}static async handleStyleSheet(e,t){try{for(let n of Array.from(e.cssRules)){if(n instanceof CSSImportRule){let e=await el.fetchCSS(n.href);await el.handleStyleSheet(e,t)}if(n instanceof CSSFontFaceRule){let i=n.cssText;if(e.href){let t=e.href,n=/url\(\s*(['"]?)(?![a-z]+:|\/\/)([^'")]+?)\1\s*\)/gi;i=i.replace(n,(e,n,i)=>{let o=new URL(i,t).href;return`url(${n}${o}${n})`})}t.push(i)}}}catch{if(e.href){let n=await el.fetchCSS(e.href);await el.handleStyleSheet(n,t)}}}static async fetchStyleSheets(){let e=[];for(let t of Array.from(H.styleSheets))await el.handleStyleSheet(t,e);return e}static async inlineFonts(e){let t=await el.fetchStyleSheets(),n=/url\(([^)]+)\)/g,i=[],o=t.join("\n"),r;for(;r=n.exec(o);){let e=r[1].replace(/['"]/g,"");i.includes(e)||i.push(e)}let a=e=>{let t="",n=new Uint8Array(e);for(let e=0;e<n.byteLength;e++)t+=String.fromCharCode(n[e]);return btoa(t)},l={};for(let e of i)try{let t=await fetch(e),n=t.headers.get("Content-Type")||"",i=a(await t.arrayBuffer());l[e]=`data:${n};base64,${i}`}catch{}o=o.replace(n,(e,t)=>{let n=t.replace(/['"]/g,"");return`url(${l[n]||n})`});let s=document.createElementNS("http://www.w3.org/2000/svg","style");return s.textContent=o,e.append(s),e}static loadImage(e){return new Promise((t,n)=>{let i=new $.Image;i.crossOrigin="Anonymous",i.onload=()=>{setTimeout(()=>{t(i)},el.loadEventDeferDelay)},i.onerror=e=>{n(e)},i.src=e})}static prepareImageOptions(e){let t=e?.type||"image/png",n=e?.libURL||L.exporting?.libURL;return{type:t,filename:(e?.filename||"chart")+"."+("image/svg+xml"===t?"svg":t.split("/")[1]),scale:e?.scale||1,libURL:n?.slice(-1)!=="/"?n+"/":n}}static sanitizeSVG(e,t){let n=e.indexOf("</svg>")+6,i=e.indexOf("<foreignObject")>-1,o=e.substr(n);return e=e.substr(0,n),i?e=e.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />"):o&&t?.exporting?.allowHTML&&(o='<foreignObject x="0" y="0" width="'+t.chart.width+'" height="'+t.chart.height+'"><body xmlns="http://www.w3.org/1999/xhtml">'+o.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />")+"</body></foreignObject>",e=e.replace("</svg>",o+"</svg>")),e=e.replace(/zIndex="[^"]+"/g,"").replace(/symbolName="[^"]+"/g,"").replace(/jQuery\d+="[^"]+"/g,"").replace(/url\(("|&quot;)(.*?)("|&quot;)\;?\)/g,"url($2)").replace(/url\([^#]+#/g,"url(#").replace(/<svg /,'<svg xmlns:xlink="http://www.w3.org/1999/xlink" ').replace(/ (NS\d+\:)?href=/g," xlink:href=").replace(/\n+/g," ").replace(/&nbsp;/g,"\xa0").replace(/&shy;/g,"\xad")}static svgToDataURL(e){let t=$.navigator.userAgent,n=t.indexOf("WebKit")>-1&&0>t.indexOf("Chrome");try{if(!n&&-1===e.indexOf("<foreignObject"))return ea.createObjectURL(new $.Blob([e],{type:"image/svg+xml;charset-utf-16"}))}catch{}return"data:image/svg+xml;charset=UTF-8,"+encodeURIComponent(e)}addButton(e){let t,n=this,i=n.chart,o=i.renderer,r=Q(i.options.navigation?.buttonOptions,e),a=r.onclick,l=r.menuItems,s=r.symbolSize||12;if(!1===r.enabled||!r.theme)return;let c=i.styledMode?{}:r.theme,h=()=>{};a?h=function(e){e&&e.stopPropagation(),a.call(i,e)}:l&&(h=function(e){e&&e.stopPropagation(),n.contextMenu(p.menuClassName,l,p.translateX||0,p.translateY||0,p.width||0,p.height||0,p),p.setState(2)}),r.text&&r.symbol?c.paddingLeft=et(c.paddingLeft,30):r.text||_(c,{width:r.width,height:r.height,padding:0});let p=o.button(r.text||"",0,0,h,c,void 0,void 0,void 0,void 0,r.useHTML).addClass(e.className||"").attr({title:et(i.options.lang[r._titleKey||r.titleKey],"")});p.menuClassName=e.menuClassName||"highcharts-menu-"+n.btnCount++,r.symbol&&(t=o.symbol(r.symbol,Math.round((r.symbolX||0)-s/2),Math.round((r.symbolY||0)-s/2),s,s,{width:s,height:s}).addClass("highcharts-button-symbol").attr({zIndex:1}).add(p),i.styledMode||t.attr({stroke:r.symbolStroke,fill:r.symbolFill,"stroke-width":r.symbolStrokeWidth||1})),p.add(n.group).align(_(r,{width:p.width,x:et(r.x,n.buttonOffset)}),!0,"spacingBox"),n.buttonOffset+=((p.width||0)+(r.buttonSpacing||0))*("right"===r.align?-1:1),n.svgElements.push(p,t)}afterPrint(){let e=this.chart;if(!this.printReverseInfo)return;let{childNodes:t,origDisplay:n,resetParams:i}=this.printReverseInfo;this.moveContainers(e.renderTo),[].forEach.call(t,function(e,t){1===e.nodeType&&(e.style.display=n[t]||"")}),this.isPrinting=!1,i&&e.setSize.apply(e,i),delete this.printReverseInfo,el.printingChart=void 0,Y(e,"afterPrint")}beforePrint(){let e=this.chart,t=H.body,n=this.options.printMaxWidth,i={childNodes:t.childNodes,origDisplay:[],resetParams:void 0};this.isPrinting=!0,e.pointer?.reset(void 0,0),Y(e,"beforePrint"),n&&e.chartWidth>n&&(i.resetParams=[e.options.chart.width,void 0,!1],e.setSize(n,void 0,!1)),[].forEach.call(i.childNodes,function(e,t){1===e.nodeType&&(i.origDisplay[t]=e.style.display,e.style.display="none")}),this.moveContainers(t),this.printReverseInfo=i}contextMenu(e,t,n,i,o,r,a){let s=this,c=s.chart,h=c.options.navigation,p=c.chartWidth,d=c.chartHeight,u="cache-"+e,g=Math.max(o,r),f,m=c[u];m||(s.contextMenuEl=c[u]=m=q("div",{className:e},{position:"absolute",zIndex:1e3,padding:g+"px",pointerEvents:"auto",...c.renderer.style},c.scrollablePlotArea?.fixedDiv||c.container),f=q("ul",{className:"highcharts-menu"},c.styledMode?{}:{listStyle:"none",margin:0,padding:0},m),c.styledMode||z(f,_({MozBoxShadow:"3px 3px 10px #0008",WebkitBoxShadow:"3px 3px 10px #0008",boxShadow:"3px 3px 10px #0008"},h?.menuStyle||{})),m.hideMenu=function(){z(m,{display:"none"}),a&&a.setState(0),c.exporting&&(c.exporting.openMenu=!1),z(c.renderTo,{overflow:"hidden"}),z(c.container,{overflow:"hidden"}),W(m.hideTimer),Y(c,"exportMenuHidden")},s.events?.push(V(m,"mouseleave",function(){m.hideTimer=$.setTimeout(m.hideMenu,500)}),V(m,"mouseenter",function(){W(m.hideTimer)}),V(H,"mouseup",function(t){c.pointer?.inClass(t.target,e)||m.hideMenu()}),V(m,"click",function(){c.exporting?.openMenu&&m.hideMenu()})),t.forEach(function(e){if("string"==typeof e&&s.options.menuItemDefinitions?.[e]&&(e=s.options.menuItemDefinitions[e]),Z(e,!0)){let t;e.separator?t=q("hr",void 0,void 0,f):("viewData"===e.textKey&&s.isDataTableVisible&&(e.textKey="hideData"),t=q("li",{className:"highcharts-menu-item",onclick:function(t){t&&t.stopPropagation(),m.hideMenu(),"string"!=typeof e&&e.onclick&&e.onclick.apply(c,arguments)}},void 0,f),l().setElementHTML(t,e.text||c.options.lang[e.textKey]),c.styledMode||(t.onmouseover=function(){z(this,h?.menuItemHoverStyle||{})},t.onmouseout=function(){z(this,h?.menuItemStyle||{})},z(t,_({cursor:"pointer"},h?.menuItemStyle||{})))),s.divElements.push(t)}}),s.divElements.push(f,m),s.menuHeight=m.offsetHeight,s.menuWidth=m.offsetWidth);let y={display:"block"};n+(s.menuWidth||0)>p?y.right=p-n-o-g+"px":y.left=n-g+"px",i+r+(s.menuHeight||0)>d&&a.alignOptions?.verticalAlign!=="top"?y.bottom=d-i-g+"px":y.top=i+r-g+"px",z(m,y),z(c.renderTo,{overflow:""}),z(c.container,{overflow:""}),c.exporting&&(c.exporting.openMenu=!0),Y(c,"exportMenuShown")}destroy(e){let t,n=e?e.target:this.chart,{divElements:i,events:o,svgElements:r}=this;r.forEach((e,i)=>{e&&(e.onclick=e.ontouchstart=null,n[t="cache-"+e.menuClassName]&&delete n[t],r[i]=e.destroy())}),r.length=0,this.group&&(this.group.destroy(),delete this.group),i.forEach(function(e,t){e&&(W(e.hideTimer),ei(e,"mouseleave"),i[t]=e.onmouseout=e.onmouseover=e.ontouchstart=e.onclick=null,K(e))}),i.length=0,o&&(o.forEach(function(e){e()}),o.length=0)}async downloadSVG(e,t){let n,i={svg:e,exportingOptions:t,exporting:this};if(Y(el.prototype,"downloadSVG",i),i.defaultPrevented)return;let{type:o,filename:r,scale:a,libURL:l}=el.prepareImageOptions(t);if("application/pdf"===o)throw Error("Offline exporting logic for PDF type is not found.");if("image/svg+xml"===o){if(void 0!==$.MSBlobBuilder){let t=new $.MSBlobBuilder;t.append(e),n=t.getBlob("image/svg+xml")}else n=el.svgToDataURL(e);D(n,r)}else{n=el.svgToDataURL(e);try{el.objectURLRevoke=!0;let e=await el.imageToDataURL(n,a,o);D(e,r)}catch(c){if("No canvas found!"===c.message)throw c;if(e.length>1e8)throw Error("Input too long");let t=H.createElement("canvas"),n=t.getContext("2d"),i=e.match(/^<svg[^>]*\s{,1000}width\s{,1000}=\s{,1000}\"?(\d+)\"?[^>]*>/),s=e.match(/^<svg[^>]*\s{0,1000}height\s{,1000}=\s{,1000}\"?(\d+)\"?[^>]*>/);if(n&&i&&s){let c=i[1]*a,h=s[1]*a;t.width=c,t.height=h,$.canvg||(el.objectURLRevoke=!0,await A(l+"canvg.js")),$.canvg.Canvg.fromString(n,e).start(),D($.navigator.msSaveOrOpenBlob?t.msToBlob():t.toDataURL(o),r)}}finally{if(el.objectURLRevoke)try{ea.revokeObjectURL(n)}catch{}}}}async exportChart(e,t){if((e=Q(this.options,e)).local)await this.localExport(e,t||{});else{let n=this.getSVGForExport(e,t);e.url&&await P.post(e.url,{filename:e.filename?e.filename.replace(/\//g,"-"):this.getFilename(),type:e.type,width:e.width,scale:e.scale,svg:n},e.fetchOptions)}}async fallbackToServer(e,t){!1===e.fallbackToExportServer?e.error?e.error(e,t):J(28,!0):"application/pdf"===e.type&&(e.local=!1,await this.exportChart(e))}getChartHTML(e){let t=this.chart;return e&&this.inlineStyles(),this.resolveCSSVariables(),t.container.innerHTML}getFilename(){let e=this.chart.userOptions.title?.text,t=this.options.filename;return t?t.replace(/\//g,"-"):("string"==typeof e&&(t=e.toLowerCase().replace(/<\/?[^>]+(>|$)/g,"").replace(/[\s_]+/g,"-").replace(/[^a-z\d\-]/g,"").replace(/^[\-]+/g,"").replace(/[\-]+/g,"-").substr(0,24).replace(/[\-]+$/g,"")),(!t||t.length<5)&&(t="chart"),t)}getSVG(e){let t=this.chart,n,i,o=Q(t.options,e);o.plotOptions=Q(t.userOptions.plotOptions,e?.plotOptions),o.time=Q(t.userOptions.time,e?.time);let r=q("div",void 0,{position:"absolute",top:"-9999em",width:t.chartWidth+"px",height:t.chartHeight+"px"},H.body),a=t.renderTo.style.width,l=t.renderTo.style.height,s=o.exporting?.sourceWidth||o.chart.width||/px$/.test(a)&&parseInt(a,10)||(o.isGantt?800:600),c=o.exporting?.sourceHeight||o.chart.height||/px$/.test(l)&&parseInt(l,10)||400;_(o.chart,{animation:!1,renderTo:r,forExport:!0,renderer:"SVGRenderer",width:s,height:c}),o.exporting&&(o.exporting.enabled=!1),delete o.data,o.series=[],t.series.forEach(function(e){(i=Q(e.userOptions,{animation:!1,enableMouseTracking:!1,showCheckbox:!1,visible:e.visible})).isInternal||o?.series?.push(i)});let h={};t.axes.forEach(function(e){e.userOptions.internalKey||(e.userOptions.internalKey=er()),o&&!e.options.isInternal&&(h[e.coll]||(h[e.coll]=!0,o[e.coll]=[]),o[e.coll].push(Q(e.userOptions,{visible:e.visible,type:e.type,uniqueNames:e.uniqueNames})))}),o.colorAxis=t.userOptions.colorAxis;let p=new t.constructor(o,t.callback);return e&&["xAxis","yAxis","series"].forEach(function(t){e[t]&&p.update({[t]:e[t]})}),t.axes.forEach(function(t){let n=X(p.axes,e=>e.options.internalKey===t.userOptions.internalKey);if(n){let i=t.getExtremes(),o=eo(e?.[t.coll]||{})[0],r="min"in o?o.min:i.userMin,a="max"in o?o.max:i.userMax;(void 0!==r&&r!==n.min||void 0!==a&&a!==n.max)&&n.setExtremes(r??void 0,a??void 0,!0,!1)}}),n=p.exporting?.getChartHTML(t.styledMode||o.exporting?.applyStyleSheets)||"",Y(t,"getSVG",{chartCopy:p}),n=el.sanitizeSVG(n,o),o=void 0,p.destroy(),K(r),n}getSVGForExport(e,t){let n=this.options;return this.getSVG(Q({chart:{borderRadius:0}},n.chartOptions,t,{exporting:{sourceWidth:e?.sourceWidth||n.sourceWidth,sourceHeight:e?.sourceHeight||n.sourceHeight}}))}inlineStyles(){let e,t=el.inlineDenylist,n=el.inlineAllowlist,i={},o=q("iframe",void 0,{width:"1px",height:"1px",visibility:"hidden"},H.body),r=o.contentWindow?.document;r&&r.body.appendChild(r.createElementNS(G,"svg")),!function o(a){let l,s,c,h,p,d,u={};if(r&&1===a.nodeType&&-1===el.unstyledElements.indexOf(a.nodeName)){if(l=$.getComputedStyle(a,null),s="svg"===a.nodeName?{}:$.getComputedStyle(a.parentNode,null),!i[a.nodeName]){e=r.getElementsByTagName("svg")[0],c=r.createElementNS(a.namespaceURI,a.nodeName),e.appendChild(c);let t=$.getComputedStyle(c,null),n={};for(let e in t)e.length<1e3&&"string"==typeof t[e]&&!/^\d+$/.test(e)&&(n[e]=t[e]);i[a.nodeName]=n,"text"===a.nodeName&&delete i.text.fill,e.removeChild(c)}for(let e in l)(I||j||B||Object.hasOwnProperty.call(l,e))&&function(e,o){if(h=p=!1,n.length){for(d=n.length;d--&&!p;)p=n[d].test(o);h=!p}for("transform"===o&&"none"===e&&(h=!0),d=t.length;d--&&!h;){if(o.length>1e3)throw Error("Input too long");h=t[d].test(o)||"function"==typeof e}!h&&(s[o]!==e||"svg"===a.nodeName)&&i[a.nodeName][o]!==e&&(el.inlineToAttributes&&-1===el.inlineToAttributes.indexOf(o)?u[o]=e:e&&a.setAttribute(el.hyphenate(o),e))}(l[e],e);if(z(a,u),"svg"===a.nodeName&&a.setAttribute("stroke-width","1px"),"text"===a.nodeName)return;[].forEach.call(a.children||a.childNodes,o)}}(this.chart.container.querySelector("svg")),e.parentNode.removeChild(e),o.parentNode.removeChild(o)}async localExport(e,t){let n=this.chart,i,o,r=null,a;if(j&&n.styledMode&&!el.inlineAllowlist.length&&el.inlineAllowlist.push(/^blockSize/,/^border/,/^caretColor/,/^color/,/^columnRule/,/^columnRuleColor/,/^cssFloat/,/^cursor/,/^fill$/,/^fillOpacity/,/^font/,/^inlineSize/,/^length/,/^lineHeight/,/^opacity/,/^outline/,/^parentRule/,/^rx$/,/^ry$/,/^stroke/,/^textAlign/,/^textAnchor/,/^textDecoration/,/^transform/,/^vectorEffect/,/^visibility/,/^x$/,/^y$/),j&&("application/pdf"===e.type||n.container.getElementsByTagName("image").length&&"image/svg+xml"!==e.type)||"application/pdf"===e.type&&[].some.call(n.container.getElementsByTagName("image"),function(e){let t=e.getAttribute("href");return""!==t&&"string"==typeof t&&0!==t.indexOf("data:")}))return void await this.fallbackToServer(e,Error("Image type not supported for this chart/browser."));let l=V(n,"getSVG",e=>{o=e.chartCopy.options,a=(i=e.chartCopy.container.cloneNode(!0))&&i.getElementsByTagName("image")||[]});try{let n;for(let n of(this.getSVGForExport(e,t),a?Array.from(a):[]))if(r=n.getAttributeNS("http://www.w3.org/1999/xlink","href")){el.objectURLRevoke=!1;let t=await el.imageToDataURL(r,e?.scale||1,e?.type||"image/png");n.setAttributeNS("http://www.w3.org/1999/xlink","href",t)}else n.parentNode.removeChild(n);let l=i?.querySelector("svg");l&&!e.chartOptions?.chart?.style?.fontFamily&&await el.inlineFonts(l);let s=(n=i?.innerHTML,el.sanitizeSVG(n||"",o));if(s.indexOf("<foreignObject")>-1&&"image/svg+xml"!==e.type&&(j||"application/pdf"===e.type))throw Error("Image type not supported for charts with embedded HTML");return await this.downloadSVG(s,_({filename:this.getFilename()},e)),s}catch(t){await this.fallbackToServer(e,t)}finally{l()}}moveContainers(e){let t=this.chart,{scrollablePlotArea:n}=t;(n?[n.fixedDiv,n.scrollingContainer]:[t.container]).forEach(function(t){e.appendChild(t)})}print(){let e=this.chart;this.isPrinting||(el.printingChart=e,B||this.beforePrint(),setTimeout(()=>{$.focus(),$.print(),B||setTimeout(()=>{e.exporting?.afterPrint()},1e3)},1))}render(){let e=this,{chart:t,options:n}=e,i=e?.isDirty||!e?.svgElements.length;e.buttonOffset=0,e.isDirty&&e.destroy(),i&&!1!==n.enabled&&(e.events=[],e.group||(e.group=t.renderer.g("exporting-group").attr({zIndex:3}).add()),ee(n?.buttons,function(t){e.addButton(t)}),e.isDirty=!1)}resolveCSSVariables(){Array.from(this.chart.container.querySelectorAll("*")).forEach(e=>{["color","fill","stop-color","stroke"].forEach(t=>{let n=e.getAttribute(t);n?.includes("var(")&&e.setAttribute(t,getComputedStyle(e).getPropertyValue(t));let i=e.style?.[t];i?.includes("var(")&&(e.style[t]=getComputedStyle(e).getPropertyValue(t))})})}update(e,t){this.isDirty=!0,Q(!0,this.options,e),et(t,!0)&&this.chart.redraw()}}el.inlineAllowlist=[],el.inlineDenylist=[/-/,/^(clipPath|cssText|d|height|width)$/,/^font$/,/[lL]ogical(Width|Height)$/,/^parentRule$/,/^(cssRules|ownerRules)$/,/perspective/,/TapHighlightColor/,/^transition/,/^length$/,/^\d+$/],el.inlineToAttributes=["fill","stroke","strokeLinecap","strokeLinejoin","strokeWidth","textAnchor","x","y"],el.loadEventDeferDelay=150*!!j,el.unstyledElements=["clipPath","defs","desc"],function(e){function t(e){let t=e.exporting;t&&(t.render(),V(e,"redraw",function(){this.exporting?.render()}),V(e,"destroy",function(){this.exporting?.destroy()}))}function n(){let t=this;t.options.exporting&&(t.exporting=new e(t,t.options.exporting),d.compose(t).navigation.addUpdate((e,n)=>{t.exporting&&(t.exporting.isDirty=!0,Q(!0,t.options.navigation,e),et(n,!0)&&t.redraw())}))}function i({alignTo:e,key:t,textPxLength:n}){let i=this.options.exporting,{align:o,buttonSpacing:r=0,verticalAlign:a,width:l=0}=Q(this.options.navigation?.buttonOptions,i?.buttons?.contextButton),s=e.width-n,c=l+r;(i?.enabled??!0)&&"title"===t&&"right"===o&&"top"===a&&s<2*c&&(s<c?e.width-=c:this.title?.alignValue!=="left"&&(e.x-=c-s/2))}e.compose=function(o,r){v.compose(r),k.compose(o),en(U,"Exporting")&&(_(c().prototype,{exportChart:async function(e,t){await this.exporting?.exportChart(e,t)},getChartHTML:function(e){return this.exporting?.getChartHTML(e)},getFilename:function(){return this.exporting?.getFilename()},getSVG:function(e){return this.exporting?.getSVG(e)},print:function(){return this.exporting?.print()}}),o.prototype.callbacks.push(t),V(o,"afterInit",n),V(o,"layOutTitle",i),B&&$.matchMedia("print").addListener(function(t){e.printingChart&&(t.matches?e.printingChart.exporting?.beforePrint():e.printingChart.exporting?.afterPrint())}),M(b))}}(el||(el={}));let es=el,ec=r();ec.Exporting=es,ec.HttpUtilities=ec.HttpUtilities||P,ec.ajax=ec.HttpUtilities.ajax,ec.getJSON=ec.HttpUtilities.getJSON,ec.post=ec.HttpUtilities.post,es.compose(ec.Chart,ec.Renderer);let eh=r();export{eh as default};