// src/forms/FormCheckbox.tsx
import { Controller } from "react-hook-form";
import { Checkbox, FormControlLabel } from "@mui/material";
import { jsx } from "react/jsx-runtime";
var FormCheckbox = ({ className, control, disabled, id, handleClick, style, label, required }) => /* @__PURE__ */ jsx(
  Controller,
  {
    name: id,
    rules: { required },
    control,
    render: ({ field: { value = false, onChange } }) => /* @__PURE__ */ jsx(
      FormControlLabel,
      {
        className,
        control: /* @__PURE__ */ jsx(Checkbox, { name: id, onClick: handleClick, disabled, checked: value, style, color: "primary", onChange: () => onChange(!value) }),
        label
      }
    )
  }
);
var FormCheckbox_default = FormCheckbox;

export {
  FormCheckbox,
  FormCheckbox_default
};
//# sourceMappingURL=chunk-H66VYEIO.js.map