import { DBusSubsystem } from './DBusSubsystem.cjs';
import { LogSubsystem } from './LogSubsystem.cjs';
import { ServiceSubsystem } from './ServiceSubsystem.cjs';

/**
 * Monitor configuration data.
 */
type MonitorConfiguration = {
    name: string;
    status: string;
    type: MonitorConfiguration.type;
} & (LogSubsystem | ServiceSubsystem | DBusSubsystem);
declare namespace MonitorConfiguration {
    enum type {
        LOG = "log",
        SERVICE = "service",
        DBUS = "dbus"
    }
}

export { MonitorConfiguration };
