// src/SharedSnackbar.tsx
import { memo } from "react";
import { Snackbar } from "@mui/material";
import copy from "copy-to-clipboard";
import { jsx } from "react/jsx-runtime";
var SharedSnackbar = ({ setSnackbar, snackbar }) => {
  const handleActionClick = () => {
    copy(snackbar.message);
    setSnackbar("Copied to clipboard");
  };
  const onCloseSnackbar = (_, reason) => {
    const { onClose = false } = snackbar;
    if (onClose && reason === "clickaway") {
      return;
    }
    setSnackbar("");
  };
  const { preventClickToCopy, ...snackProps } = snackbar;
  return /* @__PURE__ */ jsx(
    Snackbar,
    {
      ...snackProps,
      anchorOrigin: { vertical: "bottom", horizontal: "center" },
      style: { maxWidth: 900, height: "auto", lineHeight: "28px", padding: 24, whiteSpace: "pre-line" },
      onClick: preventClickToCopy ? void 0 : handleActionClick,
      onClose: onCloseSnackbar
    }
  );
};
var areEqual = (prevProps, nextProps) => {
  if (prevProps.snackbar.open != nextProps.snackbar.open || prevProps.snackbar.message != nextProps.snackbar.message) {
    return false;
  }
  return prevProps.snackbar.children != nextProps.snackbar.children;
};
var SharedSnackbar_default = memo(SharedSnackbar, areEqual);

export {
  SharedSnackbar,
  SharedSnackbar_default
};
//# sourceMappingURL=chunk-7KQBAHCQ.js.map