dashboardApp.directive('fileChangesWidget', ['fileChangesWidgetHelper', '$q', function (fileChangesWidgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/file_changes_widget',
        restrict: 'A',
        scope: {
            widget: '=',
            currentUser: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',

        },
        link: function (scope, element) {
            scope.refresh = function () {
                return element.attr('refresh');
            };

            scope.$watch('refresh', function () {
                scope.convertData = function (data) {
                    let result = [];
                    Object.keys(data.labels).forEach(function (key) {
                        result.push({name: data.labels[key], 'data': Object.values(data.data[key])});
                    })
                    return result;
                };

                fileChangesWidgetHelper.getFileChangeStats({"changeDays": 6}).then(
                    function (result) {
                        fileChangesWidgetHelper.setChartData(scope.convertData(result.data), result.data.dates);
                        scope.widget.changeStats = result.data.data;
                        scope.chartList = fileChangesWidgetHelper.chartConfig;
                    }
                );
            });
        }
    };

}]);
