"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/List.tsx
var List_exports = {};
__export(List_exports, {
  CommonList: () => CommonList,
  calculateResizeChange: () => calculateResizeChange,
  minCellWidth: () => minCellWidth
});
module.exports = __toCommonJS(List_exports);
var import_react3 = require("react");
var import_icons_material2 = require("@mui/icons-material");
var import_material3 = require("@mui/material");
var import_mui2 = require("tss-react/mui");
var import_constants2 = require("@northern.tech/store/constants");
var import_utils = require("@northern.tech/store/utils");
var import_helpers2 = require("@northern.tech/utils/helpers");
var import_resizehook = require("@northern.tech/utils/resizehook");

// src/Loader.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Loader = (props) => {
  const { fade, show, small, style, table, waiting } = props;
  const hideClass = fade ? "hidden" : "loaderContainer shrunk";
  const showClass = table ? "miniLoaderContainer" : "loaderContainer";
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { style, className: show ? showClass : hideClass, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `${small ? "small" : ""} ${waiting ? "waiting-loader" : ""} loader`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_1" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_2" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_3" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_4" })
  ] }) });
};
var Loader_default = Loader;

// src/Pagination.tsx
var import_react2 = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_constants = require("@northern.tech/store/constants");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// src/helptips/MenderTooltip.tsx
var import_react = require("react");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime2 = require("react/jsx-runtime");
var MenderTooltip = (0, import_mui.withStyles)(import_material.Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltip_default = MenderTooltip;

// src/Pagination.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var defaultRowsPerPageOptions = [10, 20, import_constants.DEVICE_LIST_MAXIMUM_LENGTH];
var { perPage: defaultPerPage } = import_constants.DEVICE_LIST_DEFAULTS;
var paginationIndex = 1;
var paginationLimit = 1e4;
var MaybeWrapper = ({ children, disabled }) => disabled ? /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(MenderTooltip_default, { arrow: true, placement: "top", title: "Please refine your filter criteria first in order to proceed.", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { children }) }) : /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { children });
var TablePaginationActions = ({ count, page = 0, onPageChange, rowsPerPage = defaultPerPage, showCountInfo = true }) => {
  const [pageNo, setPageNo] = (0, import_react2.useState)(page + paginationIndex);
  (0, import_react2.useEffect)(() => {
    setPageNo(page + paginationIndex);
  }, [page, rowsPerPage, count]);
  const debouncedPage = (0, import_debouncehook.useDebounce)(pageNo, import_constants.TIMEOUTS.debounceShort);
  (0, import_react2.useEffect)(() => {
    const newPage = Math.min(Math.max(paginationIndex, debouncedPage), Math.max(paginationIndex, Math.ceil(count / rowsPerPage)));
    if (newPage !== page + paginationIndex) {
      onPageChange(newPage);
    }
  }, [count, debouncedPage, onPageChange, page, rowsPerPage]);
  const pages = Math.ceil(count / rowsPerPage);
  const isAtPaginationLimit = pageNo >= paginationLimit / rowsPerPage;
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: "flexbox center-aligned", children: [
    showCountInfo && /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { children: `${(pageNo - paginationIndex) * rowsPerPage + 1}-${Math.min(pageNo * rowsPerPage, count)} of ${count}` }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.IconButton, { onClick: () => setPageNo(pageNo - 1), disabled: pageNo === paginationIndex, size: "large", "aria-label": "prev", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_icons_material.KeyboardArrowLeft, {}) }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(MaybeWrapper, { disabled: isAtPaginationLimit, children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material2.IconButton, { onClick: () => setPageNo(pageNo + 1), disabled: pageNo >= pages || isAtPaginationLimit, size: "large", "aria-label": "next", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_icons_material.KeyboardArrowRight, {}) }) })
  ] });
};
var Pagination = (props) => {
  const { className, onChangeRowsPerPage, onChangePage, page = 0, rowsPerPageOptions = defaultRowsPerPageOptions, showCountInfo, ...remainingProps } = props;
  const propsPage = Math.max(page - paginationIndex, 0);
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    import_material2.TablePagination,
    {
      className: `flexbox margin-top ${className || ""}`,
      classes: { spacer: "flexbox no-basis" },
      component: "div",
      labelDisplayedRows: () => "",
      labelRowsPerPage: "Rows",
      slotProps: { select: { name: "pagination" } },
      rowsPerPageOptions,
      onRowsPerPageChange: (e) => onChangeRowsPerPage(e.target.value),
      page: propsPage,
      onPageChange: onChangePage,
      ActionsComponent: (actionProps) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(TablePaginationActions, { ...actionProps, showCountInfo }),
      ...remainingProps
    }
  );
};
var areEqual = (prevProps, nextProps) => Math.floor(prevProps.count / prevProps.rowsPerPage) === Math.floor(nextProps.count / nextProps.rowsPerPage) && prevProps.page === nextProps.page && prevProps.rowsPerPage === nextProps.rowsPerPage && prevProps.disabled === nextProps.disabled;
var Pagination_default = (0, import_react2.memo)(Pagination, areEqual);

// src/List.tsx
var import_jsx_runtime4 = require("react/jsx-runtime");
var { page: defaultPage, perPage: defaultPerPage2 } = import_constants2.DEVICE_LIST_DEFAULTS;
var useStyles = (0, import_mui2.makeStyles)()((theme) => ({
  header: {
    // @ts-ignore
    color: theme.palette.text.hint
  },
  resizer: {
    cursor: "col-resize",
    paddingLeft: 5,
    paddingRight: 5
  },
  resizeHandle: {
    width: 4,
    background: "initial",
    ["&.hovering"]: {
      background: theme.palette.grey[600]
    },
    ["&.resizing"]: {
      background: (0, import_utils.isDarkMode)(theme.palette.mode) ? theme.palette.grey[200] : theme.palette.grey[900]
    }
  }
}));
var minCellWidth = 150;
var calculateResizeChange = ({ columnElements, columnHeaders, e, index, prev, selectable }) => {
  const isShrinkage = prev > e.clientX ? -1 : 1;
  const columnDelta = Math.abs(e.clientX - prev) * isShrinkage;
  const relevantColumns = getRelevantColumns(columnElements, selectable);
  const canModifyNextColumn = index + 1 < columnHeaders.length - 1;
  return relevantColumns.reduce((accu, element, columnIndex) => {
    const currentWidth = element.offsetWidth;
    const column = { attribute: columnHeaders[columnIndex + 1].attribute, size: currentWidth };
    if (canModifyNextColumn && index === columnIndex) {
      column.size = currentWidth + columnDelta;
    } else if (canModifyNextColumn && index + 1 === columnIndex) {
      column.size = currentWidth - columnDelta;
    }
    accu.push(column);
    return accu;
  }, []);
};
var getRelevantColumns = (columnElements, selectable) => [...columnElements].slice(selectable ? 1 : 0, columnElements.length - 1);
var getTemplateColumns = (columns, selectable) => selectable ? `52px ${columns} minmax(${minCellWidth}px, 1fr)` : `${columns} minmax(${minCellWidth}px, 1fr)`;
var getColumnsStyle = (columns, defaultSize, selectable) => {
  const template = columns.map(({ size }) => `minmax(${minCellWidth}px, ${size ? `${size}px` : defaultSize})`);
  return getTemplateColumns(template.join(" "), selectable);
};
var CommonList = (props) => {
  const {
    columnHeaders,
    customColumnSizes = [],
    listItems,
    listState,
    idAttribute,
    onChangeRowsPerPage,
    PaginationProps = {},
    onExpandClick,
    onResizeColumns,
    onPageChange,
    onSelect,
    onSort = () => {
    },
    pageLoading,
    sortingNotes,
    ListItemComponent
  } = props;
  const { page: pageNo = defaultPage, perPage: pageLength = defaultPerPage2, selection: selectedRows = [], sort = {}, total: pageTotal = 1 } = listState;
  const { direction: sortDown = import_constants2.SORTING_OPTIONS.desc, key: sortCol } = sort;
  const listRef = (0, import_react3.useRef)(null);
  const selectedRowsRef = (0, import_react3.useRef)(selectedRows);
  const initRef = (0, import_react3.useRef)(null);
  const [resizeTrigger, setResizeTrigger] = (0, import_react3.useState)(false);
  const size = (0, import_resizehook.useWindowSize)();
  const selectable = !!onSelect;
  const { classes } = useStyles();
  (0, import_react3.useEffect)(() => {
    selectedRowsRef.current = selectedRows;
  }, [selectedRows]);
  (0, import_react3.useEffect)(() => {
    if (!listRef.current) {
      return;
    }
    const relevantColumns = getRelevantColumns(listRef.current?.querySelector(".deviceListRow")?.children, selectable);
    listRef.current.style.gridTemplateColumns = getColumnsStyle(
      customColumnSizes.length && customColumnSizes.length === relevantColumns.length ? customColumnSizes : relevantColumns,
      "1.5fr",
      selectable
    );
  }, [customColumnSizes, columnHeaders, selectable, resizeTrigger, size.width]);
  (0, import_react3.useEffect)(() => {
    clearTimeout(initRef.current || void 0);
    initRef.current = setTimeout(() => setResizeTrigger(import_helpers2.toggle), import_constants2.TIMEOUTS.debounceDefault);
    return () => {
      clearTimeout(initRef?.current || void 0);
    };
  }, [customColumnSizes.length]);
  const onRowSelection = (selectedRow) => {
    const updatedSelection = [...selectedRowsRef.current];
    const selectedIndex = updatedSelection.indexOf(selectedRow);
    if (selectedIndex === -1) {
      updatedSelection.push(selectedRow);
    } else {
      updatedSelection.splice(selectedIndex, 1);
    }
    if (onSelect) {
      onSelect(updatedSelection);
    }
  };
  const onSelectAllClick = () => {
    let newSelectedRows = Array.from({ length: listItems.length }, (_, i) => i);
    if (selectedRows.length && selectedRows.length <= listItems.length) {
      newSelectedRows = [];
    }
    if (onSelect) {
      onSelect(newSelectedRows);
    }
  };
  const handleResizeChange = (0, import_react3.useCallback)(
    (e, { index, prev, ref }) => {
      const changedColumns = calculateResizeChange({
        columnElements: [...ref.current.parentElement.children],
        columnHeaders,
        e,
        index,
        prev,
        selectable
      });
      if (listRef.current) listRef.current.style.gridTemplateColumns = getColumnsStyle(changedColumns, void 0, selectable);
    },
    [columnHeaders, selectable]
  );
  const handleResizeFinish = (0, import_react3.useCallback)(
    (e, { index, prev, ref }) => {
      const changedColumns = calculateResizeChange({
        columnElements: ref.current.parentElement.children,
        columnHeaders,
        e,
        index,
        prev,
        selectable
      });
      if (onResizeColumns) {
        onResizeColumns(changedColumns);
      }
    },
    [columnHeaders, onResizeColumns, selectable]
  );
  const numSelected = (selectedRows || []).length;
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: `deviceList ${selectable ? "selectable" : ""}`, ref: listRef, children: [
    /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: `header ${classes.header}`, children: /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: "deviceListRow", children: [
      selectable && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
        import_material3.Checkbox,
        {
          indeterminate: numSelected > 0 && numSelected < listItems.length,
          checked: numSelected === listItems.length,
          onChange: onSelectAllClick
        }
      ) }),
      columnHeaders.map((item, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
        HeaderItem,
        {
          column: item,
          columnCount: columnHeaders.length,
          index,
          onSort,
          resizable: !!onResizeColumns,
          sortCol,
          sortDown,
          onResizeChange: handleResizeChange,
          onResizeFinish: handleResizeFinish,
          sortingNotes
        },
        `columnHeader-${index}`
      ))
    ] }) }),
    /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: "body", children: listItems.map((item, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
      ListItemComponent,
      {
        columnHeaders,
        listItem: item,
        listState,
        idAttribute,
        index,
        onClick: onExpandClick,
        onRowSelect: onRowSelection,
        selectable,
        selected: selectedRows.indexOf(index) !== -1
      },
      item.id
    )) }),
    /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: "footer flexbox margin-top", children: [
      /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
        Pagination_default,
        {
          className: "margin-top-none",
          count: pageTotal,
          rowsPerPage: pageLength,
          onChangeRowsPerPage,
          page: pageNo,
          onChangePage: onPageChange,
          ...PaginationProps
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(Loader_default, { show: pageLoading, small: true })
    ] })
  ] });
};
var HeaderItem = (props) => {
  const { sortingNotes, column, columnCount, index, sortCol, sortDown = void 0, onSort, onResizeChange, onResizeFinish, resizable } = props;
  const [isHovering, setIsHovering] = (0, import_react3.useState)(false);
  const [shouldRemoveListeners, setShouldRemoveListeners] = (0, import_react3.useState)(false);
  const resizeRef = (0, import_react3.useRef)(null);
  const ref = (0, import_react3.useRef)(null);
  const { classes } = useStyles();
  const onMouseOut = () => setIsHovering(false);
  const onMouseOver = () => setIsHovering(true);
  const mouseMove = (0, import_react3.useCallback)(
    (e) => {
      if (resizable && resizeRef.current) {
        onResizeChange(e, { index, prev: resizeRef.current, ref });
        resizeRef.current = e.clientX;
      }
    },
    [index, onResizeChange, resizable]
  );
  const mouseUp = (0, import_react3.useCallback)(
    (e) => {
      if (resizeRef.current) {
        onResizeFinish(e, { index, prev: resizeRef.current, ref });
        resizeRef.current = null;
        setShouldRemoveListeners(true);
      }
    },
    [index, onResizeFinish]
  );
  const mouseDown = (e) => resizeRef.current = e.clientX;
  (0, import_react3.useEffect)(() => {
    window.addEventListener("mousemove", mouseMove);
    window.addEventListener("mouseup", mouseUp);
    return () => {
      setShouldRemoveListeners(!!resizeRef.current);
    };
  }, [mouseMove, mouseUp]);
  (0, import_react3.useEffect)(() => {
    if (shouldRemoveListeners) {
      window.removeEventListener("mousemove", mouseMove);
      window.removeEventListener("mouseup", mouseUp);
      setShouldRemoveListeners(false);
    }
  }, [shouldRemoveListeners, mouseMove, mouseUp]);
  let resizeHandleClassName = resizable && isHovering ? "hovering" : "";
  resizeHandleClassName = resizeRef.current ? "resizing" : resizeHandleClassName;
  const header = /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: "columnHeader flexbox space-between relative", style: column.style, onMouseEnter: onMouseOver, onMouseLeave: onMouseOut, ref, children: [
    /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: "flexbox center-aligned", onClick: () => onSort(column.attribute ? column.attribute : {}), children: [
      column.title,
      column.sortable && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
        import_icons_material2.Sort,
        {
          className: `sortIcon ${sortCol === column.attribute.name ? "selected" : ""} ${(sortDown === import_constants2.SORTING_OPTIONS.desc).toString()}`,
          style: { fontSize: 16 }
        }
      )
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("div", { className: "flexbox center-aligned full-height", children: [
      column.customize && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_icons_material2.Settings, { onClick: column.customize, style: { fontSize: 16 } }),
      index < columnCount - 2 && resizable && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { onMouseDown: mouseDown, className: `${classes.resizer} full-height`, children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: `full-height ${classes.resizeHandle} ${resizeHandleClassName}` }) })
    ] })
  ] });
  return column.sortable && sortingNotes && sortingNotes[column.attribute.name] ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(MenderTooltip_default, { title: sortingNotes[column.attribute.name], placement: "top-start", children: header }) : header;
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CommonList,
  calculateResizeChange,
  minCellWidth
});
//# sourceMappingURL=List.cjs.map