// src/auditlogs/AuditLogsFilter.tsx
import { useState } from "react";
import { TextField } from "@mui/material";
import { ControlledAutoComplete } from "@northern.tech/common-ui/forms/Autocomplete";
import ClickFilter from "@northern.tech/common-ui/forms/ClickFilter";
import Filters from "@northern.tech/common-ui/forms/Filters";
import TimeframePicker from "@northern.tech/common-ui/forms/TimeframePicker";
import { getISOStringBoundaries } from "@northern.tech/utils/helpers";
import { jsx } from "react/jsx-runtime";
var detailsMap = {
  Deployment: "to device group",
  User: "email"
};
var getOptionLabel = (option) => option.title ?? option.email ?? option;
var renderOption = (props, option) => {
  const { key, ...rest } = props;
  return /* @__PURE__ */ jsx("li", { ...rest, children: getOptionLabel(option) }, key);
};
var isUserOptionEqualToValue = ({ email, id }, value) => id === value || email === value || email === value?.email;
var autoSelectProps = {
  autoSelect: true,
  filterSelectedOptions: true,
  getOptionLabel,
  handleHomeEndKeys: true,
  renderOption
};
var AuditLogsFilter = ({ groups, users, selectionState, disabled, onFiltersChange, detailsReset, auditLogsTypes, dirtyField, setDirtyField }) => {
  const { detail, endDate, user, startDate, type } = selectionState;
  const [date] = useState(getISOStringBoundaries(/* @__PURE__ */ new Date()));
  const { start: today, end: tonight } = date;
  const typeOptionsMap = {
    Deployment: groups,
    User: Object.values(users)
  };
  const detailOptions = typeOptionsMap[type?.title] ?? [];
  return /* @__PURE__ */ jsx(ClickFilter, { disabled, children: /* @__PURE__ */ jsx(
    Filters,
    {
      initialValues: { startDate, endDate, user, type, detail },
      defaultValues: { startDate: today, endDate: tonight, user: "", type: null, detail: "" },
      fieldResetTrigger: detailsReset,
      dirtyField,
      clearDirty: setDirtyField,
      filters: [
        {
          key: "user",
          title: "Performed by",
          Component: ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            freeSolo: true,
            isOptionEqualToValue: isUserOptionEqualToValue,
            options: Object.values(users),
            renderInput: (params) => /* @__PURE__ */ jsx(TextField, { ...params, placeholder: "Select a user", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "type",
          title: "Filter by changes",
          Component: ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            options: auditLogsTypes,
            isOptionEqualToValue: (option, value) => option.value === value.value && option.object_type === value.object_type,
            renderInput: (params) => /* @__PURE__ */ jsx(TextField, { ...params, placeholder: "Type", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "detail",
          title: "",
          Component: ControlledAutoComplete,
          componentProps: {
            ...autoSelectProps,
            freeSolo: true,
            options: detailOptions,
            disabled: !type,
            renderInput: (params) => /* @__PURE__ */ jsx(TextField, { ...params, placeholder: detailsMap[type] || "-", InputProps: { ...params.InputProps } })
          }
        },
        {
          key: "timeframe",
          title: "Start time",
          Component: TimeframePicker,
          componentProps: {
            tonight
          }
        }
      ],
      onChange: onFiltersChange
    }
  ) });
};
var AuditLogsFilter_default = AuditLogsFilter;

export {
  AuditLogsFilter,
  AuditLogsFilter_default
};
//# sourceMappingURL=chunk-6QK3J3GE.js.map