import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { AuditLog, BillingProfile, Integration, Event } from '@northern.tech/types/MenderTypes';
import { OrganizationState, AuditLogSelectionState, Card, Organization, TenantList, SSOConfig } from './types.cjs';
import '@northern.tech/utils/constants';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import '@mui/material';
import './constants.cjs';

declare const sliceName = "organization";
declare const initialState: OrganizationState;
declare const organizationSlice: _reduxjs_toolkit.Slice<OrganizationState, {
    receiveAuditLogs: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<{
        events: AuditLog[];
        total: number;
    }>) => void;
    setAuditLogState: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Partial<AuditLogSelectionState>>) => void;
    receiveCurrentCard: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Card>) => void;
    receiveSetupIntent: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<string | null>) => void;
    setOrganization: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Partial<Organization>>) => void;
    setSubscription: (state: immer.WritableDraft<OrganizationState>, action: {
        payload: any;
        type: string;
    }) => void;
    setBillingProfile: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<BillingProfile>) => void;
    setTenantListState: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<TenantList>) => void;
    receiveExternalDeviceIntegrations: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Integration[]>) => void;
    receiveSsoConfigs: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<SSOConfig[]>) => void;
    receiveWebhookEvents: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<{
        total: number;
        value: Event[];
    }>) => void;
}, "organization", "organization", _reduxjs_toolkit.SliceSelectors<OrganizationState>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    receiveAuditLogs: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<{
        events: AuditLog[];
        total: number;
    }>) => void;
    setAuditLogState: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Partial<AuditLogSelectionState>>) => void;
    receiveCurrentCard: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Card>) => void;
    receiveSetupIntent: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<string | null>) => void;
    setOrganization: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Partial<Organization>>) => void;
    setSubscription: (state: immer.WritableDraft<OrganizationState>, action: {
        payload: any;
        type: string;
    }) => void;
    setBillingProfile: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<BillingProfile>) => void;
    setTenantListState: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<TenantList>) => void;
    receiveExternalDeviceIntegrations: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<Integration[]>) => void;
    receiveSsoConfigs: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<SSOConfig[]>) => void;
    receiveWebhookEvents: (state: immer.WritableDraft<OrganizationState>, action: PayloadAction<{
        total: number;
        value: Event[];
    }>) => void;
}, "organization">;
declare const _default: redux.Reducer<OrganizationState>;

export { actions, _default as default, initialState, organizationSlice, sliceName };
