// src/resizehook.ts
import { useLayoutEffect, useRef, useState } from "react";
var halfASecond = 500;
var useWindowSize = () => {
  const [size, setSize] = useState({ height: window.innerHeight, width: window.innerWidth });
  const timer = useRef(void 0);
  useLayoutEffect(() => {
    const handleResize = () => {
      timer.current = setTimeout(() => setSize({ height: window.innerHeight, width: window.innerWidth }), halfASecond);
    };
    window.addEventListener("resize", handleResize);
    handleResize();
    return () => {
      clearTimeout(timer.current);
      window.removeEventListener("resize", handleResize);
    };
  }, []);
  return size;
};
var resizehook_default = useWindowSize;

export {
  useWindowSize,
  resizehook_default
};
//# sourceMappingURL=chunk-HFTMPRWN.js.map