// src/forms/Autocomplete.tsx
import { Controller, useFormContext } from "react-hook-form";
import { Autocomplete } from "@mui/material";
import { jsx } from "react/jsx-runtime";
var ControlledAutoComplete = ({ freeSolo, name, onChange, onInputChange, ...remainder }) => {
  const { control } = useFormContext();
  return /* @__PURE__ */ jsx(
    Controller,
    {
      control,
      name,
      render: ({ field: { onChange: formOnChange, ...props } }) => {
        const onChangeHandler = (e, data) => formOnChange(data);
        return /* @__PURE__ */ jsx(Autocomplete, { ...freeSolo ? { freeSolo, onInputChange: onChangeHandler } : { onChange: onChangeHandler }, ...props, ...remainder });
      }
    }
  );
};

export {
  ControlledAutoComplete
};
//# sourceMappingURL=chunk-Y7RAVEWF.js.map