'use strict';
/*
 * This service is used to pass ("share") SQL scope between controllers
 */
reports.factory('wizardSharedService', function($rootScope) {

    var sharedService         = {};
    var changedSQLScope       = {};
    /*
     report id
     report label
     */
    var reportPropertiesScope = {};

    /* Reset scope to empty state */
    sharedService.resetScope = function() {
       this.changedSQLScope = {};
       this.reportPropertiesScope = {};
    };

    /**
     *  Save scope in the internal object and broadcast event
     */
    sharedService.scopeStateChanged = function(data) {
        this.changedSQLScope = data;
        $rootScope.$broadcast('scopeStateChanged');
    };

    /**
     *  Return scope from the internal object and broadcast event
     */
    sharedService.restoreScopeState = function() {
        $rootScope.$broadcast('restoreScopeState');
        return this.changedSQLScope;
    };

    sharedService.restoreEnvironment = function() {
        return this.reportPropertiesScope.environment;
    };

    sharedService.reportPropertiesChanged = function(data) {
        this.reportPropertiesScope = data;
    };

    sharedService.restoreReportProperties = function() {
        return this.reportPropertiesScope;
    };

    return sharedService;
});