<div id="SQLFilters" class="margin-top">
<div style="overflow:hidden">
    <h3 class="display-inline-block">Tables</h3>
    <span class="help-block"><?php echo $this->lang->line('tooltip_sql_tables') ?></span>
    <div table-list tabledata="dcaByTable" selectedtables="SelectedTables" select-table="updateSelectedTable(tableID, event)"></div>
</div> <!-- /tables -->

<div class="margin-top selectFields_SE">
    <h3 class="display-inline-block">Fields</h3>
    <span class="help-block"><?php echo $this->lang->line('tooltip_sql_fields') ?></span>
        <p ng-show="isObjEmpty(SelectedDCA)">No tables selected</p>
        <div ng-repeat="(tableId, table) in SelectedDCA"  class="group-header tableFields_{{tableId}}_SE">
            <h5>{{table.label}}</h5>
            <div ng-switch on="table.joinType" class="join-description help-block">
                <span ng-switch-when="main" class="main-table">(Main)</span>
                <span ng-switch-when="leftJoin">This table extends main table (left join)</span>
                <span ng-switch-when="innerJoin">This table filters main table. Only common rows included (inner join)</span>
                <a ng-click="modifyJoinType(tableId)" ng-show="SelectedTablesCount > 1">Modify</a>
            </div>
            <ul class="group-items unstyled">
                <li ng-repeat="field in fieldsToArray(table.Fields) | orderBy:'label'" >
                    <div class="checkbox">
                        <label for="field_{{field.fieldId}}">
                            <input type="checkbox" ng-model="field.isSelected" ng-change="updateSelectedFields(tableId, field.fieldId)" id="field_{{field.fieldId}}" />
                            {{field.label}}
                        </label>
                    </div>
                </li>
            </ul>
             <select-all-checkbox checkboxes="table.Fields" tableid="tableId" class="select-all-cb margin-bottom"></select-all-checkbox>
        </div>
</div> <!-- /fields -->

<div class="row-fluid advReportsSectionMargin setFilters_SE">
    <h3 class="display-inline-block">Filters</h3><em class="muted"> optional</em>
    <span class="help-block"><?php echo $this->lang->line('tooltip_sql_filters') ?></span>

    <table class="filters table advancedReportFormTable filtersFieldList_SE" ng-if="SQL.filters.length>0 && SQL.filters !=null">
    <tr class="no-hover" ng-repeat="field in SQL.filters">
        <td>
            <div class="token token-gray token-fluid"><span>{{field.label}}</span></div>
        </td>
        <td>
            <select ng-model="field.comparison" ng-options="f.value as  f.label for f in Comparison | filterConditionsByDataType:field" ng-change="changeScopeState()" class="pull-left input-medium filtersSelectComparison_SE"></select>
        </td>
        <td class="filtersComparitionValue_SE">
            <div ng-switch on="field.type" class="pull-left" ng-show="field.comparison != 'IS NOT NULL' && field.comparison != 'IS NULL'">
                <div ng-switch-default class="input {{field.inputType}}" ng-class="field.required && 'required'">
                    <div ng-switch on="field.inputType">
                        <span ng-switch-default>Invalid input type: {{field.inputType}}</span>
                        <input ng-switch-when="text" type="text"
                            ng-model="field.value" ng-bind-attr="{required:'{{field.required}}'}" placeholder="{{field.placeholder}}"  class="input-medium" ng-blur="changeScopeState()">
                        <input ng-switch-when="checkbox" type="checkbox"
                            ng-model="field.value" value="{{field.value}}" id="field" placeholder="{{field.instructions}}"  class="input-medium">
                        <textarea ng-switch-when="textarea"
                                ng-model="field.value" placeholder="{{field.instructions}}">{{field.value}}</textarea>
                        <select ng-switch-when="select"
                                ng-model="field.value" >
                            <option ng-repeat="option in field.options" value="{{option.value}}">{{option.name}}</option>
                        </select>
                        <select ng-switch-when="multiple"
                                ng-model="field.value" multiple>
                            <option ng-repeat="option in field.options" value="{{option.value}}">{{option.name}}</option>
                        </select>
                        <fieldset ng-switch-when="radio">
                            <label ng-repeat="option in field.options">
                                <input type="radio" ng-model="field.value" value="{{option.value}}">
                                {{option.name}}
                            </label>
                        </fieldset>
                        <fieldset ng-switch-when="checkboxes">
                            <label ng-repeat="option in field.options">
                                <input type="checkbox" ng-model="field.value[tokenize(option.name)]" value="{{option.value}}">
                                {{option.name}}
                            </label>
                        </fieldset>

                        <!-- custom elements with js bindings -->

                        <div ng-switch-when="finderWidget" class="input-append filters">
                            <input type="text" ng-model="field.value" <!--  ng-bind-attr="{required:'{{field.required}}'}" -->  value="{{field.value}}"  class="input-medium" ng-blur="changeScopeState()"><a class="add-on" href="javascript:void(0)"><big><i title="{{field.finderTitle}}" class="cfe-ico-16 add-on-cfe-finder bind-finder" finder-type="{{field.finderType}}"></i></big></a>
                        </div>

                        <div ng-switch-when="datetimepickerWidget">
                            <input type="text" ng-model="field.value" <!-- ng-bind-attr="{required:'{{field.required}}'}" --> value="{{field.value}}"  class="input-medium bind-datetimepicker">
                        </div>
                <!-- </ng-switch> -->
                    </div>
                    </div>
                </div>
            </td>

            <td>
                    <span class="trackerDelete pull-right filterDeleteRow_SE" ng-click="splice(field, 'filters')"><i class="icon-remove"></i></span>
            </td>
    </tr> <!-- /end form -->
    </table>

    <div class="clearfix"></div>

    <ul class="nav pills token token-cyan" ng-disabled="isObjEmpty(SelectedDCA)">
        <li class="dropdown">
            <a href="javascript:void(0)" data-toggle="dropdown" class="dropdown-toggle addFilter_SE">
                <span class="icon-plus"></span>
                <span>Add</span>
            </a>
            <ul ng-hide="SelectedDCA.length == 0" class="dropdown-menu dropdown_reports filterSelectFields_SE">
                <li ng-repeat="(tableId, table) in SelectedDCA"  class="group-header"><span>{{table.label}}</span>
                    <ul class="group-items filterFields_{{tableId}}_SE" style="padding-left: 10px">
                        <li ng-repeat="field in fieldsToArray(table.Fields) | orderBy:'label'"><a href="#" ng-click="saveField('filters', tableId, field.fieldId, $event)">{{field.label}}</a></li>
                    </ul>
                </li>
            </ul>
        </li>
    </ul>
</div> <!-- /filters -->

<?php /*
<div class="row-fluid advReportsSectionMargin setGroupBy_SE">
   <h3 class="display-inline-block">Group</h3><em class="muted"> optional</em>
   <span class="help-block"><?php echo $this->lang->line('tooltip_sql_group') ?></span>
   <div class="groupByFieldList_SE">
       <div ng-repeat="field in SQL.groupby" class="pull-left groupByItem_SE">
           <div class="token token-gray"><span>{{field.label}}</span><a class="trackerDelete pull-right" data-dismiss="alert" ng-click="splice(field, 'groupby')"><span class="icon-remove"></span></a></div>
       </div>
   </div>


    <ul class="nav pills token token-cyan" ng-disabled="isObjEmpty(groupByFieldsList)">
        <li class="dropdown">
            <a href="javascript:void(0)" data-toggle="dropdown" class="dropdown-toggle addGroupBy_SE">
                <span class="icon-plus"></span>
                <span>Add</span>
            </a>
            <ul ng-hide="isObjEmpty(groupByFieldsList)" class="dropdown-menu dropdown_reports groupBySelectFields_SE">
                <li ng-repeat="(tableId, table) in groupByFieldsList"  class="group-header"><span>{{table.label}}</span>
                    <ul class="group-items groupByFields_{{tableId}}_SE" style="padding-left: 10px">
                        <li ng-repeat="(fieldId, field) in table.Fields"><a href="#" ng-click="saveField('groupby', tableId, fieldId, $event)">{{field.label}}</a></li>
                    </ul>
                </li>
            </ul>
        </li>
    </ul>
</div> <!-- /group -->

*/ ?>

<div class="row-fluid advReportsSectionMargin setSort_SE">
    <h3 class="display-inline-block">Sort</h3><em class="muted"> optional</em>
    <span class="help-block"><?php echo $this->lang->line('tooltip_sql_sort') ?></span>

    <table class="filters table no-hover table-condensed advancedReportFormTable sortFieldList_SE" ng-if="isObjEmpty(SQL.orderby) == false">
        <tr ng-repeat="field in SQL.orderby">
            <td>
                <div class="token token-gray token-fluid"><span>{{field.label}}</span></div>
            </td>
            <td>
                <select ng-model="field.order" ng-options="f.value as f.label for f  in Order" ng-change="changeScopeState()" class="input-medium"></select>
            </td>
            <td>
                <span class="trackerDelete" ng-click="splice(field, 'orderby')"><i class="icon-remove"></i></span>
            </td>
        </tr>
    </table>

    <div class="clearfix"></div>
    <?php
    // isObjEmpty(groupByFieldsList) - not a typo, we are using the same list of fields for group and sort
    ?>
    <ul class="nav pills token token-cyan" ng-disabled="isObjEmpty(groupByFieldsList)">
        <li class="dropdown">
            <a href="javascript:void(0)" data-toggle="dropdown" class="dropdown-toggle addSort_SE">
                <span class="icon-plus"></span>
                <span>Add</span>
            </a>

            <ul ng-hide="isObjEmpty(orderByFieldsList)" class="dropdown-menu dropdown_reports sortSelectFields_SE">
                <li ng-repeat="(tableId, table) in orderByFieldsList"  class="group-header"><span>{{table.label}}</span>
                    <ul class="group-items sortFields_{{tableId}}_SE" style="padding-left: 10px">
                        <li ng-repeat="field in fieldsToArray(table.Fields) | orderBy:'label'"><a href="#" ng-click="saveField('orderby', tableId, field.fieldId, $event)">{{field.label}}</a></li>
                    </ul>
                </li>
            </ul>
        </li>
    </ul>
</div> <!-- /sort -->


<div class="row-fluid advReportsSectionMargin setLimit_SE">
   <h3 class="display-inline-block">Limit</h3><em class="muted"> optional</em>
   <span class="help-block"><?php echo $this->lang->line('tooltip_sql_limit') ?></span>

    <select id="limitSelection_SE" ng-model="SQL.limit" ng-change ="updateLimit()" ng-options="c for c in Limit">
            <option value="">None</option>
    </select>
</div>    <!-- /limit -->

    <div class="row-fluid advReportsSectionMargin">
        <h3 class="display-inline-block">Result interpretation</h3><em class="muted"> optional</em>
        <span class="help-block"></span>
        <div class="checkbox">
            <label for="no_result">
                <input type="checkbox" id="no_result" ng-model="noResultsSuccess"/>
                No results indicate success
            </label>
        </div>
    </div>
</div>
