// src/appSlice/selectors.ts
import { versionCompare } from "@northern.tech/utils/helpers";
import { createSelector } from "@reduxjs/toolkit";
var getDocsVersion = (state) => state.app.docsVersion;
var getFeatures = (state) => state.app.features;
var getFullVersionInformation = (state) => state.app.versionInformation;
var getSearchState = (state) => state.app.searchState;
var getUploads = (state) => state.app.uploadsById;
var getSnackbar = (state) => state.app.snackbar;
var getHostAddress = (state) => state.app.hostAddress;
var getHostedAnnouncement = (state) => state.app.hostedAnnouncement;
var getRecaptchaKey = (state) => state.app.recaptchaSiteKey;
var getStripeKey = (state) => state.app.stripeAPIKey;
var getTrackerCode = (state) => state.app.trackerCode;
var getSentryConfig = (state) => state.app.sentry;
var getCommit = (state) => state.app.commit;
var getIsFirstLogin = (state) => state.app.firstLoginAfterSignup;
var getFeedbackProbability = (state) => state.app.feedbackProbability;
var getIsUploading = createSelector([getUploads], (uploadsById) => !!Object.keys(uploadsById).length);
var getSearchedDevices = createSelector([getSearchState], ({ deviceIds }) => deviceIds);
var getVersionInformation = createSelector(
  [getFullVersionInformation, getFeatures],
  ({ Integration, ...remainder }, { isHosted }) => isHosted && Integration !== "next" ? remainder : { ...remainder, Integration }
);
var getIsPreview = createSelector([getFullVersionInformation], ({ Integration }) => versionCompare(Integration, "next") > -1);

export {
  getDocsVersion,
  getFeatures,
  getFullVersionInformation,
  getSearchState,
  getUploads,
  getSnackbar,
  getHostAddress,
  getHostedAnnouncement,
  getRecaptchaKey,
  getStripeKey,
  getTrackerCode,
  getSentryConfig,
  getCommit,
  getIsFirstLogin,
  getFeedbackProbability,
  getIsUploading,
  getSearchedDevices,
  getVersionInformation,
  getIsPreview
};
//# sourceMappingURL=chunk-BYUPW7RA.js.map