"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/DocsLink.tsx
var DocsLink_exports = {};
__export(DocsLink_exports, {
  DOCSTIPS: () => DOCSTIPS,
  DocsLink: () => DocsLink,
  DocsTooltip: () => DocsTooltip,
  default: () => DocsLink_default
});
module.exports = __toCommonJS(DocsLink_exports);
var import_react2 = require("react");
var import_react_redux = require("react-redux");
var import_icons_material = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_mui2 = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_selectors = require("@northern.tech/store/selectors");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// src/helptips/MenderTooltip.tsx
var import_react = require("react");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var MenderTooltip = (0, import_mui.withStyles)(import_material.Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltipClickable = ({
  children,
  onboarding,
  startOpen = false,
  visibility = startOpen,
  onOpenChange,
  tooltipComponent = MenderTooltip,
  ...remainingProps
}) => {
  const [open, setOpen] = (0, import_react.useState)(startOpen || false);
  (0, import_react.useEffect)(() => {
    setOpen(visibility);
  }, [visibility]);
  (0, import_react.useEffect)(() => {
    if (!onOpenChange) {
      return;
    }
    onOpenChange(open);
  }, [open, onOpenChange]);
  const toggleVisibility = () => setOpen(import_helpers.toggle);
  const hide = () => setOpen(false);
  const Component = tooltipComponent;
  const extraProps = onboarding ? {
    PopperProps: {
      disablePortal: true,
      popperOptions: {
        strategy: "fixed",
        modifiers: [
          { name: "flip", enabled: false },
          { name: "preventOverflow", enabled: true, options: { boundary: window, altBoundary: false } }
        ]
      }
    }
  } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.ClickAwayListener, { onClickAway: hide, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    Component,
    {
      arrow: !onboarding,
      open,
      disableFocusListener: true,
      disableHoverListener: true,
      disableTouchListener: true,
      onOpen: () => setOpen(true),
      ...extraProps,
      ...remainingProps,
      children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { onClick: toggleVisibility, children })
    }
  ) });
};

// src/DocsLink.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var useStyles = (0, import_mui2.makeStyles)()((theme) => ({
  iconAura: {
    position: "absolute",
    top: -6,
    bottom: -4,
    left: -7,
    right: -6.5,
    border: `1px dashed ${theme.palette.text.disabled}`,
    borderRadius: "50%",
    "&.hovering": {
      borderColor: "transparent"
    }
  },
  chip: {
    borderStyle: "dashed",
    [`.${import_material2.chipClasses.deleteIcon}`]: {
      fontSize: "smaller"
    },
    "&.not-hovering": {
      borderColor: "transparent",
      color: theme.palette.text.disabled,
      [`.${import_material2.chipClasses.deleteIcon}`]: {
        color: theme.palette.text.disabled
      },
      [`.${import_material2.chipClasses.label}`]: {
        paddingLeft: 0,
        visibility: "collapse"
      }
    }
  }
}));
var DOCSTIPS = {
  deviceConfig: { id: "deviceConfig", path: "add-ons/configure" },
  dynamicGroups: { id: "dynamicGroups", path: "overview/device-group#dynamic-group" },
  limitedDeployments: { id: "limitedDeployments", path: "overview/deployment#deployment-to-dynamic-groups" },
  phasedDeployments: { id: "phasedDeployments", path: "overview/customize-the-update-process" },
  pausedDeployments: { id: "pausedDeployments", path: "overview/customize-the-update-process#synchronized-updates" },
  retryDeployments: { id: "retryDeployments", path: "overview/deployment" },
  releases: { id: "releases", path: "overview/artifact" },
  rbac: { id: "rbac", path: "overview/role.based.access.control" },
  webhookSecret: { id: "webhookSecret", path: "server-integration/webhooks#signature-header" }
};
var DocsTooltip = ({ anchor = {}, id = "", ...props }) => {
  const [isHovering, setIsHovering] = (0, import_react2.useState)(false);
  const debouncedHovering = (0, import_debouncehook.useDebounce)(isHovering, import_constants.TIMEOUTS.debounceDefault);
  const docsVersion = (0, import_react_redux.useSelector)(import_selectors.getDocsVersion);
  const { isHosted } = (0, import_react_redux.useSelector)(import_selectors.getFeatures);
  const { classes } = useStyles();
  const { content, path } = DOCSTIPS[id] || {};
  const target = `https://docs.mender.io/${docsVersion}${path}`;
  const onClick = () => {
    const docsParams = { headers: { "x-mender-docs": docsVersion } };
    fetch(target, isHosted ? {} : docsParams);
    window.open(target, "_blank");
  };
  const hoverClass = debouncedHovering ? "hovering" : "not-hovering";
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    MenderTooltipClickable,
    {
      placement: "bottom-start",
      disableFocusListener: false,
      disableHoverListener: false,
      disableTouchListener: false,
      style: anchor,
      title: content,
      ...props,
      children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
        import_material2.Chip,
        {
          color: "primary",
          className: `${classes.chip} ${hoverClass}`,
          label: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Collapse, { in: debouncedHovering, orientation: "horizontal", children: "Learn more" }),
          deleteIcon: /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "relative", children: [
            /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.Description, { fontSize: "small" }),
            /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { className: `${classes.iconAura} ${hoverClass}` })
          ] }),
          onClick,
          onDelete: onClick,
          onMouseOver: () => setIsHovering(true),
          onMouseOut: () => setIsHovering(false),
          variant: "outlined"
        }
      )
    }
  );
};
var DocsLink = (0, import_react2.forwardRef)(({ children, className = "", path, title = "", ...remainder }, ref) => {
  const docsVersion = (0, import_react_redux.useSelector)(import_selectors.getDocsVersion);
  const { isHosted } = (0, import_react_redux.useSelector)(import_selectors.getFeatures);
  const target = `https://docs.mender.io/${path}`;
  const onClickHandler = () => {
    const docsParams = { headers: { "x-mender-docs": docsVersion } };
    fetch(target, isHosted ? {} : docsParams);
  };
  return (
    // eslint-disable-next-line react/jsx-no-target-blank
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("a", { className, ...remainder, href: target, onClick: onClickHandler, ref, target: "_blank", rel: isHosted ? "noopener" : "", children: children ? children : title })
  );
});
DocsLink.displayName = "DocsLink";
var DocsLink_default = DocsLink;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DOCSTIPS,
  DocsLink,
  DocsTooltip
});
//# sourceMappingURL=DocsLink.cjs.map