import {
  getDeploymentsByStatus,
  getDeviceAttributes,
  getDeviceById,
  getDeviceLimit,
  getDevicesByStatus as getDevicesByStatus2,
  getDynamicGroups,
  getGlobalSettings as getGlobalSettings2,
  getGroups,
  getIntegrations,
  getLatestReleaseInfo,
  getOnboardingState as getOnboardingState2,
  getRoles,
  getUserOrganization,
  getUserSettings as getUserSettings2,
  saveGlobalSettings,
  saveUserSettings
} from "./chunk-3P3IE42O.js";
import {
  getReleases
} from "./chunk-QKPV5RRN.js";
import "./chunk-H5FAPMJJ.js";
import "./chunk-V3QEONX7.js";
import "./chunk-QHK7GGV4.js";
import "./chunk-RS37Y2PQ.js";
import {
  actions_default
} from "./chunk-F26IKSML.js";
import "./chunk-OOICURFL.js";
import "./chunk-UGSLGUS6.js";
import "./chunk-MZNANSS2.js";
import "./chunk-PGFVHKP5.js";
import "./chunk-VANBSJS5.js";
import "./chunk-VUFRP6P3.js";
import "./chunk-QYLGIR4W.js";
import "./chunk-ABJLRDCO.js";
import {
  getSessionInfo
} from "./chunk-ZJW3QIPM.js";
import "./chunk-KC7SKI3U.js";
import "./chunk-NMAXZ3ZY.js";
import {
  getIsEnterprise,
  getOnboardingState,
  getUserCapabilities
} from "./chunk-SCZLNFB5.js";
import "./chunk-MSOXMRF7.js";
import {
  getGlobalSettings,
  getOfflineThresholdSettings,
  getUserSettings
} from "./chunk-R6KRH2IY.js";
import {
  getIsServiceProvider
} from "./chunk-YY6SKZDF.js";
import "./chunk-YO22XLHI.js";
import "./chunk-JIS4PA3R.js";
import {
  getDevicesByStatus,
  getSortedFilteringAttributes
} from "./chunk-KJNNEDRV.js";
import "./chunk-JXQUFKID.js";
import {
  getFeatures
} from "./chunk-BYUPW7RA.js";
import {
  getComparisonCompatibleVersion,
  stringToBoolean
} from "./chunk-UE5N5VO3.js";
import {
  DEPLOYMENT_STATES,
  DEVICE_STATES,
  TIMEOUTS,
  timeUnits
} from "./chunk-7C4SQBEE.js";
import "./chunk-2DYA3X77.js";
import "./chunk-FAJ3I2UQ.js";
import "./chunk-ZKAH3APE.js";
import "./chunk-HFOTAPIJ.js";

// src/storehooks.ts
import { useCallback, useEffect, useRef, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { extractErrorMessage } from "@northern.tech/utils/helpers";
import dayjs from "dayjs";
import durationDayJs from "dayjs/plugin/duration.js";
import Cookies from "universal-cookie";
var cookies = new Cookies();
dayjs.extend(durationDayJs);
var { setDeviceListState, setFirstLoginAfterSignup, setTooltipsState, setShowStartupNotification } = actions_default;
var featureFlags = [
  "hasAuditlogs",
  "hasMultitenancy",
  "hasDeltaProgress",
  "hasDeviceConfig",
  "hasDeviceConnect",
  "hasFeedbackEnabled",
  "hasReporting",
  "hasMonitor",
  "isEnterprise"
];
var environmentDatas = ["commit", "feedbackProbability", "hostAddress", "hostedAnnouncement", "recaptchaSiteKey", "sentry", "stripeAPIKey", "trackerCode"];
var parseEnvironmentInfo = () => (dispatch, getState) => {
  const state = getState();
  let onboardingComplete = state.onboarding.complete || !!JSON.parse(window.localStorage.getItem("onboardingComplete") ?? "false");
  let demoArtifactPort = 85;
  let environmentData = {};
  let environmentFeatures = {};
  let versionInfo = {};
  if (mender_environment) {
    const {
      features = {},
      demoArtifactPort: port,
      disableOnboarding,
      integrationVersion,
      menderVersion,
      menderArtifactVersion,
      metaMenderVersion
    } = mender_environment;
    demoArtifactPort = port || demoArtifactPort;
    environmentData = environmentDatas.reduce((accu, flag) => ({ ...accu, [flag]: mender_environment[flag] || state.app[flag] }), {});
    environmentFeatures = {
      ...featureFlags.reduce((accu, flag) => ({ ...accu, [flag]: stringToBoolean(features[flag]) }), {}),
      isHosted: stringToBoolean(features.isHosted) || window.location.hostname.includes("hosted.mender.io")
    };
    onboardingComplete = !stringToBoolean(environmentFeatures.isHosted) || stringToBoolean(disableOnboarding) || onboardingComplete;
    versionInfo = {
      docs: isNaN(integrationVersion.charAt(0)) ? "" : integrationVersion.split(".").slice(0, 2).join("."),
      remainder: {
        Integration: getComparisonCompatibleVersion(integrationVersion),
        "Mender-Client": getComparisonCompatibleVersion(menderVersion),
        "Mender-Artifact": menderArtifactVersion,
        "Meta-Mender": metaMenderVersion
      }
    };
  }
  return Promise.all([
    dispatch(actions_default.successfullyLoggedIn(getSessionInfo())),
    dispatch(actions_default.setOnboardingComplete(onboardingComplete)),
    dispatch(actions_default.setDemoArtifactPort(demoArtifactPort)),
    dispatch(actions_default.setFeatures(environmentFeatures)),
    dispatch(actions_default.setVersionInformation({ ...versionInfo.remainder, docsVersion: versionInfo.docs })),
    dispatch(actions_default.setEnvironmentData(environmentData)),
    dispatch(getLatestReleaseInfo())
  ]);
};
var maybeAddOnboardingTasks = ({ devicesByStatus, dispatch, onboardingState, tasks }) => {
  if (!onboardingState.showTips || onboardingState.complete) {
    return tasks;
  }
  return devicesByStatus[DEVICE_STATES.accepted].deviceIds.reduce((accu, id) => {
    accu.push(dispatch(getDeviceById(id)));
    return accu;
  }, tasks);
};
var useAppInit = (userId) => {
  const dispatch = useDispatch();
  const [coreInitDone, setCoreInitDone] = useState(false);
  const isEnterprise = useSelector(getIsEnterprise);
  const { hasMultitenancy, isHosted } = useSelector(getFeatures);
  const devicesByStatus = useSelector(getDevicesByStatus);
  const onboardingState = useSelector(getOnboardingState);
  const { columnSelection = [], trackingConsentGiven: hasTrackingEnabled, tooltips = {} } = useSelector(getUserSettings);
  const { canManageUsers } = useSelector(getUserCapabilities);
  const { interval, intervalUnit } = useSelector(getOfflineThresholdSettings);
  const { id_attribute } = useSelector(getGlobalSettings);
  const { identityAttributes } = useSelector(getSortedFilteringAttributes);
  const isServiceProvider = useSelector(getIsServiceProvider);
  const coreInitRunning = useRef(false);
  const fullInitRunning = useRef(false);
  const retrieveCoreData = useCallback(() => {
    const tasks = [
      dispatch(parseEnvironmentInfo()),
      dispatch(getUserSettings2()),
      dispatch(getGlobalSettings2()),
      dispatch(setFirstLoginAfterSignup(stringToBoolean(cookies.get("firstLoginAfterSignup"))))
    ];
    const multitenancy = hasMultitenancy || isHosted || isEnterprise;
    if (multitenancy) {
      tasks.push(dispatch(getUserOrganization()));
    }
    return Promise.all(tasks);
  }, [dispatch, hasMultitenancy, isHosted, isEnterprise]);
  const retrieveAppData = useCallback(() => {
    if (isServiceProvider) {
      return Promise.resolve(dispatch(getRoles()));
    }
    return Promise.all([
      dispatch(getDeviceAttributes()),
      dispatch(getDeploymentsByStatus({ status: DEPLOYMENT_STATES.finished, shouldSelect: false })),
      dispatch(getDeploymentsByStatus({ status: DEPLOYMENT_STATES.inprogress })),
      dispatch(getDevicesByStatus2({ status: DEVICE_STATES.accepted })),
      dispatch(getDevicesByStatus2({ status: DEVICE_STATES.pending })),
      dispatch(getDevicesByStatus2({ status: DEVICE_STATES.preauth })),
      dispatch(getDevicesByStatus2({ status: DEVICE_STATES.rejected })),
      dispatch(getDynamicGroups()),
      dispatch(getGroups()),
      dispatch(getIntegrations()),
      dispatch(getReleases()),
      dispatch(getDeviceLimit()),
      dispatch(getRoles())
    ]);
  }, [dispatch, isServiceProvider]);
  const interpretAppData = useCallback(() => {
    const settings = {};
    if (cookies.get("_ga") && typeof hasTrackingEnabled === "undefined") {
      settings.trackingConsentGiven = true;
    }
    let tasks = [
      dispatch(setDeviceListState({ selectedAttributes: columnSelection.map((column) => ({ attribute: column.key, scope: column.scope })) })),
      dispatch(setTooltipsState(tooltips)),
      // tooltips read state is primarily trusted from the redux store, except on app init - here user settings are the reference
      dispatch(saveUserSettings(settings))
    ];
    tasks = maybeAddOnboardingTasks({ devicesByStatus, dispatch, tasks, onboardingState });
    if (canManageUsers && intervalUnit && intervalUnit !== timeUnits.days) {
      const duration = dayjs.duration(interval, intervalUnit);
      const days = duration.asDays();
      if (days < 1) {
        tasks.push(Promise.resolve(setTimeout(() => dispatch(setShowStartupNotification(true)), TIMEOUTS.fiveSeconds)));
      } else {
        const roundedDays = Math.max(1, Math.round(days));
        tasks.push(dispatch(saveGlobalSettings({ offlineThreshold: { interval: roundedDays, intervalUnit: timeUnits.days } })));
      }
    }
    const identityOptions = identityAttributes.filter((attribute) => !["id", "Device ID", "status"].includes(attribute));
    if (!id_attribute && identityOptions.length) {
      tasks.push(dispatch(saveGlobalSettings({ id_attribute: { attribute: identityOptions[0], scope: "identity" } })));
    } else if (typeof id_attribute === "string") {
      let attribute = id_attribute;
      if (attribute === "Device ID") {
        attribute = "id";
      }
      tasks.push(dispatch(saveGlobalSettings({ id_attribute: { attribute, scope: "identity" } })));
    }
    return Promise.all(tasks);
  }, [
    columnSelection,
    dispatch,
    identityAttributes,
    hasTrackingEnabled,
    canManageUsers,
    devicesByStatus,
    id_attribute,
    interval,
    intervalUnit,
    onboardingState,
    tooltips
  ]);
  const initializeAppData = useCallback(
    () => retrieveAppData().then(interpretAppData).catch((err) => console.log(extractErrorMessage(err))).then(() => dispatch(getOnboardingState2())),
    [dispatch, retrieveAppData, interpretAppData]
  );
  useEffect(() => {
    if (!userId || coreInitRunning.current) {
      return;
    }
    coreInitRunning.current = true;
    retrieveCoreData().then(() => setCoreInitDone(true));
  }, [userId, retrieveCoreData]);
  useEffect(() => {
    if (fullInitRunning.current || !coreInitDone) {
      return;
    }
    fullInitRunning.current = true;
    initializeAppData();
  }, [initializeAppData, coreInitDone]);
  return { coreInitDone };
};
export {
  parseEnvironmentInfo,
  useAppInit
};
//# sourceMappingURL=storehooks.js.map