// src/helptips/MenderTooltip.tsx
import { useEffect, useState } from "react";
import { ClickAwayListener, Tooltip } from "@mui/material";
import { withStyles } from "tss-react/mui";
import { toggle } from "@northern.tech/utils/helpers";
import { jsx } from "react/jsx-runtime";
var MenderTooltip = withStyles(Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltipClickable = ({
  children,
  onboarding,
  startOpen = false,
  visibility = startOpen,
  onOpenChange,
  tooltipComponent = MenderTooltip,
  ...remainingProps
}) => {
  const [open, setOpen] = useState(startOpen || false);
  useEffect(() => {
    setOpen(visibility);
  }, [visibility]);
  useEffect(() => {
    if (!onOpenChange) {
      return;
    }
    onOpenChange(open);
  }, [open, onOpenChange]);
  const toggleVisibility = () => setOpen(toggle);
  const hide = () => setOpen(false);
  const Component = tooltipComponent;
  const extraProps = onboarding ? {
    PopperProps: {
      disablePortal: true,
      popperOptions: {
        strategy: "fixed",
        modifiers: [
          { name: "flip", enabled: false },
          { name: "preventOverflow", enabled: true, options: { boundary: window, altBoundary: false } }
        ]
      }
    }
  } : {};
  return /* @__PURE__ */ jsx(ClickAwayListener, { onClickAway: hide, children: /* @__PURE__ */ jsx(
    Component,
    {
      arrow: !onboarding,
      open,
      disableFocusListener: true,
      disableHoverListener: true,
      disableTouchListener: true,
      onOpen: () => setOpen(true),
      ...extraProps,
      ...remainingProps,
      children: /* @__PURE__ */ jsx("div", { onClick: toggleVisibility, children })
    }
  ) });
};
var MenderTooltip_default = MenderTooltip;

export {
  MenderTooltip,
  MenderTooltipClickable,
  MenderTooltip_default
};
//# sourceMappingURL=chunk-6YMQVQXN.js.map