"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dialogs/Log.tsx
var Log_exports = {};
__export(Log_exports, {
  LogDialog: () => LogDialog,
  default: () => Log_default
});
module.exports = __toCommonJS(Log_exports);
var import_react2 = require("react");
var import_react_copy_to_clipboard2 = __toESM(require("react-copy-to-clipboard"), 1);
var import_material3 = require("@mui/material");
var import_helpers = require("@northern.tech/utils/helpers");

// src/CopyCode.tsx
var import_react = require("react");
var import_react_copy_to_clipboard = __toESM(require("react-copy-to-clipboard"), 1);
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  code: {
    border: "1px solid",
    borderColor: theme.palette.background.lightgrey,
    backgroundColor: theme.palette.background.lightgrey
  }
}));
var Code = ({ className = "", children, style = {} }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: `code ${classes.code} ${className}`, style, children });
};

// src/dialogs/BaseDialog.tsx
var import_material2 = require("@mui/material");
var import_jsx_runtime2 = require("react/jsx-runtime");
var BaseDialog = (props) => {
  const { children, onClose, title, ...dialogProps } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.Dialog, { ...dialogProps, onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.DialogTitle, { children: title }),
    children
  ] });
};

// src/dialogs/Log.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var wrapperStyle = { marginRight: 10, display: "inline-block" };
var dialogTypes = {
  "deviceLog": {
    title: "Deployment log for device",
    filename: ({ device, releaseName, date }) => `deployment-log-${device}-${releaseName}-${date}.log`
  },
  "configUpdateLog": {
    title: "Config update log for device",
    filename: () => "configuration-update.log"
  }
};
var LogDialog = ({ context = {}, logData = "", onClose, type = "deviceLog" }) => {
  const [copied, setCopied] = (0, import_react2.useState)(false);
  const exportLog = () => (0, import_helpers.createFileDownload)(logData, dialogTypes[type].filename(context), "");
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(BaseDialog, { open: true, title: dialogTypes[type].title, maxWidth: "lg", onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_material3.DialogContent, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Code, { className: "log", children: logData }),
      /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("p", { style: { marginLeft: 24 }, children: copied && /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_material3.DialogActions, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { style: wrapperStyle, children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.Button, { onClick: onClose, children: "Cancel" }) }),
      /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_react_copy_to_clipboard2.default, { style: wrapperStyle, text: logData, onCopy: () => setCopied(true), children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.Button, { children: "Copy to clipboard" }) }),
      /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.Button, { variant: "contained", color: "primary", onClick: exportLog, children: "Export log" })
    ] })
  ] });
};
var Log_default = LogDialog;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LogDialog
});
//# sourceMappingURL=Log.cjs.map