declare const mockState: {
    byId: {
        a1: {
            id: string;
            attributes: {
                device_type: string[];
                ipv4_wlan0: string;
            };
            system: {
                check_in_time: string;
            };
            check_in_time: string;
            check_in_time_exact: string;
            check_in_time_rounded: string;
            identity_data: {
                mac: string;
            };
            status: string;
            decommissioning: boolean;
            created_ts: string;
            updated_ts: string;
            auth_sets: {
                id: string;
                identity_data: {
                    mac: string;
                };
                pubkey: string;
                ts: string;
                status: string;
            }[];
        };
        b1: {
            id: string;
            attributes: {
                ipv4_wlan0: string;
                device_type: string[];
            };
            system: {
                check_in_time: string;
            };
            check_in_time: string;
            check_in_time_exact: string;
            check_in_time_rounded: string;
            identity_data: {
                mac: string;
            };
            status: string;
            decommissioning: boolean;
            created_ts: string;
            updated_ts: string;
            auth_sets: {
                id: string;
                identity_data: {
                    mac: string;
                };
                pubkey: string;
                ts: string;
                status: string;
            }[];
        };
        c1: {
            id: string;
            auth_sets: never[];
            attributes: {
                device_type: string[];
            };
        };
    };
    byStatus: {
        accepted: {
            deviceIds: string[];
            total: number;
        };
        active: {
            deviceIds: never[];
            total: number;
        };
        inactive: {
            deviceIds: never[];
            total: number;
        };
        pending: {
            deviceIds: string[];
            total: number;
        };
        preauthorized: {
            deviceIds: never[];
            total: number;
        };
        rejected: {
            deviceIds: never[];
            total: number;
        };
    };
    deviceList: {
        deviceIds: never[];
        isLoading: boolean;
        page: number;
        perPage: number;
        selectedAttributes: never[];
        selectedIssues: never[];
        selection: never[];
        sort: {
            direction: "desc";
        };
        state: string;
        total: number;
    };
    filteringAttributes: {
        identityAttributes: string[];
        inventoryAttributes: string[];
        systemAttributes: never[];
        tagAttributes: never[];
    };
    filteringAttributesLimit: number;
    filters: never[];
    groups: {
        byId: {
            testGroup: {
                deviceIds: string[];
                filters: never[];
                total: number;
            };
            testGroupDynamic: {
                readonly id: "filter1";
                readonly name: "filter1";
                readonly filters: readonly [{
                    readonly scope: "system";
                    readonly key: "group";
                    readonly operator: "$eq";
                    readonly value: "things";
                }];
            };
        };
        selectedGroup: undefined;
    };
    limit: number;
    filteringAttributesConfig: {
        attributes: Record<string, string[]>;
        count: number;
        limit: number;
    };
    reports: {
        items: {
            count: number;
            key: string;
        }[];
        otherCount: number;
        total: number;
    }[];
    total: number;
};

export { mockState };
