"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Confirm.tsx
var Confirm_exports = {};
__export(Confirm_exports, {
  Confirm: () => Confirm,
  ConfirmationButtons: () => ConfirmationButtons,
  EditButton: () => EditButton,
  confirmationType: () => confirmationType,
  default: () => Confirm_default
});
module.exports = __toCommonJS(Confirm_exports);
var import_react = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var defaultRemoving = "Removing...";
var confirmationType = {
  retry: {
    loading: "Creating new deployment...",
    message: "Confirm retry?"
  },
  abort: {
    loading: "Aborting...",
    message: "Confirm abort?"
  },
  chartRemoval: {
    loading: defaultRemoving,
    message: "Remove this chart?"
  },
  decommissioning: {
    loading: "Decommissioning...",
    message: "Decommission this device and remove all of its data from the server. This cannot be undone. Are you sure?"
  },
  deploymentContinuation: {
    loading: "Continuing...",
    message: "All devices with no errors will continue to the next step of the updates. Confirm continue?"
  },
  deploymentAbort: {
    loading: "Aborting...",
    message: "This will abort the deployment and attempt to roll back all devices. Confirm abort?"
  },
  integrationRemoval: {
    loading: defaultRemoving,
    message: "Remove the ingration. Are you sure?"
  },
  webhooksRemoval: {
    loading: defaultRemoving,
    message: "Delete all webhooks?"
  }
};
var Confirm = ({ action, cancel, classes = "", message = "", style = {}, type }) => {
  const [className, setClassName] = (0, import_react.useState)("fadeIn");
  const [loading, setLoading] = (0, import_react.useState)(false);
  const handleCancel = () => {
    setClassName("fadeOut");
    cancel();
  };
  const handleConfirm = () => {
    setLoading(true);
    action();
  };
  let notification = message;
  if (confirmationType[type]) {
    notification = loading ? confirmationType[type].loading : confirmationType[type].message;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `flexbox center-aligned ${className} ${classes}`, style: { marginRight: "12px", justifyContent: "flex-end", ...style }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "bold", children: notification }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { id: "confirmAbort", onClick: handleConfirm, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.CheckCircle, { className: "green" }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: handleCancel, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Cancel, { className: "red" }) })
  ] });
};
var EditButton = ({ onClick, disabled = false }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { onClick, size: "small", disabled, startIcon: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Edit, {}), style: { padding: 5 }, children: "Edit" });
var ConfirmationButtons = ({ onConfirm, onCancel }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox", children: [
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onConfirm, size: "small", "aria-label": "confirm", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Check, { color: "disabled" }) }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onCancel, size: "small", "aria-label": "cancel", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Close, { color: "disabled" }) })
] });
var Confirm_default = Confirm;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Confirm,
  ConfirmationButtons,
  EditButton,
  confirmationType
});
//# sourceMappingURL=Confirm.cjs.map