import {
  runValidations
} from "./chunk-4LPSFMP6.js";

// src/forms/TextInput.tsx
import { Controller, useFormContext } from "react-hook-form";
import { FormControl, FormHelperText, InputLabel, OutlinedInput } from "@mui/material";
import { jsx, jsxs } from "react/jsx-runtime";
var TextInput = ({
  autocomplete,
  className = "",
  control,
  controlRef,
  disabled,
  hint,
  id,
  InputLabelProps = {},
  InputProps = {},
  label,
  required,
  type,
  validations = "",
  numericValidations = {},
  value: passedValue = ""
}) => {
  const {
    clearErrors,
    formState: { errors },
    setError
  } = useFormContext();
  const errorKey = `${id}-error`;
  const validate = (value) => {
    if (disabled) {
      return true;
    }
    const { isValid, errortext } = runValidations({ id, required, validations, value, wasMaybeTouched: !!errors[id] });
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    return isValid || errortext;
  };
  return /* @__PURE__ */ jsx(
    Controller,
    {
      name: id,
      control,
      rules: { required, validate, ...numericValidations },
      render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ jsxs(FormControl, { className: `${className} ${required ? "required" : ""}`, error: Boolean(error?.message || errors[errorKey]), style: { width: 400 }, children: [
        /* @__PURE__ */ jsx(InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
        /* @__PURE__ */ jsx(
          OutlinedInput,
          {
            autoComplete: autocomplete,
            id,
            label,
            name: id,
            disabled,
            inputRef: (inputRef) => {
              ref(inputRef);
              if (controlRef) {
                controlRef.current = inputRef;
              }
            },
            value: value ?? passedValue,
            onChange: ({ target: { value: value2 } }) => onChange(value2),
            onBlur,
            placeholder: hint,
            type,
            ...InputProps
          }
        ),
        /* @__PURE__ */ jsx(FormHelperText, { children: (errors[errorKey] || error)?.message })
      ] })
    }
  );
};
var TextInput_default = TextInput;

export {
  TextInput,
  TextInput_default
};
//# sourceMappingURL=chunk-USKEIWER.js.map