<?php

class CfHub
{
    private $cfPdo;
    public const HOST_KEY_FIELD = 'hostkey';

    public function __construct(PDO $cfPdo)
    {
        $this->cfPdo = $cfPdo;
    }

    public function getHubInfo()
    {
        $hubData = $this->cfPdo->query('SELECT * FROM __hub ORDER BY update_ts DESC')->fetch(PDO::FETCH_ASSOC);

        if (isset($hubData[self::HOST_KEY_FIELD])) {
            $hostkey = $hubData[self::HOST_KEY_FIELD];
            $inventoryData = $this->cfPdo->query("SELECT values->'IPv4 addresses' as ip, 
                                                 values->'Uptime minutes' as uptime_minutes,
                                                 values->'Host name' as hostname
                                                 FROM __inventory 
                                                 WHERE hostkey = '$hostkey'")->fetch(PDO::FETCH_ASSOC);

            if (is_array($inventoryData)) {
                $inventoryData = array_map('json_decode', $inventoryData);

                foreach ($inventoryData as $key => $value) {
                    if (!isset($hubData[$key]) || $hubData[$key] == null) {
                        $hubData[$key] = $value;
                    }
                }
            }
        }

        return $hubData;
    }

    public function isHub($hostkey)
    {
        $stmt = $this->cfPdo->prepare('SELECT count(*) FROM __hub WHERE hostkey = ?');
        $stmt->execute([$hostkey]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        return $data['count'] === 1;
    }
}
