<?php
$cf_version_array = explode(".", CFE_CORE_VERSION);
$cf_major_minor_version = "$cf_version_array[0]" . "." . "$cf_version_array[1]";
?>

<div class="wizard" id="wizard-modal" data-title="Welcome to CFEngine">

    <div id="page1" class="wizard-card" data-cardname="page1">
        <p>Welcome to a new version of CFEngine's Mission Portal. We'd like to take you for a short tour.</p>
        <!-- add welcome_1st_screen.png here -->
        <p class="center wizard-image welcomewizard1b"></p>
        <div id="showAgain" class="checkbox">
            <label>
                <input type="checkbox" ng-model="$parent.welcomeWizardDisabled">
                Don't show me this welcome guide again.
            </label>
        </div>
    </div>

    <?php if(isActionAllowed('settings.mail')) { ?>
    <div id="page2" class="wizard-card" data-cardname="page2">
        <h3>Mail settings</h3>
        <div class="alert alert-error" style="display: none;">
          <div class="validation_content"> </div>
        </div>
        <p class="center margin-bottom">
            <?=  $this->load->view('/appsetting/mail_partial'); ?>
        </p>
        <p>
            Or, <a onclick="$('.wizard-next').click()">skip this step</a> and configure it later via the settings panel.
        </p>
    </div>
    <?php } ?>
    <div id="page3" class="wizard-card" data-cardname="page2">
        <h3>Multiple dashboards</h3>
        <p class="center margin-bottom wizard-image welcomewizard2"></p>
        <p>
        This version of Mission Portal offers fully customizable, multiple dashboards. Create several dashboards with different groupings of widgets, quickly switch between them, and share them with other users.
        </p>
    </div>

    <div id="page4" class="wizard-card" data-cardname="page3">
        <h3>Changes reporting</h3>
        <p class="margin-bottom center wizard-image changeswidget1"></p>
        <p>Add a Changes widget to your dashboard to see at a glance the changes that CFEngine has made to the infrastructure over the past 7 days - then drill down to greater detail by using the Changes reporting interface.</p>

    </div>

    <div id="page5" class="wizard-card" data-cardname="page4">
        <h3>Dashboard alerts</h3>
        <p class="center margin-bottom wizard-image welcome_2nd_screen"></p>
        <p>The dashboard contains informative widgets that you can customize to create alerts that are important to you. All alert state changes, e.g. from OK to triggered, are logged to the Event log.</p>
    </div>

    <div id="page6" class="wizard-card" data-cardname="page5">
        <h3 style="display:none">Dashboard</h3> <!-- wizard breaks with no h3 element -->
        <p class="float-right margin-left-small margin-top wizard-image widget_1"></p>
        <p class="margin-top-large">Alerts can have three different severities: low, medium and high. These are represented by rings in yellow, orange and red respectively, along with the percentage of hosts alerts have triggered on. Hovering over the widget will show all information in a convenient list.</p>
    </div>

    <div id="page7" class="wizard-card" data-cardname="page6">
        <h3 style="display:none">Dashboard</h3>
        <p>You are able to pause alerts during maintenance windows or while working on resolving an underlying issue to avoid unnecessary triggering and notifications.</p>
        <p class="margin-bottom-large wizard-image pausealert"></p>
        <p>Alerts can have three different states: OK, triggered, and paused. It is easy to filter by state on each widget's alert overview.</p>
    </div>



    <div id="page8" class="wizard-card" data-cardname="page7">
        <h3>Inventory Reports</h3>
        <p class="margin-bottom margin-top center wizard-image inventory_panel"></p>
        <p>Inventory reports allow for quick reporting on out-of-the-box attributes. The attributes are also extensible by tagging any CFEngine variable or class - such as the role of the host - inside your CFEngine policy. These custom attributes will be automatically added to the Mission Portal.</p>
    </div>


    <div id="page9" class="wizard-card" data-cardname="page8">
        <h3>Edit filter</h3>
        <p class="margin-bottom-large wizard-image wizard-inventory-filter"></p>
        <p class="no-margin">You can reduce the amount of data or find specific information by filtering on attributes and host groups. Filtering is independent of the data presented in the results table: you can filter on attributes without them being presented in the table of results.</p>

    </div>

    <div id="page10" class="wizard-card" data-cardname="page9">
        <h3 style="display:none">Inventory reports</h3>
        <p class="margin-bottom center wizard-image inventorycolumn"></p>
        <p>Add and remove columns from the results table in real time, and once you're happy with your report, save it, export it, or schedule it to be sent by email regularly.</p>
    </div>

    <div id="page11" class="wizard-card" data-cardname="page10">
        <h3 style="display:none">Learn more</h3>
        <div class="margin-top-large">
            <p class="float-left wizard-image happy-agent"></p>
            <p>If this is a fresh installation, CFEngine will now be collecting data from your hosts which can take up to 15 minutes.</p>
            <p>To learn more about the Mission Portal, visit <a target="_blank" href="https://docs.cfengine.com/docs/<?= htmlspecialchars($cf_major_minor_version) ?>/">the Mission Portal Overview guide</a> in the CFEngine documentation, or watch our <a target="_blank" href="https://cfengine.com/webinars/">webinars.</a></p>
        </div>
    </div>
</div>
