<?php

class ComplianceExport
{
    public function export(CF_Rule $rule): array
    {
        return [
            'id' => $rule->export_id,
            'name' => $rule->name,
            'description' => $rule->description,
            'type' => $rule->type,
            'condition_for' => $rule->conditionMustBeMet == true ? 'passing' : 'failing',
            'rules' => ($this->getRulesExporter($rule))->export(),
            'category' => $rule->category,
            'severity' => $rule->severity,
            'host_filter' => $rule->hostcontexts['includes'][0] ?? null
        ];
    }

    private function getRulesExporter(CF_Rule $rule)
    {
        $class = ucfirst($rule->type) . 'ConditionExport';
        $file  = __DIR__ . '/implementations/' . $class . '.php';
        if (file_exists($file) && include_once $file) {
            return new $class($rule);
        } else {
            throw new Exception('Class ' . $class . ' not found.');
        }
    }
}
