"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/AddonSelect.tsx
var AddonSelect_exports = {};
__export(AddonSelect_exports, {
  AddonSelect: () => AddonSelect
});
module.exports = __toCommonJS(AddonSelect_exports);
var import_react = require("react");
var import_material = require("@mui/material");
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime = require("react/jsx-runtime");
var AddonSelect = (props) => {
  const { onChange, initialState } = props;
  const [selectedAddons, setSelectedAddons] = (0, import_react.useState)(initialState);
  const onSelectedChange = ({ target: { value } }) => {
    setSelectedAddons(value);
    onChange(value);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.FormControl, { id: "addons-form", style: { maxWidth: 330 }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.InputLabel, { id: "addons-selection-label", children: "Select Addons" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_material.Select,
      {
        multiple: true,
        label: "Select Addons",
        labelId: "addons-selection-label",
        value: selectedAddons,
        onChange: onSelectedChange,
        renderValue: (selected) => selected.map((role) => "Mender " + import_constants.ADDONS[role].title).join(", "),
        children: Object.values(import_constants.ADDONS).map((addon) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.MenuItem, { id: addon.id, value: addon.id, children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Checkbox, { id: `${addon.id}-checkbox`, checked: selectedAddons.includes(addon.id) }),
          "Mender ",
          addon.title
        ] }, addon.id))
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.FormHelperText, { className: "info", children: "Select any add-ons you are interested in adding to your plan." })
  ] });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AddonSelect
});
//# sourceMappingURL=AddonSelect.cjs.map