import {
  SORTING_OPTIONS
} from "./chunk-7C4SQBEE.js";

// src/appSlice/index.ts
import { createSlice } from "@reduxjs/toolkit";
var sliceName = "app";
var getYesterday = () => {
  const today = /* @__PURE__ */ new Date();
  today.setDate(today.getDate() - 1);
  return today.toISOString();
};
var initialState = {
  cancelSource: void 0,
  commit: "",
  demoArtifactLink: "https://dgsbl4vditpls.cloudfront.net/mender-demo-artifact.mender",
  hostAddress: null,
  snackbar: {
    action: void 0,
    autoHideDuration: void 0,
    message: "",
    open: false,
    preventClickToCopy: false
  },
  // return boolean rather than organization details
  features: {
    hasAuditlogs: false,
    hasDeltaProgress: false,
    hasMultitenancy: false,
    hasDeviceConfig: false,
    hasDeviceConnect: false,
    hasFeedbackEnabled: false,
    hasMonitor: false,
    hasReporting: false,
    isHosted: true,
    isEnterprise: false
  },
  feedbackProbability: 0.3,
  firstLoginAfterSignup: false,
  hostedAnnouncement: "",
  docsVersion: "",
  recaptchaSiteKey: "",
  searchState: {
    deviceIds: [],
    searchTerm: "",
    searchTotal: 0,
    isSearching: false,
    sort: {
      direction: SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    }
  },
  sentry: {
    location: "",
    replaysSessionSampleRate: 0.1,
    tracesSampleRate: 1
  },
  stripeAPIKey: "",
  trackerCode: "",
  uploadsById: {
    // id: { progress: 0, cancelSource: undefined }
  },
  newThreshold: getYesterday(),
  offlineThreshold: getYesterday(),
  versionInformation: {
    Integration: "",
    "Mender-Client": "",
    "Mender-Artifact": "",
    "Meta-Mender": ""
  },
  yesterday: void 0
};
var appSlice = createSlice({
  name: sliceName,
  initialState,
  reducers: {
    setFeatures: (state, action) => {
      state.features = {
        ...state.features,
        ...action.payload
      };
    },
    setSnackbar: (state, { payload }) => {
      if (typeof payload === "string" || payload instanceof String) {
        state.snackbar = {
          ...initialState.snackbar,
          message: payload,
          open: !!payload
        };
        return;
      }
      const { message, autoHideDuration, action, preventClickToCopy = false } = payload;
      state.snackbar = {
        message,
        autoHideDuration,
        action,
        preventClickToCopy,
        open: !!message
      };
    },
    setFirstLoginAfterSignup: (state, action) => {
      state.firstLoginAfterSignup = action.payload;
    },
    setAnnouncement: (state, action) => {
      state.hostedAnnouncement = action.payload;
    },
    setSearchState: (state, action) => {
      state.searchState = {
        ...state.searchState,
        ...action.payload
      };
    },
    setOfflineThreshold: (state, action) => {
      state.offlineThreshold = action.payload;
    },
    initUpload: (state, action) => {
      const { id, upload } = action.payload;
      state.uploadsById[id] = upload;
    },
    uploadProgress: (state, action) => {
      const { id, progress } = action.payload;
      state.uploadsById[id] = {
        ...state.uploadsById[id],
        progress
      };
    },
    cleanUpUpload: (state, action) => {
      const { [action.payload]: current, ...remainder } = state.uploadsById;
      state.uploadsById = remainder;
    },
    setVersionInformation: (state, action) => {
      state.versionInformation = {
        ...state.versionInformation,
        ...action.payload
      };
    },
    setEnvironmentData: (state, action) => ({ ...state, ...action.payload })
  }
});
var actions = appSlice.actions;
var appSlice_default = appSlice.reducer;

export {
  sliceName,
  initialState,
  appSlice,
  actions,
  appSlice_default
};
//# sourceMappingURL=chunk-QYLGIR4W.js.map