"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/deploymentsSlice/constants.ts
var constants_exports = {};
__export(constants_exports, {
  DEFAULT_PENDING_INPROGRESS_COUNT: () => DEFAULT_PENDING_INPROGRESS_COUNT,
  DEPLOYMENT_ROUTES: () => DEPLOYMENT_ROUTES,
  DEPLOYMENT_STATES: () => DEPLOYMENT_STATES,
  DEPLOYMENT_TYPES: () => DEPLOYMENT_TYPES,
  defaultStats: () => defaultStats,
  deploymentDisplayStates: () => deploymentDisplayStates,
  deploymentPrototype: () => deploymentPrototype,
  deploymentStatesToSubstates: () => deploymentStatesToSubstates,
  deploymentStatesToSubstatesWithSkipped: () => deploymentStatesToSubstatesWithSkipped,
  deploymentSubstates: () => deploymentSubstates,
  installationSubstatesMap: () => installationSubstatesMap,
  listDefaultsByState: () => listDefaultsByState,
  pauseMap: () => pauseMap
});
module.exports = __toCommonJS(constants_exports);

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants.SORTING_OPTIONS.desc }
};
var DEFAULT_PENDING_INPROGRESS_COUNT = 10;
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var DEPLOYMENT_TYPES = {
  software: "software",
  configuration: "configuration"
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentDisplayStates = {
  finished: "Finished",
  scheduled: "Scheduled",
  skipped: "Skipped",
  paused: "Paused",
  pending: "Pending",
  inprogress: "In Progress",
  success: "Success",
  successes: "Success",
  failure: "Fail",
  failures: "Fail"
};
var deploymentPrototype = {
  devices: {},
  name: void 0,
  statistics: { status: {} }
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DEFAULT_PENDING_INPROGRESS_COUNT,
  DEPLOYMENT_ROUTES,
  DEPLOYMENT_STATES,
  DEPLOYMENT_TYPES,
  defaultStats,
  deploymentDisplayStates,
  deploymentPrototype,
  deploymentStatesToSubstates,
  deploymentStatesToSubstatesWithSkipped,
  deploymentSubstates,
  installationSubstatesMap,
  listDefaultsByState,
  pauseMap
});
//# sourceMappingURL=constants.cjs.map