"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/liststatehook.ts
var liststatehook_exports = {};
__export(liststatehook_exports, {
  defaultProcessors: () => defaultProcessors,
  useLocationParams: () => useLocationParams
});
module.exports = __toCommonJS(liststatehook_exports);
var import_react = require("react");
var import_react_router_dom = require("react-router-dom");

// src/locationutils.ts
var import_helpers = require("@northern.tech/utils/helpers");

// src/constants.ts
var import_constants4 = require("@northern.tech/utils/constants");

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants4.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants4.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants4.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants4.SORTING_OPTIONS.desc }
};
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var DEPLOYMENT_TYPES = {
  software: "software",
  configuration: "configuration"
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/devicesSlice/constants.ts
var emptyFilter = { key: null, value: "", operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, scope: "inventory" };
var geoAttributes = ["geo-lat", "geo-lon"].map((attribute) => ({ attribute, scope: "inventory" }));

// src/organizationSlice/constants.ts
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];

// src/locationutils.ts
var SEPARATOR = ":";
var defaultSelector = (result) => result[0];
var commonFields = {
  ...Object.keys(import_constants4.DEVICE_LIST_DEFAULTS).reduce((accu, key) => ({ ...accu, [key]: { parse: Number, select: defaultSelector, target: key } }), {}),
  id: { parse: String, select: (i) => i, target: "id" },
  issues: { parse: void 0, select: defaultSelector, target: "selectedIssues" },
  open: { parse: Boolean, select: defaultSelector, target: "open" }
};
var scopes = {
  identity: { delimiter: "identity", filters: [] },
  inventory: { delimiter: "inventory", filters: [] },
  monitor: { delimiter: "monitor", filters: [] },
  system: { delimiter: "system", filters: [] },
  tags: { delimiter: "tags", filters: [] }
};
var commonProcessor = (searchParams) => {
  const params = new URLSearchParams(searchParams);
  const pageState = Object.entries(commonFields).reduce((accu, [key, { parse, select, target }]) => {
    const values = params.getAll(key);
    if (!values.length) {
      return accu;
    }
    if (!parse) {
      accu[target] = values;
    } else {
      try {
        accu[target] = select(values.map(parse));
      } catch (error) {
        console.log("encountered faulty url param, continue...", error);
      }
    }
    return accu;
  }, {});
  Object.keys(commonFields).map((key) => params.delete(key));
  const sort = params.has("sort") ? params.getAll("sort").reduce((sortAccu, scopedQuery) => {
    const items = scopedQuery.split(SEPARATOR).reverse();
    return ["direction", "key", "scope"].reduce((accu, key, index) => {
      if (items[index]) {
        accu[key] = items[index];
      }
      return accu;
    }, sortAccu);
  }, {}) : void 0;
  params.delete("sort");
  return { pageState, params, sort };
};
var legacyDeviceQueryParse = (searchParams, filteringAttributes) => {
  const params = new URLSearchParams(searchParams);
  const result = Object.keys(scopes).reduce((accu, scope) => ({ ...accu, [scope]: [] }), {});
  if (params.get("group")) {
    result.inventory.push({ ...emptyFilter, key: "group", scope: "inventory", operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, value: params.get("group") });
    params.delete("group");
  }
  const filters = [...params.keys()].reduce(
    (accu, key) => params.getAll(key).reduce((innerAccu, value) => {
      const scope = Object.entries(filteringAttributes).reduce((foundScope, [currentScope, attributes]) => {
        if (foundScope) {
          return foundScope;
        }
        return attributes.includes(key) ? currentScope.substring(0, currentScope.indexOf("Attributes")) : foundScope;
      }, void 0) ?? import_constants4.ATTRIBUTE_SCOPES.inventory;
      innerAccu[scope].push({ ...emptyFilter, scope, key, operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, value });
      return innerAccu;
    }, accu),
    result
  );
  [...params.keys()].map((key) => params.delete(key));
  return { filters, params };
};
var scopedFilterParse = (searchParams) => {
  const params = new URLSearchParams(searchParams);
  const filters = Object.keys(scopes).reduce(
    (accu, scope) => {
      accu[scope] = [];
      if (!params.has(scope)) {
        return accu;
      }
      accu[scope] = params.getAll(scope).map((scopedQuery) => {
        const items = scopedQuery.split(SEPARATOR);
        return { ...emptyFilter, scope, key: items[0], operator: `$${items[1]}`, value: items.slice(2).join(SEPARATOR) };
      });
      return accu;
    },
    { ...scopes }
  );
  Object.keys(scopes).map((scope) => params.delete(scope));
  return { filters, params };
};
var parseDeviceQuery = (searchParams, extraProps = {}) => {
  let queryParams = new URLSearchParams(searchParams);
  const { filteringAttributes = {}, pageState = {} } = extraProps;
  const pageStateExtension = pageState.id?.length === 1 ? { open: true } : {};
  let scopedFilters;
  const refersOldStyleAttributes = Object.values(filteringAttributes).some((scopeValues) => scopeValues.some((scopedValue) => queryParams.get(scopedValue)));
  if (refersOldStyleAttributes && !Object.keys(scopes).some((scope) => queryParams.get(scope)) || queryParams.get("group")) {
    const { filters, params } = legacyDeviceQueryParse(queryParams, filteringAttributes);
    scopedFilters = filters;
    queryParams = params;
  } else {
    const { filters, params } = scopedFilterParse(queryParams);
    scopedFilters = filters;
    queryParams = params;
  }
  let groupName = "";
  const groupFilterIndex = scopedFilters.inventory.findIndex((filter) => filter.key === "group" && filter.operator === import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key);
  if (groupFilterIndex > -1) {
    groupName = scopedFilters.inventory[groupFilterIndex].value;
    scopedFilters.inventory.splice(groupFilterIndex, 1);
  }
  const detailsTab = queryParams.has("tab") ? queryParams.get("tab") : "";
  return { detailsTab, filters: Object.values(scopedFilters).flat(), groupName, ...pageStateExtension };
};
var formatSorting = (sort, { sort: sortDefault }) => {
  if (!sort || (0, import_helpers.deepCompare)(sort, sortDefault)) {
    return "";
  }
  const sortQuery = ["scope", "key", "direction"].reduce((accu, key) => {
    if (!sort[key]) {
      return accu;
    }
    accu.push(sort[key]);
    return accu;
  }, []).join(SEPARATOR);
  return `sort=${sortQuery}`;
};
var formatPageState = ({ selectedId, selectedIssues, page, perPage, sort }, { defaults }) => Object.entries({ page, perPage, id: selectedId, issues: selectedIssues, open: selectedId ? true : void 0 }).reduce(
  (accu, [key, value]) => {
    if (Array.isArray(value)) {
      accu.push(...value.map((item) => `${key}=${encodeURIComponent(item)}`));
    } else if ((import_constants4.DEVICE_LIST_DEFAULTS[key] != value || !import_constants4.DEVICE_LIST_DEFAULTS.hasOwnProperty(key)) && value) {
      accu.push(`${key}=${encodeURIComponent(value)}`);
    }
    return accu;
  },
  [formatSorting(sort, defaults)]
).filter((i) => i).join("&");
var stripFilterOperator = (operator) => operator.replaceAll("$", "");
var formatFilters = (filters) => {
  const result = filters.reduce(
    (accu, filter) => {
      const { scope = import_constants4.ATTRIBUTE_SCOPES.inventory, operator = "$eq" } = filter;
      accu[scope].add(`${scopes[scope].delimiter}=${filter.key}${SEPARATOR}${stripFilterOperator(operator)}${SEPARATOR}${encodeURIComponent(filter.value)}`);
      return accu;
    },
    Object.keys(scopes).reduce((accu, item) => ({ ...accu, [item]: /* @__PURE__ */ new Set() }), {})
  );
  return Object.values(result).map((filterSet) => [...filterSet]).flat();
};
var formatDeviceSearch = ({ pageState, filters, selectedGroup }) => {
  let activeFilters = [...filters];
  if (selectedGroup && selectedGroup !== import_constants4.ALL_DEVICES) {
    const isUngroupedGroup = selectedGroup === UNGROUPED_GROUP.id;
    activeFilters = isUngroupedGroup ? activeFilters.filter(
      (filter) => !(filter.key === "group" && filter.scope === import_constants4.ATTRIBUTE_SCOPES.system && filter.operator === import_constants4.DEVICE_FILTERING_OPTIONS.$nin.key)
    ) : activeFilters;
    const groupName = isUngroupedGroup ? UNGROUPED_GROUP.name : selectedGroup;
    activeFilters.push({ scope: import_constants4.ATTRIBUTE_SCOPES.inventory, key: "group", operator: import_constants4.DEVICE_FILTERING_OPTIONS.$eq.key, value: groupName });
  }
  const formattedFilters = formatFilters(activeFilters).filter((i) => i);
  if (pageState.detailsTab && pageState.selectedId) {
    formattedFilters.push(`tab=${pageState.detailsTab}`);
  }
  return formattedFilters.join("&");
};
var generateDevicePath = ({ pageState }) => {
  const { state: selectedState } = pageState;
  const path = ["/devices"];
  if (selectedState !== "") {
    path.push(selectedState);
  }
  return path.join("/");
};
var formatDates = ({ endDate, params, startDate, today, tonight }) => {
  if (endDate && endDate !== tonight) {
    params.set("endDate", endDate.split("T")[0]);
  }
  if (startDate && startDate !== today) {
    params.set("startDate", startDate.split("T")[0]);
  }
  return params;
};
var paramReducer = (accu, [key, value]) => {
  if (value) {
    accu.set(key, value);
  }
  return accu;
};
var formatAuditlogs = ({ pageState }, { today, tonight }) => {
  const { detail, endDate, startDate, type, user } = pageState;
  let params = new URLSearchParams();
  let userId = user;
  if (user?.id) {
    userId = user.id;
  }
  params = Object.entries({ objectId: detail, userId }).reduce(paramReducer, params);
  if (type) {
    params.set("objectType", type.value ?? type);
  }
  params = formatDates({ endDate, params, startDate, today, tonight });
  return params.toString();
};
var parseDateParams = (params, today, tonight) => {
  let endDate = tonight;
  if (params.get("endDate")) {
    endDate = (0, import_helpers.getISOStringBoundaries)(new Date(params.get("endDate"))).end;
  }
  let startDate = today;
  if (params.get("startDate")) {
    startDate = (0, import_helpers.getISOStringBoundaries)(new Date(params.get("startDate"))).start;
  }
  return { endDate, startDate };
};
var parseAuditlogsQuery = (params, { today, tonight }) => {
  const type = AUDIT_LOGS_TYPES.find((typeObject) => typeObject.value === params.get("objectType"));
  const { endDate, startDate } = parseDateParams(params, today, tonight);
  return {
    detail: params.get("objectId"),
    endDate,
    startDate,
    type,
    user: params.get("userId")
  };
};
var formatActiveDeployments = (pageState, { defaults }) => [DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.pending].reduce((accu, state) => {
  const { page, perPage } = pageState[state] ?? {};
  const stateDefaults = defaults[state] ?? {};
  const items = Object.entries({ page, perPage }).reverse().reduce((keyAccu, [key, value]) => {
    if (value && value !== stateDefaults[key] || keyAccu.length) {
      keyAccu.unshift(value || stateDefaults[key]);
    }
    return keyAccu;
  }, []);
  if (items.length) {
    accu.push(`${state}=${items.join(SEPARATOR)}`);
  }
  return accu;
}, []).filter((i) => i).join("&");
var formatDeployments = ({ deploymentObject, pageState }, { defaults, today, tonight }) => {
  const { state: selectedState, showCreationDialog } = pageState.general;
  let params = new URLSearchParams();
  if (showCreationDialog) {
    params.set("open", true);
    if (deploymentObject.release) {
      params.set("release", deploymentObject.release.name);
    }
    if (deploymentObject.devices?.length) {
      deploymentObject.devices.map(({ id }) => params.append("deviceId", id));
    }
  }
  let pageStateQuery;
  if (selectedState === DEPLOYMENT_ROUTES.finished.key) {
    const { endDate, search, startDate, type } = pageState[selectedState];
    params = formatDates({ endDate, params, startDate, today, tonight });
    params = Object.entries({ search, type }).reduce(paramReducer, params);
    pageStateQuery = formatPageState(pageState[selectedState], { defaults });
  } else if (selectedState === DEPLOYMENT_ROUTES.scheduled.key) {
    pageStateQuery = formatPageState(pageState[selectedState], { defaults });
  } else {
    pageStateQuery = formatActiveDeployments(pageState, { defaults });
  }
  return [pageStateQuery, params.toString()].filter((i) => i).join("&");
};
var deploymentsPath = "deployments/";
var parseDeploymentsPath = (path) => {
  const parts = path.split(deploymentsPath);
  if (parts.length > 1 && Object.keys(DEPLOYMENT_ROUTES).includes(parts[1])) {
    return parts[1];
  }
  return "";
};
var parseActiveDeployments = (params) => [DEPLOYMENT_STATES.inprogress, DEPLOYMENT_STATES.pending].reduce((accu, state) => {
  if (!params.has(state)) {
    return accu;
  }
  const items = params.get(state).split(SEPARATOR);
  accu[state] = ["page", "perPage"].reduce((stateAccu, key, index) => items[index] ? { ...stateAccu, [key]: Number(items[index]) } : stateAccu, {});
  return accu;
}, {});
var deploymentFields = {
  deviceId: { attribute: "devices", parse: (id) => ({ id }), select: (i) => i },
  release: { attribute: "release", parse: String, select: defaultSelector }
};
var parseDeploymentsQuery = (params, { pageState, location, tonight }) => {
  const { endDate, startDate } = parseDateParams(params, "", tonight);
  const deploymentObject = Object.entries(deploymentFields).reduce(
    (accu, [key, { attribute, parse, select }]) => params.has(key) ? { ...accu, [attribute]: select(params.getAll(key).map(parse)) } : accu,
    {}
  );
  const { state: selectedState, id, open, ...remainingPageState } = pageState;
  const tab = parseDeploymentsPath(location.pathname);
  const deploymentsTab = tab || selectedState || DEPLOYMENT_ROUTES.active.key;
  let state = {
    deploymentObject,
    general: {
      showCreationDialog: Boolean(open && !id),
      showReportDialog: Boolean(open && id),
      state: deploymentsTab
    }
  };
  if (deploymentsTab === DEPLOYMENT_ROUTES.finished.key) {
    const type = DEPLOYMENT_TYPES[params.get("type")] || "";
    const search = params.get("search") || "";
    state[deploymentsTab] = { ...remainingPageState, endDate, search, startDate, type };
  } else if (deploymentsTab === DEPLOYMENT_ROUTES.scheduled.key) {
    state[deploymentsTab] = { ...remainingPageState };
  } else {
    state = {
      ...state,
      ...parseActiveDeployments(params)
    };
  }
  return state;
};
var generateDeploymentsPath = ({ pageState }) => {
  const { state: selectedState = DEPLOYMENT_ROUTES.active.key } = pageState.general;
  return `/deployments/${selectedState}`;
};
var releasesRoot = "/releases";
var formatReleases = ({ pageState: { searchTerm, selectedTags = [], tab, type } }) => Object.entries({ name: searchTerm, tab, type }).reduce(
  (accu, [key, value]) => value ? [...accu, `${key}=${value}`] : accu,
  selectedTags.map((tag) => `tag=${tag}`)
).join("&");
var generateReleasesPath = ({ pageState: { selectedRelease } }) => `${releasesRoot}${selectedRelease ? `/${encodeURIComponent(selectedRelease)}` : ""}`;
var parseReleasesQuery = (queryParams, extraProps) => {
  const name = queryParams.has("name") ? queryParams.get("name") : "";
  const tab = queryParams.has("tab") ? queryParams.get("tab") : void 0;
  const tags = queryParams.has("tag") ? queryParams.getAll("tag") : [];
  const type = queryParams.has("type") ? queryParams.get("type") : "";
  let selectedRelease = decodeURIComponent(extraProps.location.pathname.substring(releasesRoot.length + 1));
  if (!selectedRelease && extraProps.pageState.id?.length) {
    selectedRelease = extraProps.pageState.id[0];
  }
  return { searchTerm: name, selectedRelease, tab, tags, type };
};
var tenantsRoot = "/tenants";
var generateTenantPath = ({ pageState: { selectedTenant } }) => {
  if (selectedTenant) {
    return `${tenantsRoot}/${encodeURIComponent(selectedTenant)}`;
  } else {
    return tenantsRoot;
  }
};
var parseTenantsQuery = (queryParams, extraProps) => {
  const name = queryParams.has("name") ? queryParams.get("name") : "";
  let selectedTenant = extraProps.location.pathname.substring(tenantsRoot.length + 1);
  if (!selectedTenant && extraProps.pageState.id?.length) {
    selectedTenant = extraProps.pageState.id[0];
  }
  return { name, selectedTenant };
};
var formatTenants = () => "";

// src/liststatehook.ts
var defaultProcessors = {
  auditlogs: {
    format: formatAuditlogs,
    locate: () => void 0,
    parse: parseAuditlogsQuery
  },
  common: {
    format: formatPageState,
    locate: () => void 0,
    parse: commonProcessor
  },
  deployments: {
    format: formatDeployments,
    locate: generateDeploymentsPath,
    parse: parseDeploymentsQuery
  },
  devices: {
    format: formatDeviceSearch,
    locate: generateDevicePath,
    parse: parseDeviceQuery
  },
  releases: {
    format: formatReleases,
    locate: generateReleasesPath,
    parse: parseReleasesQuery
  },
  tenants: {
    format: formatTenants,
    locate: generateTenantPath,
    parse: parseTenantsQuery
  }
};
var useLocationParams = (key, extras, processors = defaultProcessors) => {
  const [searchParams] = (0, import_react_router_dom.useSearchParams)();
  const navigate = (0, import_react_router_dom.useNavigate)();
  const location = (0, import_react_router_dom.useLocation)();
  const value = (0, import_react.useMemo)(() => {
    const { pageState, params, sort } = processors.common.parse(searchParams);
    const extendedExtras = { ...extras, pageState, location };
    return {
      ...pageState,
      sort,
      ...processors[key].parse(params, extendedExtras)
    };
  }, [JSON.stringify(extras), key, location.search, location.pathname, searchParams.toString()]);
  const setValue = (0, import_react.useCallback)(
    (newValue, options = {}) => {
      const pathname = processors[key].locate({ pageState: newValue.pageState, location });
      const searchQuery = [processors.common.format(newValue.pageState, extras), processors[key].format(newValue, extras)].filter((i) => i).join("&");
      navigate({ pathname, replace: true, search: `?${searchQuery}`, ...options });
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [JSON.stringify(extras), key]
  );
  return [value, setValue];
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  defaultProcessors,
  useLocationParams
});
//# sourceMappingURL=liststatehook.cjs.map