<?php

class PersonalHostGroupEntity extends HostGroupEntity
{
    private string $owner;

    public function __construct(
        string                $owner = '',
        string                $name = '',
        stdClass|array|string $filter = new stdClass(),
        string|null           $description = '',
        ...$args
    ) {
        parent::__construct();
        !empty($owner) && $this->setOwner($owner);
        !empty($name) && $this->setName($name);
        !empty($description) && $this->setDescription($description);
        !empty((array)$filter) && $this->setFilter($filter);
    }


    /**
     * @return string
     */
    public function getOwner(): string
    {
        return $this->owner;
    }

    /**
     * @param string $owner
     */
    public function setOwner(string $owner): void
    {
        $this->changedItems[] = 'owner';
        $this->owner = $owner;
    }

    public function toArray(): array
    {
        return [
            'name' => $this->getName(),
            'description' => $this->getDescription(),
            'filter' => $this->getFilter(),
            'filter_sql' => $this->getFilterSql(),
            'owner' => $this->getOwner()
        ];
    }

    public function validate(): bool|InvalidArgumentException
    {
        if (empty($this->getOwner())) {
            throw new InvalidArgumentException('Group owner cannot be empty.');
        }

        Validator::name($this->getName());
        return true;
    }

    public static function sortableColumns(): array
    {
        return ['name', BaseHostGroupsModel::NAME_INT_SORT_COLUMN, 'id', 'creation_time', 'owner'];
    }
}
