<?php

require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class Timezone extends Cf_REST_Controller
{

    private $userName;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('ProfileModel');
        $this->userName = $this->session->userdata('username');
    }

    public function tz_modal_get()
    {
        try {
            $data = [
                'title' => 'Change Timezone',
                'new_timezone' => $this->ProfileModel->getTimeZone($this->input->get('new'))
            ];

            $newTZ = $this->input->get('new');
            if ($newTZ) {
                $data['new_timezone'] = $this->ProfileModel->getTimeZone($newTZ);
            }

            $this->load->view('timezone/update_modal', $data);
        } catch (Exception $e) {
            $this->errorHandler($e, 'timezone modal loading');
        }
    }

    public function isValidTimeZone_get()
    {
        try {
            $tz = $this->ProfileModel->getTimeZone($this->input->get('tz'));
            $isValid = isset($tz['value']) && !empty($tz['value']);
            respond_ok($isValid);
        } catch (Exception $e) {
            $this->errorHandler($e, 'timezone validation');
        }
    }

    public function neverAskAgain_get()
    {
        try {
            $result = $this->ProfileModel->getNeverAskTimeZoneChange($this->userName);
            respond_ok($result);
        } catch (Exception $e) {
            $this->errorHandler($e, 'retrieving timezone never ask again');
        }

    }

    public function neverAskAgain_post()
    {
        try {
            $this->ProfileModel->setNeverAskTimeZoneChange(1, $this->userName);
            respond_ok();
        } catch (Exception $e) {
            $this->errorHandler($e, 'updating timezone never ask again');
        }
    }

    public function useBrowserTime_get()
    {
        try {
            $result = $this->ProfileModel->getUseBrowserTime($this->userName);
            respond_ok($result);
        } catch (Exception $e) {
            $this->errorHandler($e, 'retrieving timezone never ask again');
        }

    }

    public function useBrowserTime_post()
    {
        try {
            $this->ProfileModel->setUseBrowserTime(1, $this->userName);
            respond_ok();
        } catch (Exception $e) {
            $this->errorHandler($e, 'updating timezone never ask again');
        }
    }

    public function profile_timezone_post()
    {
        try {
            $data = ['time_zone' => $this->input->post('time_zone')];
            $this->ProfileModel->updateProfile($data, $this->userName);
            respond_ok();
        } catch (Exception $e) {
            $this->errorHandler($e, 'updating profile\'s timezone');
        }
    }

    public function currentTimeZone_get()
    {
        try {
            $tz = $this->ProfileModel->getCurrentTimeZone($this->userName);
            respond_ok(json_encode($tz));
        } catch (Exception $e) {
            $this->errorHandler($e, 'retrieving profile timezone');
        }
    }

    private function errorHandler(Exception $e, $action)
    {
        $msg = $e->getMessage();
        log_message('error', "Failed $action, error: $msg");
        respond_internal_error($msg);
    }
}
