'use strict';
/*
 * Service to controll modal windows, based on angular (ui.bootstrap.modal)  http://angular-ui.github.io/bootstrap/
 */

reports.factory('modalWindowService', ['$rootScope', '$modal', 'notificationService', 'wizardSharedService', function($rootScope, $modal, notificationService, wizardSharedService) {
    var self = this;
    var $scope = {};
    var currentScope = {};




    $rootScope.$on('saveReport_saveSuccess_Event', function() {
        if (self.modal.isOpen) {
            self.modal.close();
        }
    });


    var modalInstance = {};

      self.modal= {
          isOpen: false, // true if any modal window opened
          openedWindowName: '',
          //controller: ModalInstanceCtrl,
          open: function(windowName, callerScope) {
            var className;
            if(windowName === 'showChartPopup') {
                className = "chart-modal";
              }
              currentScope = callerScope;

              notificationService.resetNotification(); //this is to previous notifications if any. Review

              modalInstance = $modal.open({
                templateUrl: windowName +'.html', // 'saveQuery.html',
                scope: currentScope,
                windowClass: className,
                controller: function($scope, $modalInstance) {
                    $scope.close = function() {
                    $modalInstance.close('cancel');
                };
                },
                resolve: {
                  items: function () {
                    return $scope.items;
                  }
                }
              });



              self.modal.isOpen = true;
              self.modal.openedWindowName = windowName;

              $rootScope.$broadcast('modalOpen', {'windowName': windowName} );

          },
          close: function(windowName, callerScope) {
              modalInstance.close('cancel');
              self.modal.isOpen = false;
              self.modal.openedWindowName = '';

              $rootScope.$broadcast('modalClose');
          }
      };

    return self.modal;

}]);