/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('changesWidgetHelper',
    ['$q', 'widgetHelper', '$window', '$location',
        function ($q, widgetHelper, $window, $location) {
            var helper = {};

            helper.goToChangesReport = function (daterange) {
                sessionStorage.removeItem('changes_report');
                var url = MP_SITE_URL + "/reports/changes";
                if (daterange !== undefined || angular.equals({}, daterange)) {
                    url += "?from=" + daterange.from + "&to=" + daterange.to;
                }
                $window.location.href = url;

            }

            helper.chartConfig = {

                chart: {
                    type: 'line',

                    events: {
                        click: function (e) {
                            helper.goToChangesReport()
                        }
                    },
                    backgroundColor: 'transparent'
                },
                exporting: {
                    enabled: false
                },
                plotOptions: {
                    line: {
                        allowPointSelect: false,
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    var daterange = {};
                                    daterange.from = moment().startOf('day').subtract((6 - this.x), 'days');
                                    daterange.to = moment().startOf('day').subtract((5 - this.x), 'days').subtract('1', 'milliseconds'); // remove a ms to keep within day
                                    helper.goToChangesReport(daterange);
                                }
                            }
                        }
                    },
                    series: {
                        borderWidth: 0,
                    }
                },
                colors: [widgetColors.mainColor()],
                tooltip: {
                    formatter: function () {
                        return 'Changes: ' + this.y;
                    }
                },
                legend: {
                    enabled: false
                },

                series: [{
                    data: []
                }],
                title: {
                    text: ''
                },
                subtitle: {
                    text: ''
                },
                xAxis: {
                    categories: [],
                    title: {
                        text: null
                    },
                    allowDecimals: false,
                    labels: {
                        style: {
                            fontWeight: "500",
                            fontSize: "11px",
                            color: "#7C7C7C"
                        }
                    },
                },
                yAxis: {
                    allowDecimals: false,
                    min: 0,
                    title: {
                        text: 'Changes by CFEngine'
                    }
                },
                credits: {
                    enabled: false
                },
                loading: false
            };

            helper.getChartConfig = function () {
                return {...helper.chartConfig, colors: [widgetColors.mainColor()]}
            }

            helper.getChangeStats = function (data) {

                return widgetHelper.getChangesStats(data).then(
                    function (result) {
                        return result;
                    },
                    function (error) {
                        // error
                    }
                );
            };


            helper.convertArray = function (arr) {
                var returnData = {};
                returnData.array = [];
                returnData.axis = [];

                angular.forEach(arr, function (value, key) {
                    returnData.axis.push(value.date);
                    returnData.array.push(value.count);
                });

                return returnData;
            };

            helper.setChartData = function (changeStats) {

                var convertedData = helper.convertArray(changeStats);
                helper.chartConfig.series[0] = {
                    data: convertedData.array
                };
                helper.chartConfig.xAxis.categories = convertedData.axis;

            };


            return helper;
        }]);