// src/debouncehook.ts
import { useEffect, useState } from "react";
var useDebounce = (value, delay) => {
  const [debouncedValue, setDebouncedValue] = useState(value);
  useEffect(() => {
    const timer = setTimeout(() => {
      setDebouncedValue(value);
    }, delay);
    return () => clearTimeout(timer);
  }, [value, delay]);
  return debouncedValue;
};

export {
  useDebounce
};
//# sourceMappingURL=chunk-FHPUPNI3.js.map