"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/Form.tsx
var Form_exports = {};
__export(Form_exports, {
  Form: () => Form,
  default: () => Form_default,
  runValidations: () => runValidations
});
module.exports = __toCommonJS(Form_exports);
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_validator = __toESM(require("validator"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var validationMethods = {
  isAlpha: "This field must contain only letters",
  isAlphanumeric: "This field must contain only letters or numbers",
  isEmail: "Please enter a valid email address",
  isHexadecimal: "The secret has to be entered as a hexadecimal string",
  isNumeric: "Please enter a valid code",
  isURL: "Please enter a valid URL",
  isUUID: "Please enter a valid ID"
};
var getErrorMsg = (validateMethod, args) => {
  if (validationMethods[validateMethod]) {
    return validationMethods[validateMethod];
  }
  switch (validateMethod) {
    case "isLength":
      if (Number(args[0]) === 1) {
        return "This field is required";
      } else if (args[0] > 1) {
        return `Must be at least ${args[0]} characters long`;
      }
      break;
    case "isAlphanumericLocator":
      if (args[0] && import_validator.default.matches(args[0], /^[a-zA-Z0-9_-]+$/)) {
        return "";
      } else {
        return "This please only enter valid characters. Valid characters are a-z, A-Z, 0-9, _ and -";
      }
    case "isNot":
      if (args[0] === args[1]) {
        return `This field should have a value other than ${args[0]}`;
      }
      break;
    default:
      return "There is an error with this field";
  }
};
var tryApplyValidationEntry = (value, validations = [], validationResults = []) => {
  const validation = validations.shift();
  if (!validation) {
    return validationResults.pop();
  }
  let args = validation.split(":");
  const validateMethod = args.shift();
  const tmpArgs = args;
  args = [value].concat(args);
  try {
    if (!import_validator.default[validateMethod](...args)) {
      return tryApplyValidationEntry(value, validations, [...validationResults, { errortext: getErrorMsg(validateMethod, tmpArgs), isValid: false }]);
    }
  } catch {
    const errortext = getErrorMsg(validateMethod, args) || "";
    return tryApplyValidationEntry(value, validations, [...validationResults, { errortext, isValid: !errortext }]);
  }
  return { errortext: "", isValid: true };
};
var tryApplyValidations = (value, validations, initialValidationResult) => validations.split(",").reduce((accu, validation) => {
  if (!accu.isValid || !validation) {
    return accu;
  }
  const alternatives = validation.split("||");
  return tryApplyValidationEntry(value, alternatives, [accu]);
}, initialValidationResult);
var runPasswordValidations = ({ required, value, validations, isValid, errortext }) => {
  if (required && !value) {
    return { isValid: false, errortext: "Password is required" };
  } else if (required || value) {
    const { isValid: validatedIsValid, errortext: validatedErrortext } = tryApplyValidations(value, validations, { isValid, errortext });
    return { isValid: validatedIsValid, errortext: !validatedIsValid ? validatedErrortext ? validatedErrortext : "Password too weak" : errortext };
  }
  return { isValid, errortext };
};
var runValidations = ({ required, value, id, validations, wasMaybeTouched }) => {
  const isValid = true;
  const errortext = "";
  if (id && id.includes("password")) {
    return runPasswordValidations({ required, value, validations, isValid, errortext });
  } else {
    if (value || required || wasMaybeTouched && validations.includes("isLength:1")) {
      return tryApplyValidations(validations.includes("trim") ? value.trim() : value, validations, { isValid, errortext });
    }
  }
  return { isValid, errortext };
};
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  buttonWrapper: { display: "flex", justifyContent: "flex-end", height: "min-content", marginTop: theme.spacing(4) },
  cancelButton: { marginRight: theme.spacing() }
}));
var Form = ({
  autocomplete,
  buttonColor,
  children,
  className = "",
  classes = { buttonWrapper: "", cancelButton: "" },
  defaultValues = {},
  handleCancel,
  id,
  initialValues = {},
  onSubmit,
  showButtons,
  submitLabel,
  submitRef
}) => {
  const { classes: internalClasses } = useStyles();
  const methods = (0, import_react_hook_form.useForm)({ mode: "onChange", defaultValues });
  const {
    handleSubmit,
    formState: { isValid },
    setValue
  } = methods;
  (0, import_react.useEffect)(() => {
    if (submitRef) {
      submitRef.current = handleSubmit(onSubmit);
    }
  }, [handleSubmit, onSubmit, submitRef]);
  (0, import_react.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_hook_form.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("form", { autoComplete: autocomplete, className, id, noValidate: true, onSubmit: handleSubmit(onSubmit), children: [
    children,
    !!showButtons && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `button-wrapper ${internalClasses.buttonWrapper} ${classes.buttonWrapper}`, children: [
      !!handleCancel && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { className: `${internalClasses.cancelButton} ${classes.cancelButton}`, onClick: handleCancel, children: "Cancel" }, "cancel"),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { variant: "contained", type: "submit", disabled: !isValid, color: buttonColor, children: submitLabel })
    ] })
  ] }) });
};
var Form_default = Form;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Form,
  runValidations
});
//# sourceMappingURL=Form.cjs.map