import { DEVICE_STATES } from '@northern.tech/utils/constants';
import { FilterOperator } from '../commonConstants.js';
import 'react/jsx-runtime';
import '@northern.tech/types/MenderTypes';

declare const emptyFilter: {
    key: null;
    value: string;
    operator: FilterOperator;
    scope: string;
};
declare const DEVICE_MESSAGE_PROTOCOLS: {
    Shell: number;
};
declare const DEVICE_MESSAGE_TYPES: {
    Delay: string;
    New: string;
    Ping: string;
    Pong: string;
    Resize: string;
    Shell: string;
    Stop: string;
};
declare const DEVICE_DISMISSAL_STATE = "dismiss";
type DeviceAuthState = (typeof DEVICE_STATES)[keyof typeof DEVICE_STATES];
declare const DEVICE_CONNECT_STATES: {
    connected: string;
    disconnected: string;
    unknown: string;
};
declare const geoAttributes: {
    attribute: string;
    scope: string;
}[];
declare const REPORT_CHART_SIZE_LIMIT = 6;

export { DEVICE_CONNECT_STATES, DEVICE_DISMISSAL_STATE, DEVICE_MESSAGE_PROTOCOLS, DEVICE_MESSAGE_TYPES, type DeviceAuthState, REPORT_CHART_SIZE_LIMIT, emptyFilter, geoAttributes };
