/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/funnel3d
 * @requires highcharts
 * @requires highcharts/highcharts-3d
 * @requires highcharts/modules/cylinder
 *
 * Highcharts funnel module
 *
 * (c) 2010-2025 Kacper Madej
 *
 * License: www.highcharts.com/license
 */import*as t from"../highcharts.js";import"../highcharts-3d.js";import"./cylinder.js";var e={};e.n=t=>{var i=t&&t.__esModule?()=>t.default:()=>t;return e.d(i,{a:i}),i},e.d=(t,i)=>{for(var r in i)e.o(i,r)&&!e.o(t,r)&&Object.defineProperty(t,r,{enumerable:!0,get:i[r]})},e.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);let i=t.default;var r=e.n(i);let o=t.default.Color;var n=e.n(o);let s=t.default.RendererRegistry;var d=e.n(s);let{parse:h}=n(),{charts:a}=r(),{Element3D:l}=d().getRendererType().prototype,{merge:p}=r(),g=class extends l{constructor(){super(...arguments),this.mainParts=["top","bottom"],this.parts=["top","bottom","frontUpper","backUpper","frontLower","backLower","rightUpper","rightLower"],this.sideGroups=["upperGroup","lowerGroup"],this.sideParts={upperGroup:["frontUpper","backUpper","rightUpper"],lowerGroup:["frontLower","backLower","rightLower"]},this.pathType="funnel3d"}opacitySetter(t){let e=parseFloat(t),i=this.parts,r=a[this.renderer.chartIndex],o="group-opacity-"+e+"-"+r.index;if(this.parts=this.mainParts,this.singleSetterForParts("opacity",e),this.parts=i,!r.renderer.filterId){for(let t of(r.renderer.definition({tagName:"filter",attributes:{id:o},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"table",tableValues:"0 "+e}}]}]}),this.sideGroups))this[t].attr({filter:"url(#"+o+")"});if(this.renderer.styledMode)for(let t of(r.renderer.definition({tagName:"style",textContent:".highcharts-"+o+" {filter:url(#"+o+")}"}),this.sideGroups))this[t].addClass("highcharts-"+o)}return this}fillSetter(t){let e=h(t),i=e.rgba[3],r={top:h(t).brighten(.1).get(),bottom:h(t).brighten(-.2).get()};if(i<1?(e.rgba[3]=1,e=e.get("rgb"),this.attr({opacity:i})):e=t,e.linearGradient||e.radialGradient||!this.gradientForSides||(e={linearGradient:{x1:0,x2:1,y1:1,y2:1},stops:[[0,h(t).brighten(-.2).get()],[.5,t],[1,h(t).brighten(-.2).get()]]}),e.linearGradient)for(let t of this.sideGroups){let i=this[t].gradientBox,o=e.linearGradient,n=p(e,{linearGradient:{x1:i.x+o.x1*i.width,y1:i.y+o.y1*i.height,x2:i.x+o.x2*i.width,y2:i.y+o.y2*i.height}});for(let e of this.sideParts[t])r[e]=n}else if(p(!0,r,{frontUpper:e,backUpper:e,rightUpper:e,frontLower:e,backLower:e,rightLower:e}),e.radialGradient)for(let t of this.sideGroups){let e=this[t].gradientBox,i=e.x+e.width/2,r=e.y+e.height/2,o=Math.min(e.width,e.height);for(let e of this.sideParts[t])this[e].setRadialReference([i,r,o])}if(this.singleSetterForParts("fill",null,r),this.color=this.fill=t,e.linearGradient)for(let t of[this.frontLower,this.frontUpper]){let e=t.element,i=e&&this.renderer.gradients[e.gradient];i&&"userSpaceOnUse"!==i.attr("gradientUnits")&&i.attr({gradientUnits:"userSpaceOnUse"})}return this}adjustForGradient(){let t;for(let e of this.sideGroups){let i={x:Number.MAX_VALUE,y:Number.MAX_VALUE},r={x:-Number.MAX_VALUE,y:-Number.MAX_VALUE};for(let o of this.sideParts[e])t=this[o].getBBox(!0),i={x:Math.min(i.x,t.x),y:Math.min(i.y,t.y)},r={x:Math.max(r.x,t.x+t.width),y:Math.max(r.y,t.y+t.height)};this[e].gradientBox={x:i.x,width:r.x-i.x,y:i.y,height:r.y-i.y}}}zIndexSetter(){return this.finishedOnAdd&&this.adjustForGradient(),this.renderer.Element.prototype.zIndexSetter.apply(this,arguments)}onAdd(){this.adjustForGradient(),this.finishedOnAdd=!0}},{charts:c}=r(),{error:y,extend:f,merge:u}=r();function x(t){let e=this.element3d("funnel3d",t),i=this.styledMode,r={"stroke-width":1,stroke:"none"};for(let t of(e.upperGroup=this.g("funnel3d-upper-group").attr({zIndex:e.frontUpper.zIndex}).add(e),[e.frontUpper,e.backUpper,e.rightUpper]))i||t.attr(r),t.add(e.upperGroup);for(let t of(e.lowerGroup=this.g("funnel3d-lower-group").attr({zIndex:e.frontLower.zIndex}).add(e),[e.frontLower,e.backLower,e.rightLower]))i||t.attr(r),t.add(e.lowerGroup);return e.gradientForSides=t.gradientForSides,e}function w(t){this.getCylinderEnd||y("A required Highcharts module is missing: cylinder.js",!0,c[this.chartIndex]);let e=c[this.chartIndex],i=t.alphaCorrection=90-Math.abs(e.options.chart.options3d.alpha%180-90),r=this.cuboidPath.call(this,u(t,{depth:t.width,width:(t.width+t.bottom.width)/2})),o=r.isTop,n=!r.isFront,s=!!t.middle,d=this.getCylinderEnd(e,u(t,{x:t.x-t.width/2,z:t.z-t.width/2,alphaCorrection:i})),h=t.bottom.width,a=u(t,{width:h,x:t.x-h/2,z:t.z-h/2,alphaCorrection:i}),l=this.getCylinderEnd(e,a,!0),p=h,g=a,f=l,x=l,w;s&&(p=t.middle.width,g=u(t,{y:t.y+t.middle.fraction*t.height,width:p,x:t.x-p/2,z:t.z-p/2}),f=this.getCylinderEnd(e,g,!1),x=this.getCylinderEnd(e,g,!1));let m={top:d,bottom:l,frontUpper:this.getCylinderFront(d,f),zIndexes:{group:r.zIndexes.group,top:3*(0===o),bottom:3*(1===o),frontUpper:n?2:1,backUpper:n?1:2,rightUpper:n?2:1}};return m.backUpper=this.getCylinderBack(d,f),w=Math.min(p,t.width)/Math.max(p,t.width)!=1,m.rightUpper=this.getCylinderFront(this.getCylinderEnd(e,u(t,{x:t.x-t.width/2,z:t.z-t.width/2,alphaCorrection:w?-i:0}),!1),this.getCylinderEnd(e,u(g,{alphaCorrection:w?-i:0}),!s)),s&&(w=Math.min(p,h)/Math.max(p,h)!=1,u(!0,m,{frontLower:this.getCylinderFront(x,l),backLower:this.getCylinderBack(x,l),rightLower:this.getCylinderFront(this.getCylinderEnd(e,u(a,{alphaCorrection:w?-i:0}),!0),this.getCylinderEnd(e,u(g,{alphaCorrection:w?-i:0}),!1)),zIndexes:{frontLower:n?2:1,backLower:n?1:2,rightLower:n?1:2}})),m}let m=t.default.SeriesRegistry;var b=e.n(m);let{seriesTypes:{column:A}}=b(),{extend:z}=r();class L extends A.prototype.pointClass{}z(L.prototype,{shapeType:"funnel3d"});let{deg2rad:C}=r(),{pick:U}=r();function v(t,e,i,r){let o=e.options.chart.options3d,n=U(r,!!i&&e.inverted),s={x:e.plotWidth/2,y:e.plotHeight/2,z:o.depth/2,vd:U(o.depth,1)*U(o.viewDistance,0)},d=e.scale3d||1,h=C*o.beta*(n?-1:1),a=C*o.alpha*(n?-1:1),l={cosA:Math.cos(a),cosB:Math.cos(-h),sinA:Math.sin(a),sinB:Math.sin(-h)};return i||(s.x+=e.plotLeft,s.y+=e.plotTop),t.map(function(t){var e,i,r;let o=(e=(n?t.y:t.x)-s.x,i=(n?t.x:t.y)-s.y,r=(t.z||0)-s.z,{x:l.cosB*e-l.sinB*r,y:-l.sinA*l.sinB*e+l.cosA*i-l.cosB*l.sinA*r,z:l.cosA*l.sinB*e+l.sinA*i+l.cosA*l.cosB*r}),h=G(o,s,s.vd);return h.x=h.x*d+s.x,h.y=h.y*d+s.y,h.z=o.z*d+s.z,{x:n?h.y:h.x,y:n?h.x:h.y,z:h.z}})}function G(t,e,i){let r=i>0&&i<Number.POSITIVE_INFINITY?i/(t.z+e.z+i):1;return{x:t.x*r,y:t.y*r}}function M(t){let e=0,i,r;for(i=0;i<t.length;i++)r=(i+1)%t.length,e+=t[i].x*t[r].y-t[r].x*t[i].y;return e/2}let{noop:k}=r(),{perspective:F}={perspective:v,perspective3D:G,pointCameraDistance:function(t,e){let i=e.options.chart.options3d,r={x:e.plotWidth/2,y:e.plotHeight/2,z:U(i.depth,1)*U(i.viewDistance,0)+i.depth};return Math.sqrt(Math.pow(r.x-U(t.plotX,t.x),2)+Math.pow(r.y-U(t.plotY,t.y),2)+Math.pow(r.z-U(t.plotZ,t.z),2))},shapeArea:M,shapeArea3D:function(t,e,i){return M(v(t,e,i))}},{series:B,seriesTypes:{column:I}}=b(),{extend:S,merge:E,pick:P,relativeLength:T}=r();class W extends I{alignDataLabel(t,e,i){let r=t.dlBoxRaw,o=this.chart.inverted,n=t.plotY>P(this.translatedThreshold,this.yAxis.len),s=P(i.inside,!!this.options.stacking),d={x:r.x,y:r.y,height:0};i.align=P(i.align,!o||s?"center":n?"right":"left"),i.verticalAlign=P(i.verticalAlign,o||s?"middle":n?"top":"bottom"),"top"!==i.verticalAlign&&(d.y+=r.bottom/("bottom"===i.verticalAlign?1:2)),d.width=this.getWidthAt(d.y),this.options.reversed&&(d.width=r.fullWidth-d.width),s?d.x-=d.width/2:"left"===i.align?(i.align="right",d.x-=1.5*d.width):"right"===i.align?(i.align="left",d.x+=d.width/2):d.x-=d.width/2,t.dlBox=d,I.prototype.alignDataLabel.apply(this,arguments)}bindAxes(){B.prototype.bindAxes.apply(this,arguments),S(this.xAxis.options,{gridLineWidth:0,lineWidth:0,title:void 0,tickPositions:[]}),E(!0,this.yAxis.options,{gridLineWidth:0,title:void 0,labels:{enabled:!1}})}translate(){B.prototype.translate.apply(this,arguments);let t=this.chart,e=this.options,i=e.reversed,r=e.ignoreHiddenPoint,o=t.plotWidth,n=t.plotHeight,s=e.center,d=T(s[0],o),h=T(s[1],n),a=T(e.width,o),l=T(e.height,n),p=T(e.neckWidth,o),g=T(e.neckHeight,n),c=h-l/2+l-g,y=this.points,f=0,u=0,x,w,m,b,A,z,L,C,U;for(let t of(this.getWidthAt=w=function(t){return t>c||l===g?p:p+(a-p)*(1-(t-(h-l/2))/(l-g))},this.center=[d,h,l],this.centerX=d,y))r&&!1===t.visible||(f+=t.y);for(let o of y)L=null,m=f?o.y/f:0,z=(A=h-l/2+u*l)+m*l,x=w(A),C=z-A,(U={gradientForSides:P(o.options.gradientForSides,e.gradientForSides),x:d,y:A,height:C,width:x,z:1,top:{width:x}}).bottom={fraction:m,width:x=w(z)},A>=c?U.isCylinder=!0:z>c&&(L=z,x=w(c),z=c,U.bottom.width=x,U.middle={fraction:C?(c-A)/C:0,width:x}),i&&(U.y=A=h+l/2-(u+m)*l,U.middle&&(U.middle.fraction=1-(C?U.middle.fraction:0)),x=U.width,U.width=U.bottom.width,U.bottom.width=x),o.shapeArgs=S(o.shapeArgs,U),o.percentage=100*m,o.plotX=d,i?o.plotY=h+l/2-(u+m/2)*l:o.plotY=(A+(L||z))/2,b=F([{x:d,y:o.plotY,z:i?-(a-w(o.plotY))/2:-w(o.plotY)/2}],t,!0)[0],o.tooltipPos=[b.x,b.y],o.dlBoxRaw={x:d,width:w(o.plotY),y:A,bottom:U.height||0,fullWidth:a},r&&!1===o.visible||(u+=m)}}W.compose=function(t){let e=t.prototype;e.funnel3d||(e.Element3D.types.funnel3d=g,f(e,{funnel3d:x,funnel3dPath:w}))},W.defaultOptions=E(I.defaultOptions,{center:["50%","50%"],width:"90%",neckWidth:"30%",height:"100%",neckHeight:"25%",reversed:!1,gradientForSides:!0,animation:!1,edgeWidth:0,colorByPoint:!0,showInLegend:!1,dataLabels:{align:"right",crop:!1,inside:!1,overflow:"allow"}}),S(W.prototype,{pointClass:L,translate3dShapes:k}),b().registerSeriesType("funnel3d",W),e.d({},{}),e.d({},{}),W.compose(d().getRendererType());let N=r();export{N as default};