/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/tiledwebmap
 * @requires highcharts
 *
 * (c) 2009-2025
 *
 * License: www.highcharts.com/license
 */import*as e from"../highcharts.js";var t={};t.n=e=>{var o=e&&e.__esModule?()=>e.default:()=>e;return t.d(o,{a:o}),o},t.d=(e,o)=>{for(var r in o)t.o(o,r)&&!t.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:o[r]})},t.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t);let o=e.default;var r=t.n(o);let i={Esri:class{constructor(){this.defaultCredits="Tiles &copy; Esri &mdash; Source: Esri, DeLorme, NAVTEQ, USGS,  Intermap, iPC, NRCAN, Esri Japan, METI, Esri China (Hong Kong), Esri (Thailand), TomTom, 2012",this.initialProjectionName="WebMercator",this.themes={WorldStreetMap:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20},DeLorme:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/Specialty/DeLorme_World_Base_Map/MapServer/tile/{z}/{y}/{x}",minZoom:1,maxZoom:11,credits:"Tiles &copy; Esri &mdash; Copyright: &copy;2012 DeLorme"},WorldTopoMap:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20,credits:"Tiles &copy; Esri &mdash; Esri, DeLorme, NAVTEQ, TomTom, Intermap, iPC, USGS, FAO, NPS, NRCAN, GeoBase, Kadaster NL, Ordnance Survey, Esri Japan, METI, Esri China (Hong Kong), and the GIS User Community"},WorldImagery:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20,credits:"Tiles &copy; Esri &mdash; Source: Esri, i-cubed, USDA, USGS, AEX, GeoEye, Getmapping, Aerogrid, IGN, IGP, UPR-EGP, and the GIS User Community"},WorldTerrain:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Terrain_Base/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:13,credits:"Tiles &copy; Esri &mdash; Source: USGS, Esri, TANA, DeLorme, and NPS"},WorldShadedRelief:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Shaded_Relief/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:13,credits:"Tiles &copy; Esri &mdash; Source: Esri"},WorldPhysical:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/World_Physical_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:8,credits:"Tiles &copy; Esri &mdash; Source: US National Park Service"},NatGeoWorldMap:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/NatGeo_World_Map/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:16,credits:"Tiles &copy; Esri &mdash; National Geographic, Esri, DeLorme, NAVTEQ, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, iPC"},WorldGrayCanvas:{url:"https://server.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Base/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:16,credits:"Tiles &copy; Esri &mdash; Esri, DeLorme, NAVTEQ"}}}},LimaLabs:class{constructor(){this.defaultCredits='Map data &copy;2023 <a href="https://maps.lima-labs.com/">LimaLabs</a>',this.initialProjectionName="WebMercator",this.requiresApiKey=!0,this.themes={Standard:{url:"https://cdn.lima-labs.com/{zoom}/{x}/{y}.png?api={apikey}",minZoom:0,maxZoom:20}}}},OpenStreetMap:class{constructor(){this.defaultCredits='Map data &copy2023 <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a>',this.initialProjectionName="WebMercator",this.subdomains=["a","b","c"],this.themes={Standard:{url:"https://tile.openstreetmap.org/{zoom}/{x}/{y}.png",minZoom:0,maxZoom:19},Hot:{url:"https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png",minZoom:0,maxZoom:19},OpenTopoMap:{url:"https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png",minZoom:0,maxZoom:17,credits:`Map data: &copy; <a href="https://www.openstreetmap.org/copyright">
                OpenStreetMap</a> contributors, <a href="https://viewfinderpanoramas.org">SRTM</a> 
                | Map style: &copy; <a href="https://opentopomap.org">OpenTopoMap</a> 
                (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)`}}}},Stamen:class{constructor(){this.defaultCredits='&copy; Map tiles by <a href="https://stamen.com">Stamen Design</a>, under <a href="https://creativecommons.org/licenses/by/3.0">CC BY 3.0</a>. Data by <a href="https://openstreetmap.org">OpenStreetMap</a>, under <a href="https://www.openstreetmap.org/copyright">ODbL</a>',this.initialProjectionName="WebMercator",this.subdomains=["a","b","c","d"],this.themes={Toner:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/toner/{z}/{x}/{y}.png",minZoom:0,maxZoom:20},TonerBackground:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/toner-background/{z}/{x}/{y}.png",minZoom:0,maxZoom:20},TonerLite:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/toner-lite/{z}/{x}/{y}.png",minZoom:0,maxZoom:20},Terrain:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/terrain/{z}/{x}/{y}.png",minZoom:0,maxZoom:18},TerrainBackground:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/terrain-background/{z}/{x}/{y}.png",minZoom:0,maxZoom:18},Watercolor:{url:"https://stamen-tiles-{s}.a.ssl.fastly.net/watercolor/{z}/{x}/{y}.png",minZoom:1,maxZoom:16,credits:'&copy Map tiles by <a href="https://stamen.com">Stamen Design</a>, under <a href="https://creativecommons.org/licenses/by/3.0">CC BY 3.0</a>. Data by <a href="https://openstreetmap.org">OpenStreetMap</a>, under <a href="https://creativecommons.org/licenses/by-sa/3.0">CC BY SA</a>'}}}},Thunderforest:class{constructor(){this.defaultCredits='Maps &copy <a href="https://www.thunderforest.com">Thunderforest</a>, Data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap contributors</a>',this.initialProjectionName="WebMercator",this.requiresApiKey=!0,this.subdomains=["a","b","c"],this.themes={OpenCycleMap:{url:"https://{s}.tile.thunderforest.com/cycle/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Transport:{url:"https://{s}.tile.thunderforest.com/transport/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},TransportDark:{url:"https://{s}.tile.thunderforest.com/transport-dark/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},SpinalMap:{url:"https://{s}.tile.thunderforest.com/spinal-map/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Landscape:{url:"https://{s}.tile.thunderforest.com/landscape/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Outdoors:{url:"https://{s}.tile.thunderforest.com/outdoors/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Pioneer:{url:"https://{s}.tile.thunderforest.com/pioneer/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},MobileAtlas:{url:"https://{s}.tile.thunderforest.com/mobile-atlas/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22},Neighbourhood:{url:"https://{s}.tile.thunderforest.com/neighbourhood/{z}/{x}/{y}.png?apikey={apikey}",minZoom:0,maxZoom:22}}}},USGS:class{constructor(){this.defaultCredits='Tiles courtesy of the <a href="https://usgs.gov/">U.S. GeologicalSurvey</a>',this.initialProjectionName="WebMercator",this.themes={USTopo:{url:"https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20},USImagery:{url:"https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20},USImageryTopo:{url:"https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryTopo/MapServer/tile/{z}/{y}/{x}",minZoom:0,maxZoom:20}}}}},a=e.default.SeriesRegistry;var s=t.n(a);let{composed:n}=r(),{map:l}=s().seriesTypes,{addEvent:p,defined:m,error:h,merge:c,pick:d,pushUnique:y}=r();function u(e){let{geoBounds:t,chart:o}=e,r=(o.options.series||[]).filter(e=>"tiledwebmap"===e.type)[0];if(r&&r.provider&&r.provider.type&&!r.provider.url){let e=i[r.provider.type];if(m(e)){let{initialProjectionName:o}=new e;if(t){let{x1:e,y1:r,x2:i,y2:a}=t;this.recommendedMapView={projection:{name:o,parallels:[r,a],rotation:[-(e+i)/2]}}}else this.recommendedMapView={projection:{name:o},minZoom:0};return!1}h("Highcharts warning: Tiles Provider not defined in the Provider Registry.",!1)}return!0}class g extends l{constructor(){super(...arguments),this.redrawTiles=!1,this.isAnimating=!1}static compose(e){y(n,"TiledWebMapSeries")&&p(e,"onRecommendMapView",u)}lonLatToTile(e,t){let{lon:o,lat:r}=e;return{x:Math.floor((o+180)/360*Math.pow(2,t)),y:Math.floor((1-Math.log(Math.tan(r*Math.PI/180)+1/Math.cos(r*Math.PI/180))/Math.PI)/2*Math.pow(2,t))}}tileToLonLat(e,t,o){let r=e/Math.pow(2,o)*360-180,i=Math.PI-2*Math.PI*t/Math.pow(2,o);return{lon:r,lat:180/Math.PI*Math.atan(.5*(Math.exp(i)-Math.exp(-i)))}}drawPoints(){let e=this.chart,t=e.mapView;if(!t)return;let o=this.tiles=this.tiles||{},r=this.transformGroups=this.transformGroups||[],a=this,s=this.options.provider,{zoom:n}=t,l=d(t.projection.options.rotation&&t.projection.options.rotation[0],0),p=200*!e.renderer.forExport,c=e=>{for(let r of Object.keys(o))parseFloat(r)===(t.zoom<0?0:Math.floor(t.zoom))||a.minZoom&&(t.zoom<0?0:Math.floor(t.zoom))<a.minZoom&&parseFloat(r)===a.minZoom||a.maxZoom&&(t.zoom<0?0:Math.floor(t.zoom))>a.maxZoom&&parseFloat(r)===a.maxZoom?Object.keys(o[r].tiles).forEach((t,i)=>{o[r].tiles[t].animate({opacity:1},{duration:e},()=>{i===Object.keys(o[r].tiles).length-1&&(o[r].isActive=!0)})}):Object.keys(o[r].tiles).forEach((t,i)=>{o[r].tiles[t].animate({opacity:0},{duration:e,defer:e/2},()=>{o[r].tiles[t].destroy(),delete o[r].tiles[t],i===Object.keys(o[r].tiles).length-1&&(o[r].isActive=!1,o[r].loaded=!1)})})},y=n<0?0:Math.floor(n),u=Math.pow(2,y),g=.638436911716859*Math.pow(2,n)/(.638436911716859*Math.pow(2,y)),f=256*g;if(s&&(s.type||s.url)){if(s.type&&!s.url){let o=i[s.type];if(!m(o))return void h("Highcharts warning: Tiles Provider '"+s.type+"' not defined in the ProviderRegistry.",!1);let r=new o,a=r.initialProjectionName,n,l="";if(s.theme&&m(r.themes[s.theme]))n=r.themes[s.theme];else{let e=Object.keys(r.themes)[0];n=r.themes[e],h("Highcharts warning: The Tiles Provider's Theme '"+s.theme+"' is not defined in the Provider definition - falling back to '"+e+"'.",!1)}s.subdomain&&r.subdomains&&-1!==r.subdomains.indexOf(s.subdomain)?l=s.subdomain:m(r.subdomains)&&-1!==n.url.indexOf("{s}")&&(l=d(r.subdomains&&r.subdomains[0],""),h("Highcharts warning: The Tiles Provider's Subdomain '"+s.subdomain+"' is not defined in the Provider definition - falling back to '"+l+"'.",!1)),r.requiresApiKey&&(s.apiKey?n.url=n.url.replace("{apikey}",s.apiKey):(h("Highcharts warning: The Tiles Provider requires API Key to use tiles, use provider.apiKey to provide a token.",!1),n.url=n.url.replace("?apikey={apikey}",""))),s.url=n.url.replace("{s}",l),this.minZoom=n.minZoom,this.maxZoom=n.maxZoom;let p=d(e.userOptions.credits&&e.userOptions.credits.text,"Highcharts.com "+d(n.credits,r.defaultCredits));e.credits?e.credits.update({text:p}):e.addCredits({text:p,style:d(e.options.credits?.style,{})}),t.projection.options.name!==a&&h("Highcharts warning: The set projection is different than supported by Tiles Provider.",!1)}else t.projection.options.name||h("Highcharts warning: The set projection is different than supported by Tiles Provider.",!1);if(m(this.minZoom)&&y<this.minZoom?(u=Math.pow(2,y=this.minZoom),f=256*(g=.638436911716859*Math.pow(2,n)/(.638436911716859*Math.pow(2,y)))):m(this.maxZoom)&&y>this.maxZoom&&(u=Math.pow(2,y=this.maxZoom),f=256*(g=.638436911716859*Math.pow(2,n)/(.638436911716859*Math.pow(2,y)))),t.projection&&t.projection.def){t.projection.hasCoordinates=!0,r[y]||(r[y]=e.renderer.g().add(this.group));let i=(e,t,o,r)=>e.replace("{x}",t.toString()).replace("{y}",o.toString()).replace("{zoom}",r.toString()).replace("{z}",r.toString()),n=(n,l,m,h,d)=>{let y=n%u,g=l%u,x=y<0?y+u:y,M=g<0?g+u:g;if(!o[`${m}`].tiles[`${n},${l}`]&&s.url){let y=i(s.url,x,M,m);o[m].loaded=!1,o[`${m}`].tiles[`${n},${l}`]=e.renderer.image(y,n*f-h,l*f-d,f,f).attr({zIndex:2,opacity:0}).on("load",function(){s.onload&&s.onload.apply(this),(m===(t.zoom<0?0:Math.floor(t.zoom))||m===a.minZoom)&&(o[`${m}`].actualTilesCount++,o[`${m}`].howManyTiles===o[`${m}`].actualTilesCount&&(o[m].loaded=!0,a.isAnimating?a.redrawTiles=!0:(a.redrawTiles=!1,c(p)),o[`${m}`].actualTilesCount=0))}).add(r[m]),o[`${m}`].tiles[`${n},${l}`].posX=n,o[`${m}`].tiles[`${n},${l}`].posY=l,o[`${m}`].tiles[`${n},${l}`].originalURL=y}},m=t.pixelsToProjectedUnits({x:0,y:0}),h=t.projection.def.inverse([m.x,m.y]),d={lon:h[0]-l,lat:h[1]},g=t.pixelsToProjectedUnits({x:e.plotWidth,y:e.plotHeight}),x=t.projection.def.inverse([g.x,g.y]),M={lon:x[0]-l,lat:x[1]};(d.lat>t.projection.maxLatitude||M.lat<-1*t.projection.maxLatitude)&&(d.lat=t.projection.maxLatitude,M.lat=-1*t.projection.maxLatitude);let T=this.lonLatToTile(d,y),S=this.lonLatToTile(M,y),v=this.tileToLonLat(T.x,T.y,y),Z=t.projection.def.forward([v.lon+l,v.lat]),b=t.projectedUnitsToPixels({x:Z[0],y:Z[1]}),w=T.x*f-b.x,P=T.y*f-b.y;o[`${y}`]||(o[`${y}`]={tiles:{},isActive:!1,howManyTiles:0,actualTilesCount:0,loaded:!1}),o[`${y}`].howManyTiles=(S.x-T.x+1)*(S.y-T.y+1),o[`${y}`].actualTilesCount=0;for(let e=T.x;e<=S.x;e++)for(let t=T.y;t<=S.y;t++)n(e,t,y,w,P)}for(let r of Object.keys(o))for(let i of Object.keys(o[r].tiles))if(t.projection&&t.projection.def){let s=256*(.638436911716859*Math.pow(2,n)/(.638436911716859*Math.pow(2,parseFloat(r)))),h=o[r].tiles[Object.keys(o[r].tiles)[0]],{posX:d,posY:u}=o[r].tiles[i];if(m(d)&&m(u)&&m(h.posX)&&m(h.posY)){let n=this.tileToLonLat(h.posX,h.posY,parseFloat(r)),m=t.projection.def.forward([n.lon+l,n.lat]),g=t.projectedUnitsToPixels({x:m[0],y:m[1]}),f=h.posX*s-g.x,x=h.posY*s-g.y;if(e.renderer.globalAnimation&&e.hasRendered){let e=Number(o[r].tiles[i].attr("x")),t=Number(o[r].tiles[i].attr("y")),n=Number(o[r].tiles[i].attr("width")),l=Number(o[r].tiles[i].attr("height")),m=(a,p)=>{o[r].tiles[i].attr({x:e+(d*s-f-e)*p.pos,y:t+(u*s-x-t)*p.pos,width:n+(Math.ceil(s)+1-n)*p.pos,height:l+(Math.ceil(s)+1-l)*p.pos})};a.isAnimating=!0,o[r].tiles[i].attr({animator:0}).animate({animator:1},{step:m},function(){a.isAnimating=!1,a.redrawTiles&&(a.redrawTiles=!1,c(p))})}else(a.redrawTiles||parseFloat(r)!==y||(o[r].isActive||parseFloat(r)===y)&&Object.keys(o[r].tiles).map(e=>o[r].tiles[e]).some(e=>0===e.opacity))&&(a.redrawTiles=!1,c(p)),o[r].tiles[i].attr({x:d*s-f,y:u*s-x,width:Math.ceil(s)+1,height:Math.ceil(s)+1})}}}else h("Highcharts warning: Tiles Provider not defined in the Provider Registry.",!1)}update(){let{transformGroups:e}=this,t=this.chart,o=t.mapView,r=arguments[0],{provider:a}=r;if(e&&(e.forEach(e=>{0!==Object.keys(e).length&&e.destroy()}),this.transformGroups=[]),o&&!m(t.userOptions.mapView?.projection)&&a&&a.type){let e=i[a.type];if(e){let{initialProjectionName:t}=new e;o.update({projection:{name:t}})}}super.update.apply(this,arguments)}}g.defaultOptions=c(l.defaultOptions,{states:{inactive:{enabled:!1}}}),s().registerSeriesType("tiledwebmap",g);let f=r();f.TilesProviderRegistry=f.TilesProviderRegistry||i,g.compose(f.MapView);let x=r();export{x as default};