<div class="settingsPage">
    <div class="left-column">
        <?php
$this->load->view('appsetting/settingsSideBar.php');
?>
    </div>
    <div class="right-column">
        <div class="pageTitle">
            <h1>
                <span>Applications</span>
                <a class="btn btn-large pull-right"  href="<?php
echo site_url('apps/apprefresh') ?>">Refresh apps</a>
            </h1>
        </div>

        <div>

            <?php
if (($this->session->flashdata('message')) || (isset($message) && is_array($message)))
{
    $flashMessage = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
    $content = $flashMessage['content'];
    $content_class = $flashMessage['type'];
?>

                <div style="margin-top: 13px;">
                    <div class="alert <?php echo $content_class; ?>">
                        <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                        <?php
    echo $content; ?>
                    </div>
                </div>
            <?php
} ?>

                <?php
if (!empty($applications))
{
?>
                <form method="post" action="<?php
    echo site_url('apps/save') ?>">
                    <table class="table table-bordered table-hover">
                        <thead>
                        <tr>
                            <th class="" colspan="2">Name</th>
                            <th class="input-small">Url</th>
                            <th>Description</th>
                            <th class="input-mini">Order</th>
                            <th class="input-small">Status</th>
                        </tr>
                        </thead>
                        <tbody id="tabledivbody">
                        <?php
    $css_apps_classes = applicationsIconsToCSS_Stub();

    foreach ($applications as $app => $item)
    {
        $item['meta'] = json_decode($item['meta'], true);
        if (!empty($item['meta']['disabled']) && $item['meta']['disabled'])
        {
            // do not show the application is disabled flag is set

            continue;
        }
?>
                            <tr class="approw">
                                <?php
        if ($item['hascontroller'] != 0)
        { ?>
                                  <?php
            $appUrl = site_url($item['url']); ?>
                                <td width="20" style="text-align: center;">
                                    <a href="<?php
            echo $appUrl ?>"><i class="<?php
            echo (isset($css_apps_classes[$item['id']]) ? $css_apps_classes[$item['id']] : '') ?>"></i></a>
                                </td>
                                <td><a href="<?php
            echo $appUrl ?>"><?php
            echo (isset($item['meta']['name']) ? $item['meta']['name'] : '') ?></a></td>
                                <td><a href="<?php
            echo $appUrl ?>"><?php
            echo $item['url'] ?></a></td>
                                 <?php
        }
        else
        { ?>
                                    <td width="20" style="text-align: center;">
                                      <?php /* <img src="<?php echo base_url() . 'images/icons/' . $item['icon']; ?>" alt=""  width="20" /> */ ?>
                                        <i class="<?php
            echo (isset($css_apps_classes[$item['id']]) ? $css_apps_classes[$item['id']] : '') ?>"></i>
                                    </td>
                                    <td><p><?php
            echo (isset($item['meta']['name']) ? $item['meta']['name'] : '') ?></p></td>
                                    <td>This application doesn't have controller</td>
                                <?php
        } ?>
                                <td><?php
        echo (!empty($item['meta']['description']) ? $item['meta']['description'] : '') ?></td>
                                <td>
                                    <input type="hidden" name="apps[<?= htmlspecialchars($item['id']) ?>][displayindex]" 
                                           value="<= htmlspecialchars($item['displayindex']) ?>" size="3"  maxlength="3" class="input-mini app-order">
                                    <a href="javascript:void(0)" class="movedownlink"><i class="icon-arrow-down"></i></a>
                                    <a href="javascript:void(0)" class="moveuplink"><i class="icon-arrow-up"></i></a>
                                </td>
                                <td>
                                    <?php
        if ($item['state'] == 1)
        { ?>
                                        <div class="radio"><label><input type="radio" name="apps[<?= htmlspecialchars($item['id']) ?>][state]" value="1" checked>On</label></div>

                                        <div class="radio"><label><input type="radio" name="apps[<?= htmlspecialchars($item['id']) ?>][state]" value="0">Off</label></div>
                                    <?php
        }
        else
        { ?>
                                        <div class="radio"><label><input type="radio" name="apps[<?= htmlspecialchars($item['id']) ?>][state]" value="1" >On</label></div>

                                        <div class="radio"><label><input type="radio" name="apps[<?= htmlspecialchars($item['id']) ?>][state]" value="0" checked>Off</label></div>
                                    <?php
        } ?>
                                </td>
                              </tr>
                        <?php
    } ?>
                    </tbody>
                    </table>
                    <?php
}
?>
                    <div class="buttons">
                        <button class="btn btn-large btn-primary btn-large pull-right">Apply</button>
                    </div>
                </form>

        </div>



    </div>

</div>
<script type="text/javascript">

$("#tabledivbody").sortable({
    items: "tr",
    cursor: "move",
    opacity: 0.6,
    axis: "y",
    update: function(event, ui) {
        updatePositions();
    }
});

$(document).ready(function() {
    updatePositions();
});

function updatePositions() {
    var apps = $('#tabledivbody tr');
    apps.each(function(i) {
        $(this).find('input[type="hidden"]').val(i+1);
        i===0 ? $(this).find(".moveuplink").css('visibility','hidden'): $(this).find(".moveuplink").css('visibility','visible');
        i===apps.length-1 ? $(this).find(".movedownlink").css('visibility','hidden') : $(this).find(".movedownlink").css('visibility','visible');
    });
}

$(".moveuplink").click(function() {
    $(this).parents(".approw").insertBefore($(this).parents(".approw").prev());
    updatePositions();
});

$(".movedownlink").click(function() {
    $(this).parents(".approw").insertAfter($(this).parents(".approw").next());
    updatePositions();
});


</script>
