/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint es5: true */
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for welcomeWizards
 *
 **/

var WelcomeWizardServiceClass = Class.extend({
    URL: MP_SITE_URL + '/welcomeWizard/seenWizard',

    getSeenWizard: function () {
        return this.$http.get(this.URL, {cache: false});
    },

    changeSeenWizard: function (value) {
        return this.$http({
            method: 'post',
            url: this.URL,
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data: {seenWizard: value},
            cache: false
        })
    }
});

(function () {
    var welcomeWizardServiceProvider = Class.extend({
        instance: new WelcomeWizardServiceClass(),
        $get: ['$http', '$rootScope', function ($http, $rootScope) {
            this.instance.$http = $http;
            this.instance.$rootScope = $rootScope;
            return this.instance;
        }]
    });

    angular.module('welcomeWizardServiceModule', [])
        .provider('welcomeWizardService', welcomeWizardServiceProvider);
}());