<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

/**
 * Class DismissHealthDiagnostic
 */
class HealthDiagnostic extends Cf_REST_Controller
{
    /** @var null */
    private $username = null;

    function __construct()
    {
        parent::__construct();
        if (CLI === false) {
            $this->username = $this->session->userdata('username');
        }
        $this->load->model('health_diagnostic_model');
        $this->health_diagnostic_model->setUserName($this->username);
    }

    public function dismiss_post()
    {
        $hosts = $this->input->post('hosts');
        $type = $this->input->post('type');
        $this->health_diagnostic_model->dismissHosts($hosts, $type);
        $this->health_diagnostic_model->deleteCache();
        $this->respond_ok();
    }

    public function dismiss_delete($type, $hosts)
    {
        $hosts = explode('|', urldecode($hosts));
        $this->health_diagnostic_model->removeFromDismissed($hosts, $type);
        $this->health_diagnostic_model->deleteCache();
        $this->respond_ok();
    }

    public function dismiss_get($type)
    {
        $this->load->model('host_model');
        $hosts = $this->health_diagnostic_model->getDismissedHosts($type);
        $this->respond_ok(json_encode($hosts));
    }
}

