<div class="project-home">
    <?= $this->load->view('/partials/aside') ?>
    <main class="build-modules build-module-page">
        <?= $this->load->view('/partials/search') ?>
        <div class="build-module-page_main" ng-class="{external: module.external}">
            <div class="build-module-page_top">
                <div>
                    <h1 class="title">{{ module.name }}</h1>
                    <div ng-bind-html="module.description" class="description"></div>
                </div>
                <div>
                    <a ng-show="!module.addedVersion && !module.external" ng-disabled="project.classic_policy_set" ng-click="!project.classic_policy_set && addModule()" class="btn btn-info"><i class="bi bi-plus"></i> Add module</a>
                    <a ng-show="module.addedVersion || module.external" ng-click="removeModule()" class="btn btn-info"><i class="bi bi-x"></i> Remove module</a>
                </div>
            </div>

            <div ng-if="module.external" class="not-on-build">
                The module is not from the canonical index <a href="https://build.cfengine.com">build.cfengine.com</a>.
            </div>

            <div class="section details" ng-class="{closed: !details}">
                <a href="javascript:;" ng-init="details=true" ng-click="details=!details">Details</a>
                <div ng-show="details">
                    <div ng-if="module.downloads"><span>Downloads</span> {{ module.downloads }}</div>
                    <div ng-if="module.updated"><span>Updated</span> {{ module.updated }}</div>
                    <div  ng-if="module.version"><span>Version</span> {{ module.addedVersion || module.version }}
                        <a ng-click="openUpdateDialog()"
                           ng-show="(module.addedVersion && module.latestVersion) && module.addedVersion != module.latestVersion"
                           class="btn update btn-info btn-small"><i class="bi bi-info-circle-fill"></i> Update available</a>
                    </div>
                    <div>
                        <a ng-if="module.repo" href="{{ module.repo }}/tree/{{ module.commit }}/{{ module.subdirectory }}" target="_blank">Repository</a>
                        <a ng-if="!module.external" href="{{ module.repo  }}/issues" target="_blank">Report issue</a>
                    </div>
                </div>
            </div>
            <div module-data ng-if="project.classic_policy_set === false" project-id="projectID" module-name="moduleName" module-added="module.addedVersion || module.external"></div>
            <div ng-if="module.readme" class="section description" ng-class="{closed: !description}">
                <a href="javascript:;" ng-init="description=true" ng-click="description=!description">Description
                </a>
                <div ng-show="description" ng-bind-html="module.readme" class="description"></div>
            </div>
        </div>
    </main>
</div>

<script type="text/ng-template" id="confirmModuleUpdate.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
            <i class="bi bi-x"></i>
        </button>
        <h2>Update Module</h2>
    </div>
    <div class="modal-body">
        <div>
            Current version
            <span>{{ module.addedVersion }}</span>
        </div>
        <div>
            Latest version available
            <span>{{ module.latestVersion }} <a target="_blank" href="https://build.cfengine.com/modules/{{ module.name }}/">
                    View project website <i class="bi bi-box-arrow-up-right"></i>
                </a>
            </span>
        </div>
        <div>
            Comment (commit message)
            <span><input name="commitMessage" ng-model="commitMessage"/></span>
        </div>
    </div>
    <div class="modal-footer">
        <button class="btn btn-large btn-primary pull-right" ng-click="update()">
            Update
        </button>
        <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                 ng-click="close()">
            Cancel
        </button>
    </div>
</script>
